/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize$Typing;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ext.OptionalHandlerFactory;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.impl.IndexedStringListSerializer;
import com.fasterxml.jackson.databind.ser.impl.StringArraySerializer;
import com.fasterxml.jackson.databind.ser.impl.StringCollectionSerializer;
import com.fasterxml.jackson.databind.ser.std.BooleanSerializer;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumMapSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.InetAddressSerializer;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.ser.std.NullSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers;
import com.fasterxml.jackson.databind.ser.std.NumberSerializers$NumberSerializer;
import com.fasterxml.jackson.databind.ser.std.ObjectArraySerializer;
import com.fasterxml.jackson.databind.ser.std.SerializableSerializer;
import com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdContainerSerializers;
import com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.fasterxml.jackson.databind.ser.std.TimeZoneSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumValues;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;

public abstract class BasicSerializerFactory
extends SerializerFactory {
    protected static final HashMap _concrete = new HashMap();
    protected static final HashMap _concreteLazy = new HashMap();
    protected final SerializerFactoryConfig _factoryConfig;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;

    protected BasicSerializerFactory(SerializerFactoryConfig serializerFactoryConfig) {
        this._factoryConfig = serializerFactoryConfig == null ? new SerializerFactoryConfig() : serializerFactoryConfig;
    }

    public abstract SerializerFactory withConfig(SerializerFactoryConfig var1);

    public final SerializerFactory withAdditionalSerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalSerializers(serializers));
    }

    public final SerializerFactory withAdditionalKeySerializers(Serializers serializers) {
        return this.withConfig(this._factoryConfig.withAdditionalKeySerializers(serializers));
    }

    public final SerializerFactory withSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
        return this.withConfig(this._factoryConfig.withSerializerModifier(beanSerializerModifier));
    }

    public abstract JsonSerializer createSerializer(SerializerProvider var1, JavaType var2, BeanProperty var3);

    public JsonSerializer createKeySerializer(SerializationConfig serializationConfig, JavaType javaType) {
        Serializers serializers;
        if (!this._factoryConfig.hasKeySerializers()) {
            return null;
        }
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        JsonSerializer jsonSerializer = null;
        Iterator iterator = this._factoryConfig.keySerializers().iterator();
        while (iterator.hasNext() && (jsonSerializer = (serializers = (Serializers)iterator.next()).findSerializer(serializationConfig, javaType, beanDescription)) == null) {
        }
        return jsonSerializer;
    }

    public TypeSerializer createTypeSerializer(SerializationConfig serializationConfig, JavaType javaType) {
        BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        TypeResolverBuilder typeResolverBuilder = annotationIntrospector.findTypeResolver(serializationConfig, annotatedClass, javaType);
        Collection collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = serializationConfig.getDefaultTyper(javaType);
        } else {
            collection = serializationConfig.getSubtypeResolver().collectAndResolveSubtypes(annotatedClass, (MapperConfig)serializationConfig, annotationIntrospector);
        }
        if (typeResolverBuilder == null) {
            return null;
        }
        return typeResolverBuilder.buildTypeSerializer(serializationConfig, javaType, collection);
    }

    public final JsonSerializer getNullSerializer() {
        return NullSerializer.instance;
    }

    protected abstract Iterable customSerializers();

    protected final JsonSerializer findSerializerByLookup(JavaType javaType, SerializationConfig serializationConfig, BeanDescription beanDescription, boolean bl) {
        Class clazz = javaType.getRawClass();
        String string = clazz.getName();
        JsonSerializer jsonSerializer = (JsonSerializer)_concrete.get(string);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        Class clazz2 = (Class)_concreteLazy.get(string);
        if (clazz2 != null) {
            try {
                return (JsonSerializer)clazz2.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to instantiate standard serializer (of type " + clazz2.getName() + "): " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    protected final JsonSerializer findSerializerByAnnotations(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription) {
        Class clazz = javaType.getRawClass();
        if (JsonSerializable.class.isAssignableFrom(clazz)) {
            return SerializableSerializer.instance;
        }
        AnnotatedMethod annotatedMethod = beanDescription.findJsonValueMethod();
        if (annotatedMethod != null) {
            Method method = annotatedMethod.getAnnotated();
            if (serializerProvider.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess(method);
            }
            JsonSerializer jsonSerializer = this.findSerializerFromAnnotation(serializerProvider, annotatedMethod);
            return new JsonValueSerializer(method, jsonSerializer);
        }
        return null;
    }

    protected final JsonSerializer findSerializerByPrimaryType(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, boolean bl) {
        Class clazz = javaType.getRawClass();
        if (InetAddress.class.isAssignableFrom(clazz)) {
            return InetAddressSerializer.instance;
        }
        if (TimeZone.class.isAssignableFrom(clazz)) {
            return TimeZoneSerializer.instance;
        }
        if (Charset.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        JsonSerializer jsonSerializer = this.optionalHandlers.findSerializer(serializerProvider.getConfig(), javaType);
        if (jsonSerializer != null) {
            return jsonSerializer;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NumberSerializers$NumberSerializer.instance;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            Class clazz2 = clazz;
            return EnumSerializer.construct(clazz2, serializerProvider.getConfig(), beanDescription);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return CalendarSerializer.instance;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return DateSerializer.instance;
        }
        return null;
    }

    protected final JsonSerializer findSerializerByAddonType(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) {
        Class clazz = javaType.getRawClass();
        if (Iterator.class.isAssignableFrom(clazz)) {
            return this.buildIteratorSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return this.buildIterableSerializer(serializationConfig, javaType, beanDescription, bl);
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return ToStringSerializer.instance;
        }
        return null;
    }

    protected JsonSerializer findSerializerFromAnnotation(SerializerProvider serializerProvider, Annotated annotated) {
        Object object = serializerProvider.getAnnotationIntrospector().findSerializer(annotated);
        if (object == null) {
            return null;
        }
        return serializerProvider.serializerInstance(annotated, object);
    }

    protected JsonSerializer buildContainerSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanDescription beanDescription, BeanProperty beanProperty, boolean bl) {
        JavaType javaType2;
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2 = javaType.getContentType());
        if (typeSerializer != null) {
            bl = false;
        }
        JsonSerializer jsonSerializer = this._findContentSerializer(serializerProvider, beanDescription.getClassInfo(), beanProperty);
        if (javaType.isMapLikeType()) {
            MapLikeType mapLikeType = (MapLikeType)javaType;
            JsonSerializer jsonSerializer2 = this._findKeySerializer(serializerProvider, beanDescription.getClassInfo(), beanProperty);
            if (mapLikeType.isTrueMapType()) {
                return this.buildMapSerializer(serializationConfig, (MapType)mapLikeType, beanDescription, bl, jsonSerializer2, typeSerializer, jsonSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer jsonSerializer3 = serializers.findMapLikeSerializer(serializationConfig, (MapLikeType)javaType, beanDescription, jsonSerializer2, typeSerializer, jsonSerializer);
                if (jsonSerializer3 == null) continue;
                return jsonSerializer3;
            }
            return null;
        }
        if (javaType.isCollectionLikeType()) {
            CollectionLikeType collectionLikeType = (CollectionLikeType)javaType;
            if (collectionLikeType.isTrueCollectionType()) {
                return this.buildCollectionSerializer(serializationConfig, (CollectionType)collectionLikeType, beanDescription, beanProperty, bl, typeSerializer, jsonSerializer);
            }
            for (Serializers serializers : this.customSerializers()) {
                JsonSerializer jsonSerializer4 = serializers.findCollectionLikeSerializer(serializationConfig, (CollectionLikeType)javaType, beanDescription, typeSerializer, jsonSerializer);
                if (jsonSerializer4 == null) continue;
                return jsonSerializer4;
            }
            return null;
        }
        if (javaType.isArrayType()) {
            return this.buildArraySerializer(serializationConfig, (ArrayType)javaType, beanDescription, bl, typeSerializer, jsonSerializer);
        }
        return null;
    }

    protected JsonSerializer buildCollectionSerializer(SerializationConfig serializationConfig, CollectionType collectionType, BeanDescription beanDescription, BeanProperty beanProperty, boolean bl, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        Object object2;
        for (Object object2 : this.customSerializers()) {
            JsonSerializer jsonSerializer2 = object2.findCollectionSerializer(serializationConfig, collectionType, beanDescription, typeSerializer, jsonSerializer);
            if (jsonSerializer2 == null) continue;
            return jsonSerializer2;
        }
        Class clazz = collectionType.getRawClass();
        if (EnumSet.class.isAssignableFrom(clazz)) {
            object2 = collectionType.getContentType();
            if (!((JavaType)object2).isEnumType()) {
                object2 = null;
            }
            return StdContainerSerializers.enumSetSerializer((JavaType)object2);
        }
        object2 = collectionType.getContentType().getRawClass();
        if (this.isIndexedList(clazz)) {
            if (object2 == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
                return IndexedStringListSerializer.instance;
            }
            return StdContainerSerializers.indexedListSerializer(collectionType.getContentType(), bl, typeSerializer, beanProperty, jsonSerializer);
        }
        if (object2 == String.class && (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer))) {
            return StringCollectionSerializer.instance;
        }
        return StdContainerSerializers.collectionSerializer(collectionType.getContentType(), bl, typeSerializer, beanProperty, jsonSerializer);
    }

    protected boolean isIndexedList(Class clazz) {
        return RandomAccess.class.isAssignableFrom(clazz);
    }

    protected JsonSerializer buildMapSerializer(SerializationConfig serializationConfig, MapType mapType, BeanDescription beanDescription, boolean bl, JsonSerializer jsonSerializer, TypeSerializer typeSerializer, JsonSerializer jsonSerializer2) {
        Object object;
        for (Object object2 : this.customSerializers()) {
            object = object2.findMapSerializer(serializationConfig, mapType, beanDescription, jsonSerializer, typeSerializer, jsonSerializer2);
            if (object == null) continue;
            return object;
        }
        if (EnumMap.class.isAssignableFrom(mapType.getRawClass())) {
            Object object2;
            JavaType javaType = mapType.getKeyType();
            object2 = null;
            if (javaType.isEnumType()) {
                object = javaType.getRawClass();
                object2 = EnumValues.construct((Class)object, serializationConfig.getAnnotationIntrospector());
            }
            return new EnumMapSerializer(mapType.getContentType(), bl, (EnumValues)object2, typeSerializer, jsonSerializer2);
        }
        return MapSerializer.construct(serializationConfig.getAnnotationIntrospector().findPropertiesToIgnore(beanDescription.getClassInfo()), mapType, bl, typeSerializer, jsonSerializer, jsonSerializer2);
    }

    protected JsonSerializer buildArraySerializer(SerializationConfig serializationConfig, ArrayType arrayType, BeanDescription beanDescription, boolean bl, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        Class clazz = arrayType.getRawClass();
        if (jsonSerializer == null || ClassUtil.isJacksonStdImpl(jsonSerializer)) {
            if (String[].class == clazz) {
                return StringArraySerializer.instance;
            }
            JsonSerializer jsonSerializer2 = StdArraySerializers.findStandardImpl(clazz);
            if (jsonSerializer2 != null) {
                return jsonSerializer2;
            }
        }
        return new ObjectArraySerializer(arrayType.getContentType(), bl, typeSerializer, jsonSerializer);
    }

    protected JsonSerializer buildIteratorSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) {
        JavaType javaType2 = javaType.containedType(0);
        if (javaType2 == null) {
            javaType2 = TypeFactory.unknownType();
        }
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        return StdContainerSerializers.iteratorSerializer(javaType2, this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer, null), typeSerializer);
    }

    protected JsonSerializer buildIterableSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription, boolean bl) {
        JavaType javaType2 = javaType.containedType(0);
        if (javaType2 == null) {
            javaType2 = TypeFactory.unknownType();
        }
        TypeSerializer typeSerializer = this.createTypeSerializer(serializationConfig, javaType2);
        return StdContainerSerializers.iterableSerializer(javaType2, this.usesStaticTyping(serializationConfig, beanDescription, typeSerializer, null), typeSerializer);
    }

    protected JavaType modifyTypeByAnnotation(SerializationConfig serializationConfig, Annotated annotated, JavaType javaType) {
        Class clazz = serializationConfig.getAnnotationIntrospector().findSerializationType(annotated);
        if (clazz != null) {
            try {
                javaType = javaType.widenBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Failed to widen type " + javaType + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage());
            }
        }
        return BasicSerializerFactory.modifySecondaryTypesByAnnotation(serializationConfig, annotated, javaType);
    }

    protected static JavaType modifySecondaryTypesByAnnotation(SerializationConfig serializationConfig, Annotated annotated, JavaType javaType) {
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        if (javaType.isContainerType()) {
            Class clazz;
            Class clazz2 = annotationIntrospector.findSerializationKeyType(annotated, javaType.getKeyType());
            if (clazz2 != null) {
                if (!(javaType instanceof MapType)) {
                    throw new IllegalArgumentException("Illegal key-type annotation: type " + javaType + " is not a Map type");
                }
                try {
                    javaType = ((MapType)javaType).widenKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow key type " + javaType + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
            if ((clazz = annotationIntrospector.findSerializationContentType(annotated, javaType.getContentType())) != null) {
                try {
                    javaType = javaType.widenContentsBy(clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Failed to narrow content type " + javaType + " with content-type annotation (" + clazz.getName() + "): " + illegalArgumentException.getMessage());
                }
            }
        }
        return javaType;
    }

    protected JsonSerializer _findKeySerializer(SerializerProvider serializerProvider, Annotated annotated, BeanProperty beanProperty) {
        Object object;
        Object object2;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (beanProperty != null && (object2 = beanProperty.getMember()) != null && (object = annotationIntrospector.findKeySerializer((Annotated)object2)) != null) {
            return serializerProvider.serializerInstance((Annotated)object2, object);
        }
        object2 = annotationIntrospector.findKeySerializer(annotated);
        if (object2 != null) {
            return serializerProvider.serializerInstance(annotated, object2);
        }
        return null;
    }

    protected JsonSerializer _findContentSerializer(SerializerProvider serializerProvider, Annotated annotated, BeanProperty beanProperty) {
        Object object;
        Object object2;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (beanProperty != null && (object2 = beanProperty.getMember()) != null && (object = annotationIntrospector.findContentSerializer((Annotated)object2)) != null) {
            return serializerProvider.serializerInstance((Annotated)object2, object);
        }
        object2 = annotationIntrospector.findContentSerializer(annotated);
        if (object2 != null) {
            return serializerProvider.serializerInstance(annotated, object2);
        }
        return null;
    }

    protected boolean usesStaticTyping(SerializationConfig serializationConfig, BeanDescription beanDescription, TypeSerializer typeSerializer, BeanProperty beanProperty) {
        JavaType javaType;
        if (typeSerializer != null) {
            return false;
        }
        AnnotationIntrospector annotationIntrospector = serializationConfig.getAnnotationIntrospector();
        JsonSerialize$Typing jsonSerialize$Typing = annotationIntrospector.findSerializationTyping(beanDescription.getClassInfo());
        if (jsonSerialize$Typing != null ? jsonSerialize$Typing == JsonSerialize$Typing.STATIC : serializationConfig.isEnabled(MapperFeature.USE_STATIC_TYPING)) {
            return true;
        }
        if (beanProperty != null && (javaType = beanProperty.getType()).isContainerType()) {
            if (annotationIntrospector.findSerializationContentType(beanProperty.getMember(), beanProperty.getType()) != null) {
                return true;
            }
            if (javaType instanceof MapType && annotationIntrospector.findSerializationKeyType(beanProperty.getMember(), beanProperty.getType()) != null) {
                return true;
            }
        }
        return false;
    }

    protected Class _verifyAsClass(Object object, String string, Class clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == clazz || clazz2 == NoClass.class) {
            return null;
        }
        return clazz2;
    }

    static {
        _concrete.put(String.class.getName(), new StringSerializer());
        ToStringSerializer toStringSerializer = ToStringSerializer.instance;
        _concrete.put(StringBuffer.class.getName(), toStringSerializer);
        _concrete.put(StringBuilder.class.getName(), toStringSerializer);
        _concrete.put(Character.class.getName(), toStringSerializer);
        _concrete.put(Character.TYPE.getName(), toStringSerializer);
        NumberSerializers.addAll(_concrete);
        _concrete.put(Boolean.TYPE.getName(), new BooleanSerializer(true));
        _concrete.put(Boolean.class.getName(), new BooleanSerializer(false));
        NumberSerializers$NumberSerializer numberSerializers$NumberSerializer = new NumberSerializers$NumberSerializer();
        _concrete.put(BigInteger.class.getName(), numberSerializers$NumberSerializer);
        _concrete.put(BigDecimal.class.getName(), numberSerializers$NumberSerializer);
        _concrete.put(Calendar.class.getName(), CalendarSerializer.instance);
        DateSerializer dateSerializer = DateSerializer.instance;
        _concrete.put(java.util.Date.class.getName(), dateSerializer);
        _concrete.put(Timestamp.class.getName(), dateSerializer);
        _concrete.put(Date.class.getName(), new SqlDateSerializer());
        _concrete.put(Time.class.getName(), new SqlTimeSerializer());
        for (Map.Entry entry : new StdJdkSerializers().provide()) {
            Object v2 = entry.getValue();
            if (v2 instanceof JsonSerializer) {
                _concrete.put(((Class)entry.getKey()).getName(), (JsonSerializer)v2);
                continue;
            }
            if (v2 instanceof Class) {
                Class clazz = (Class)v2;
                _concreteLazy.put(((Class)entry.getKey()).getName(), clazz);
                continue;
            }
            throw new IllegalStateException("Internal error: unrecognized value of type " + entry.getClass().getName());
        }
        _concreteLazy.put(TokenBuffer.class.getName(), TokenBufferSerializer.class);
    }
}

