/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MappingIterator
implements Iterator {
    protected static final MappingIterator EMPTY_ITERATOR = new MappingIterator(null, null, null, null, false, null);
    protected final JavaType _type;
    protected final DeserializationContext _context;
    protected final JsonDeserializer _deserializer;
    protected JsonParser _parser;
    protected final boolean _closeParser;
    protected boolean _hasNextChecked;
    protected final Object _updatedValue;

    protected MappingIterator(JavaType javaType, JsonParser jsonParser, DeserializationContext deserializationContext, JsonDeserializer jsonDeserializer) {
        this(javaType, jsonParser, deserializationContext, jsonDeserializer, true, null);
    }

    protected MappingIterator(JavaType javaType, JsonParser jsonParser, DeserializationContext deserializationContext, JsonDeserializer jsonDeserializer, boolean bl, Object object) {
        JsonStreamContext jsonStreamContext;
        this._type = javaType;
        this._parser = jsonParser;
        this._context = deserializationContext;
        this._deserializer = jsonDeserializer;
        if (jsonParser != null && jsonParser.getCurrentToken() == JsonToken.START_ARRAY && !(jsonStreamContext = jsonParser.getParsingContext()).inRoot()) {
            jsonParser.clearCurrentToken();
        }
        this._closeParser = bl;
        this._updatedValue = object == null ? null : object;
    }

    protected static MappingIterator emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public boolean hasNext() {
        try {
            return this.hasNextValue();
        }
        catch (JsonMappingException jsonMappingException) {
            throw new RuntimeJsonMappingException(jsonMappingException.getMessage(), jsonMappingException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public Object next() {
        try {
            return this.nextValue();
        }
        catch (JsonMappingException jsonMappingException) {
            throw new RuntimeJsonMappingException(jsonMappingException.getMessage(), jsonMappingException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNextValue() {
        if (this._parser == null) {
            return false;
        }
        if (!this._hasNextChecked) {
            JsonToken jsonToken = this._parser.getCurrentToken();
            this._hasNextChecked = true;
            if (jsonToken == null) {
                jsonToken = this._parser.nextToken();
                if (jsonToken == null) {
                    JsonParser jsonParser = this._parser;
                    this._parser = null;
                    if (this._closeParser) {
                        jsonParser.close();
                    }
                    return false;
                }
                if (jsonToken == JsonToken.END_ARRAY) {
                    return false;
                }
            }
        }
        return true;
    }

    public Object nextValue() {
        Object object;
        if (!this._hasNextChecked && !this.hasNextValue()) {
            throw new NoSuchElementException();
        }
        if (this._parser == null) {
            throw new NoSuchElementException();
        }
        this._hasNextChecked = false;
        if (this._updatedValue == null) {
            object = this._deserializer.deserialize(this._parser, this._context);
        } else {
            this._deserializer.deserialize(this._parser, this._context, this._updatedValue);
            object = this._updatedValue;
        }
        this._parser.clearCurrentToken();
        return object;
    }
}

