/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonDeserializer$None;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class DeserializerCache {
    protected final ConcurrentHashMap _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    protected final HashMap _incompleteDeserializers = new HashMap(8);

    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    public JsonDeserializer findValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType);
        if (jsonDeserializer == null) {
            jsonDeserializer = this._handleUnknownValueDeserializer(javaType);
        }
        return jsonDeserializer;
    }

    public KeyDeserializer findKeyDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        KeyDeserializer keyDeserializer = deserializerFactory.createKeyDeserializer(deserializationContext, javaType);
        if (keyDeserializer == null) {
            return this._handleUnknownKeyDeserializer(javaType);
        }
        if (keyDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)keyDeserializer)).resolve(deserializationContext);
        }
        return keyDeserializer;
    }

    public boolean hasValueDeserializerFor(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer jsonDeserializer = this._findCachedDeserializer(javaType);
        if (jsonDeserializer == null) {
            try {
                jsonDeserializer = this._createAndCacheValueDeserializer(deserializationContext, deserializerFactory, javaType);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return jsonDeserializer != null;
    }

    protected JsonDeserializer _findCachedDeserializer(JavaType javaType) {
        if (javaType == null) {
            throw new IllegalArgumentException("Null JavaType passed");
        }
        return (JsonDeserializer)this._cachedDeserializers.get(javaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonDeserializer _createAndCacheValueDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        HashMap hashMap = this._incompleteDeserializers;
        synchronized (hashMap) {
            JsonDeserializer jsonDeserializer;
            block9: {
                JsonDeserializer jsonDeserializer2 = this._findCachedDeserializer(javaType);
                if (jsonDeserializer2 != null) {
                    return jsonDeserializer2;
                }
                int n2 = this._incompleteDeserializers.size();
                if (n2 > 0 && (jsonDeserializer2 = (JsonDeserializer)this._incompleteDeserializers.get(javaType)) != null) {
                    return jsonDeserializer2;
                }
                try {
                    jsonDeserializer = this._createAndCache2(deserializationContext, deserializerFactory, javaType);
                    if (n2 != 0 || this._incompleteDeserializers.size() <= 0) break block9;
                    this._incompleteDeserializers.clear();
                }
                catch (Throwable throwable) {
                    if (n2 == 0 && this._incompleteDeserializers.size() > 0) {
                        this._incompleteDeserializers.clear();
                    }
                    throw throwable;
                }
            }
            return jsonDeserializer;
        }
    }

    protected JsonDeserializer _createAndCache2(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        JsonDeserializer jsonDeserializer;
        try {
            jsonDeserializer = this._createDeserializer(deserializationContext, deserializerFactory, javaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JsonMappingException(illegalArgumentException.getMessage(), null, illegalArgumentException);
        }
        if (jsonDeserializer == null) {
            return null;
        }
        boolean bl = jsonDeserializer instanceof ResolvableDeserializer;
        boolean bl2 = jsonDeserializer.isCachable();
        if (bl) {
            this._incompleteDeserializers.put(javaType, jsonDeserializer);
            ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(deserializationContext);
            this._incompleteDeserializers.remove(javaType);
        }
        if (bl2) {
            this._cachedDeserializers.put(javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer _createDeserializer(DeserializationContext deserializationContext, DeserializerFactory deserializerFactory, JavaType javaType) {
        Class clazz;
        BeanDescription beanDescription;
        JsonDeserializer jsonDeserializer;
        DeserializationConfig deserializationConfig = deserializationContext.getConfig();
        if (javaType.isAbstract() || javaType.isMapLikeType() || javaType.isCollectionLikeType()) {
            javaType = deserializerFactory.mapAbstractType(deserializationConfig, javaType);
        }
        if ((jsonDeserializer = this.findDeserializerFromAnnotation(deserializationContext, (beanDescription = deserializationConfig.introspect(javaType)).getClassInfo())) != null) {
            return jsonDeserializer;
        }
        JavaType javaType2 = this.modifyTypeByAnnotation(deserializationContext, beanDescription.getClassInfo(), javaType);
        if (javaType2 != javaType) {
            javaType = javaType2;
            beanDescription = deserializationConfig.introspect(javaType2);
        }
        if ((clazz = beanDescription.findPOJOBuilder()) != null) {
            return deserializerFactory.createBuilderBasedDeserializer(deserializationContext, javaType, beanDescription, clazz);
        }
        if (javaType.isEnumType()) {
            return deserializerFactory.createEnumDeserializer(deserializationContext, javaType, beanDescription);
        }
        if (javaType.isContainerType()) {
            if (javaType.isArrayType()) {
                return deserializerFactory.createArrayDeserializer(deserializationContext, (ArrayType)javaType, beanDescription);
            }
            if (javaType.isMapLikeType()) {
                MapLikeType mapLikeType = (MapLikeType)javaType;
                if (mapLikeType.isTrueMapType()) {
                    return deserializerFactory.createMapDeserializer(deserializationContext, (MapType)mapLikeType, beanDescription);
                }
                return deserializerFactory.createMapLikeDeserializer(deserializationContext, mapLikeType, beanDescription);
            }
            if (javaType.isCollectionLikeType()) {
                CollectionLikeType collectionLikeType = (CollectionLikeType)javaType;
                if (collectionLikeType.isTrueCollectionType()) {
                    return deserializerFactory.createCollectionDeserializer(deserializationContext, (CollectionType)collectionLikeType, beanDescription);
                }
                return deserializerFactory.createCollectionLikeDeserializer(deserializationContext, collectionLikeType, beanDescription);
            }
        }
        if (JsonNode.class.isAssignableFrom(javaType.getRawClass())) {
            return deserializerFactory.createTreeDeserializer(deserializationConfig, javaType, beanDescription);
        }
        return deserializerFactory.createBeanDeserializer(deserializationContext, javaType, beanDescription);
    }

    protected JsonDeserializer findDeserializerFromAnnotation(DeserializationContext deserializationContext, Annotated annotated) {
        Object object = deserializationContext.getAnnotationIntrospector().findDeserializer(annotated);
        if (object == null) {
            return null;
        }
        return deserializationContext.deserializerInstance(annotated, object);
    }

    private JavaType modifyTypeByAnnotation(DeserializationContext deserializationContext, Annotated annotated, JavaType javaType) {
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        Class clazz = annotationIntrospector.findDeserializationType(annotated, javaType);
        if (clazz != null) {
            try {
                javaType = javaType.narrowBy(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new JsonMappingException("Failed to narrow type " + javaType + " with concrete-type annotation (value " + clazz.getName() + "), method '" + annotated.getName() + "': " + illegalArgumentException.getMessage(), null, illegalArgumentException);
            }
        }
        if (javaType.isContainerType()) {
            Object object;
            Object object2;
            Object object3;
            JavaType javaType2;
            Class clazz2 = annotationIntrospector.findDeserializationKeyType(annotated, javaType.getKeyType());
            if (clazz2 != null) {
                if (!(javaType instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + javaType + " is not a Map(-like) type");
                }
                try {
                    javaType = ((MapLikeType)javaType).narrowKey(clazz2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow key type " + javaType + " with key-type annotation (" + clazz2.getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if ((javaType2 = javaType.getKeyType()) != null && javaType2.getValueHandler() == null && (object3 = annotationIntrospector.findKeyDeserializer(annotated)) != null && (object2 = deserializationContext.keyDeserializerInstance(annotated, object3)) != null) {
                javaType = ((MapLikeType)javaType).withKeyValueHandler(object2);
                javaType2 = javaType.getKeyType();
            }
            if ((object3 = annotationIntrospector.findDeserializationContentType(annotated, javaType.getContentType())) != null) {
                try {
                    javaType = javaType.narrowContentsBy((Class)object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonMappingException("Failed to narrow content type " + javaType + " with content-type annotation (" + ((Class)object3).getName() + "): " + illegalArgumentException.getMessage(), null, illegalArgumentException);
                }
            }
            if (((JavaType)(object2 = javaType.getContentType())).getValueHandler() == null && (object = annotationIntrospector.findContentDeserializer(annotated)) != null) {
                JsonDeserializer jsonDeserializer = null;
                if (object instanceof JsonDeserializer) {
                    object = (JsonDeserializer)object;
                } else {
                    Class clazz3 = this._verifyAsClass(object, "findContentDeserializer", JsonDeserializer$None.class);
                    if (clazz3 != null) {
                        jsonDeserializer = deserializationContext.deserializerInstance(annotated, clazz3);
                    }
                }
                if (jsonDeserializer != null) {
                    javaType = javaType.withContentValueHandler(jsonDeserializer);
                }
            }
        }
        return javaType;
    }

    private Class _verifyAsClass(Object object, String string, Class clazz) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector." + string + "() returned value of type " + object.getClass().getName() + ": expected type JsonSerializer or Class<JsonSerializer> instead");
        }
        Class clazz2 = (Class)object;
        if (clazz2 == clazz || clazz2 == NoClass.class) {
            return null;
        }
        return clazz2;
    }

    protected JsonDeserializer _handleUnknownValueDeserializer(JavaType javaType) {
        Class clazz = javaType.getRawClass();
        if (!ClassUtil.isConcrete(clazz)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + javaType);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + javaType);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType javaType) {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + javaType);
    }
}

