/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class DOMSerializer
extends StdSerializer {
    protected final DOMImplementationLS _domImpl;

    public DOMSerializer() {
        super(Node.class);
        DOMImplementationRegistry dOMImplementationRegistry;
        try {
            dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not instantiate DOMImplementationRegistry: " + exception.getMessage(), exception);
        }
        this._domImpl = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS"));
    }

    public void serialize(Node node, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._domImpl == null) {
            throw new IllegalStateException("Could not find DOM LS");
        }
        LSSerializer lSSerializer = this._domImpl.createLSSerializer();
        jsonGenerator.writeString(lSSerializer.writeToString(node));
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("string", true);
    }
}

