/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.HierarchicType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.type.TypeParser;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.LRUMap;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TypeFactory {
    private static final JavaType[] NO_TYPES = new JavaType[0];
    protected static final TypeFactory instance = new TypeFactory();
    protected static final SimpleType CORE_TYPE_STRING = new SimpleType(String.class);
    protected static final SimpleType CORE_TYPE_BOOL = new SimpleType(Boolean.TYPE);
    protected static final SimpleType CORE_TYPE_INT = new SimpleType(Integer.TYPE);
    protected static final SimpleType CORE_TYPE_LONG = new SimpleType(Long.TYPE);
    protected final LRUMap _typeCache = new LRUMap(16, 100);
    protected HierarchicType _cachedHashMapType;
    protected HierarchicType _cachedArrayListType;
    protected final TypeModifier[] _modifiers;
    protected final TypeParser _parser;

    private TypeFactory() {
        this._parser = new TypeParser(this);
        this._modifiers = null;
    }

    protected TypeFactory(TypeParser typeParser, TypeModifier[] typeModifierArray) {
        this._parser = typeParser;
        this._modifiers = typeModifierArray;
    }

    public TypeFactory withModifier(TypeModifier typeModifier) {
        if (this._modifiers == null) {
            return new TypeFactory(this._parser, new TypeModifier[]{typeModifier});
        }
        return new TypeFactory(this._parser, (TypeModifier[])ArrayBuilders.insertInListNoDup(this._modifiers, typeModifier));
    }

    public static TypeFactory defaultInstance() {
        return instance;
    }

    public static JavaType unknownType() {
        return TypeFactory.defaultInstance()._unknownType();
    }

    public static Class rawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return TypeFactory.defaultInstance().constructType(type).getRawClass();
    }

    public JavaType constructSpecializedType(JavaType javaType, Class clazz) {
        if (javaType instanceof SimpleType && (clazz.isArray() || Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz))) {
            if (!javaType.getRawClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + clazz.getClass().getName() + " not subtype of " + javaType);
            }
            JavaType javaType2 = this._fromClass(clazz, new TypeBindings(this, javaType.getRawClass()));
            Object object = javaType.getValueHandler();
            if (object != null) {
                javaType2 = javaType2.withValueHandler(object);
            }
            if ((object = javaType.getTypeHandler()) != null) {
                javaType2 = javaType2.withTypeHandler(object);
            }
            return javaType2;
        }
        return javaType.narrowBy(clazz);
    }

    public JavaType constructFromCanonical(String string) {
        return this._parser.parse(string);
    }

    public JavaType[] findTypeParameters(JavaType javaType, Class clazz) {
        Class clazz2 = javaType.getRawClass();
        if (clazz2 == clazz) {
            int n2 = javaType.containedTypeCount();
            if (n2 == 0) {
                return null;
            }
            JavaType[] javaTypeArray = new JavaType[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                javaTypeArray[i2] = javaType.containedType(i2);
            }
            return javaTypeArray;
        }
        return this.findTypeParameters(clazz2, clazz, new TypeBindings(this, javaType));
    }

    public JavaType[] findTypeParameters(Class clazz, Class clazz2) {
        return this.findTypeParameters(clazz, clazz2, new TypeBindings(this, clazz));
    }

    public JavaType[] findTypeParameters(Class clazz, Class clazz2, TypeBindings typeBindings) {
        HierarchicType hierarchicType = this._findSuperTypeChain(clazz, clazz2);
        if (hierarchicType == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not a subtype of " + clazz2.getName());
        }
        HierarchicType hierarchicType2 = hierarchicType;
        while (hierarchicType2.getSuperType() != null) {
            hierarchicType2 = hierarchicType2.getSuperType();
            Class clazz3 = hierarchicType2.getRawClass();
            TypeBindings typeBindings2 = new TypeBindings(this, clazz3);
            if (hierarchicType2.isGeneric()) {
                ParameterizedType parameterizedType = hierarchicType2.asGeneric();
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeVariableArray = clazz3.getTypeParameters();
                int n2 = typeArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = typeVariableArray[i2].getName();
                    JavaType javaType = instance._constructType(typeArray[i2], typeBindings);
                    typeBindings2.addBinding(string, javaType);
                }
            }
            typeBindings = typeBindings2;
        }
        if (!hierarchicType2.isGeneric()) {
            return null;
        }
        return typeBindings.typesAsArray();
    }

    public JavaType constructType(Type type) {
        return this._constructType(type, null);
    }

    public JavaType constructType(Type type, TypeBindings typeBindings) {
        return this._constructType(type, typeBindings);
    }

    public JavaType constructType(TypeReference typeReference) {
        return this._constructType(typeReference.getType(), null);
    }

    public JavaType constructType(Type type, Class clazz) {
        TypeBindings typeBindings = clazz == null ? null : new TypeBindings(this, clazz);
        return this._constructType(type, typeBindings);
    }

    public JavaType constructType(Type type, JavaType javaType) {
        TypeBindings typeBindings = javaType == null ? null : new TypeBindings(this, javaType);
        return this._constructType(type, typeBindings);
    }

    public JavaType _constructType(Type type, TypeBindings typeBindings) {
        JavaType javaType;
        if (type instanceof Class) {
            TypeModifier[] typeModifierArray = (TypeModifier[])type;
            javaType = this._fromClass((Class)typeModifierArray, typeBindings);
        } else if (type instanceof ParameterizedType) {
            javaType = this._fromParamType((ParameterizedType)type, typeBindings);
        } else if (type instanceof GenericArrayType) {
            javaType = this._fromArrayType((GenericArrayType)type, typeBindings);
        } else if (type instanceof TypeVariable) {
            javaType = this._fromVariable((TypeVariable)type, typeBindings);
        } else if (type instanceof WildcardType) {
            javaType = this._fromWildcard((WildcardType)type, typeBindings);
        } else {
            throw new IllegalArgumentException("Unrecognized Type: " + (type == null ? "[null]" : type.toString()));
        }
        if (this._modifiers != null && !javaType.isContainerType()) {
            for (TypeModifier typeModifier : this._modifiers) {
                javaType = typeModifier.modifyType(javaType, type, typeBindings, this);
            }
        }
        return javaType;
    }

    public ArrayType constructArrayType(Class clazz) {
        return ArrayType.construct(this._constructType(clazz, null), null, null);
    }

    public ArrayType constructArrayType(JavaType javaType) {
        return ArrayType.construct(javaType, null, null);
    }

    public CollectionType constructCollectionType(Class clazz, Class clazz2) {
        return CollectionType.construct(clazz, this.constructType(clazz2));
    }

    public CollectionType constructCollectionType(Class clazz, JavaType javaType) {
        return CollectionType.construct(clazz, javaType);
    }

    public CollectionLikeType constructCollectionLikeType(Class clazz, Class clazz2) {
        return CollectionLikeType.construct(clazz, this.constructType(clazz2));
    }

    public CollectionLikeType constructCollectionLikeType(Class clazz, JavaType javaType) {
        return CollectionLikeType.construct(clazz, javaType);
    }

    public MapType constructMapType(Class clazz, JavaType javaType, JavaType javaType2) {
        return MapType.construct(clazz, javaType, javaType2);
    }

    public MapType constructMapType(Class clazz, Class clazz2, Class clazz3) {
        return MapType.construct(clazz, this.constructType(clazz2), this.constructType(clazz3));
    }

    public MapLikeType constructMapLikeType(Class clazz, JavaType javaType, JavaType javaType2) {
        return MapLikeType.construct(clazz, javaType, javaType2);
    }

    public MapLikeType constructMapLikeType(Class clazz, Class clazz2, Class clazz3) {
        return MapType.construct(clazz, this.constructType(clazz2), this.constructType(clazz3));
    }

    public JavaType constructSimpleType(Class clazz, JavaType[] javaTypeArray) {
        TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
        if (typeVariableArray.length != javaTypeArray.length) {
            throw new IllegalArgumentException("Parameter type mismatch for " + clazz.getName() + ": expected " + typeVariableArray.length + " parameters, was given " + javaTypeArray.length);
        }
        String[] stringArray = new String[typeVariableArray.length];
        int n2 = typeVariableArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = typeVariableArray[i2].getName();
        }
        SimpleType simpleType = new SimpleType(clazz, stringArray, javaTypeArray, null, null);
        return simpleType;
    }

    public JavaType uncheckedSimpleType(Class clazz) {
        return new SimpleType(clazz);
    }

    public JavaType constructParametricType(Class clazz, Class ... classArray) {
        int n2 = classArray.length;
        JavaType[] javaTypeArray = new JavaType[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            javaTypeArray[i2] = this._fromClass(classArray[i2], null);
        }
        return this.constructParametricType(clazz, javaTypeArray);
    }

    public JavaType constructParametricType(Class clazz, JavaType ... javaTypeArray) {
        JavaType javaType;
        if (clazz.isArray()) {
            if (javaTypeArray.length != 1) {
                throw new IllegalArgumentException("Need exactly 1 parameter type for arrays (" + clazz.getName() + ")");
            }
            javaType = this.constructArrayType(javaTypeArray[0]);
        } else if (Map.class.isAssignableFrom(clazz)) {
            if (javaTypeArray.length != 2) {
                throw new IllegalArgumentException("Need exactly 2 parameter types for Map types (" + clazz.getName() + ")");
            }
            javaType = this.constructMapType(clazz, javaTypeArray[0], javaTypeArray[1]);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            if (javaTypeArray.length != 1) {
                throw new IllegalArgumentException("Need exactly 1 parameter type for Collection types (" + clazz.getName() + ")");
            }
            javaType = this.constructCollectionType(clazz, javaTypeArray[0]);
        } else {
            javaType = this.constructSimpleType(clazz, javaTypeArray);
        }
        return javaType;
    }

    public CollectionType constructRawCollectionType(Class clazz) {
        return CollectionType.construct(clazz, TypeFactory.unknownType());
    }

    public CollectionLikeType constructRawCollectionLikeType(Class clazz) {
        return CollectionLikeType.construct(clazz, TypeFactory.unknownType());
    }

    public MapType constructRawMapType(Class clazz) {
        return MapType.construct(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    public MapLikeType constructRawMapLikeType(Class clazz) {
        return MapLikeType.construct(clazz, TypeFactory.unknownType(), TypeFactory.unknownType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JavaType _fromClass(Class clazz, TypeBindings typeBindings) {
        JavaType javaType;
        if (clazz == String.class) {
            return CORE_TYPE_STRING;
        }
        if (clazz == Boolean.TYPE) {
            return CORE_TYPE_BOOL;
        }
        if (clazz == Integer.TYPE) {
            return CORE_TYPE_INT;
        }
        if (clazz == Long.TYPE) {
            return CORE_TYPE_LONG;
        }
        ClassKey classKey = new ClassKey(clazz);
        LRUMap lRUMap = this._typeCache;
        synchronized (lRUMap) {
            javaType = (JavaType)this._typeCache.get(classKey);
        }
        if (javaType != null) {
            return javaType;
        }
        javaType = clazz.isArray() ? ArrayType.construct(this._constructType(clazz.getComponentType(), null), null, null) : (clazz.isEnum() ? new SimpleType(clazz) : (Map.class.isAssignableFrom(clazz) ? this._mapType(clazz) : (Collection.class.isAssignableFrom(clazz) ? this._collectionType(clazz) : new SimpleType(clazz))));
        lRUMap = this._typeCache;
        synchronized (lRUMap) {
            this._typeCache.put(classKey, javaType);
        }
        return javaType;
    }

    protected JavaType _fromParameterizedClass(Class clazz, List list) {
        if (clazz.isArray()) {
            return ArrayType.construct(this._constructType(clazz.getComponentType(), null), null, null);
        }
        if (clazz.isEnum()) {
            return new SimpleType(clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (list.size() > 0) {
                JavaType javaType = (JavaType)list.get(0);
                JavaType javaType2 = list.size() >= 2 ? (JavaType)list.get(1) : this._unknownType();
                return MapType.construct(clazz, javaType, javaType2);
            }
            return this._mapType(clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (list.size() >= 1) {
                return CollectionType.construct(clazz, (JavaType)list.get(0));
            }
            return this._collectionType(clazz);
        }
        if (list.size() == 0) {
            return new SimpleType(clazz);
        }
        JavaType[] javaTypeArray = list.toArray(new JavaType[list.size()]);
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    protected JavaType _fromParamType(ParameterizedType parameterizedType, TypeBindings typeBindings) {
        JavaType[] javaTypeArray;
        int n2;
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        int n3 = n2 = typeArray == null ? 0 : typeArray.length;
        if (n2 == 0) {
            javaTypeArray = NO_TYPES;
        } else {
            javaTypeArray = new JavaType[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                javaTypeArray[i2] = this._constructType(typeArray[i2], typeBindings);
            }
        }
        if (Map.class.isAssignableFrom(clazz)) {
            JavaType javaType = this.constructSimpleType(clazz, javaTypeArray);
            JavaType[] javaTypeArray2 = this.findTypeParameters(javaType, Map.class);
            if (javaTypeArray2.length != 2) {
                throw new IllegalArgumentException("Could not find 2 type parameters for Map class " + clazz.getName() + " (found " + javaTypeArray2.length + ")");
            }
            return MapType.construct(clazz, javaTypeArray2[0], javaTypeArray2[1]);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            JavaType javaType = this.constructSimpleType(clazz, javaTypeArray);
            JavaType[] javaTypeArray3 = this.findTypeParameters(javaType, Collection.class);
            if (javaTypeArray3.length != 1) {
                throw new IllegalArgumentException("Could not find 1 type parameter for Collection class " + clazz.getName() + " (found " + javaTypeArray3.length + ")");
            }
            return CollectionType.construct(clazz, javaTypeArray3[0]);
        }
        if (n2 == 0) {
            return new SimpleType(clazz);
        }
        return this.constructSimpleType(clazz, javaTypeArray);
    }

    protected JavaType _fromArrayType(GenericArrayType genericArrayType, TypeBindings typeBindings) {
        JavaType javaType = this._constructType(genericArrayType.getGenericComponentType(), typeBindings);
        return ArrayType.construct(javaType, null, null);
    }

    protected JavaType _fromVariable(TypeVariable typeVariable, TypeBindings typeBindings) {
        if (typeBindings == null) {
            return this._unknownType();
        }
        String string = typeVariable.getName();
        JavaType javaType = typeBindings.findType(string);
        if (javaType != null) {
            return javaType;
        }
        Type[] typeArray = typeVariable.getBounds();
        typeBindings._addPlaceholder(string);
        return this._constructType(typeArray[0], typeBindings);
    }

    protected JavaType _fromWildcard(WildcardType wildcardType, TypeBindings typeBindings) {
        return this._constructType(wildcardType.getUpperBounds()[0], typeBindings);
    }

    private JavaType _mapType(Class clazz) {
        JavaType[] javaTypeArray = this.findTypeParameters(clazz, Map.class);
        if (javaTypeArray == null) {
            return MapType.construct(clazz, this._unknownType(), this._unknownType());
        }
        if (javaTypeArray.length != 2) {
            throw new IllegalArgumentException("Strange Map type " + clazz.getName() + ": can not determine type parameters");
        }
        return MapType.construct(clazz, javaTypeArray[0], javaTypeArray[1]);
    }

    private JavaType _collectionType(Class clazz) {
        JavaType[] javaTypeArray = this.findTypeParameters(clazz, Collection.class);
        if (javaTypeArray == null) {
            return CollectionType.construct(clazz, this._unknownType());
        }
        if (javaTypeArray.length != 1) {
            throw new IllegalArgumentException("Strange Collection type " + clazz.getName() + ": can not determine type parameters");
        }
        return CollectionType.construct(clazz, javaTypeArray[0]);
    }

    protected JavaType _resolveVariableViaSubTypes(HierarchicType hierarchicType, String string, TypeBindings typeBindings) {
        if (hierarchicType != null && hierarchicType.isGeneric()) {
            TypeVariable<Class<T>>[] typeVariableArray = hierarchicType.getRawClass().getTypeParameters();
            int n2 = typeVariableArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TypeVariable typeVariable = typeVariableArray[i2];
                if (!string.equals(typeVariable.getName())) continue;
                Type type = hierarchicType.asGeneric().getActualTypeArguments()[i2];
                if (type instanceof TypeVariable) {
                    return this._resolveVariableViaSubTypes(hierarchicType.getSubType(), ((TypeVariable)type).getName(), typeBindings);
                }
                return this._constructType(type, typeBindings);
            }
        }
        return this._unknownType();
    }

    protected JavaType _unknownType() {
        return new SimpleType(Object.class);
    }

    protected HierarchicType _findSuperTypeChain(Class clazz, Class clazz2) {
        if (clazz2.isInterface()) {
            return this._findSuperInterfaceChain(clazz, clazz2);
        }
        return this._findSuperClassChain(clazz, clazz2);
    }

    protected HierarchicType _findSuperClassChain(Type type, Class clazz) {
        HierarchicType hierarchicType;
        HierarchicType hierarchicType2 = new HierarchicType(type);
        Class clazz2 = hierarchicType2.getRawClass();
        if (clazz2 == clazz) {
            return hierarchicType2;
        }
        Type type2 = clazz2.getGenericSuperclass();
        if (type2 != null && (hierarchicType = this._findSuperClassChain(type2, clazz)) != null) {
            hierarchicType.setSubType(hierarchicType2);
            hierarchicType2.setSuperType(hierarchicType);
            return hierarchicType2;
        }
        return null;
    }

    protected HierarchicType _findSuperInterfaceChain(Type type, Class clazz) {
        HierarchicType hierarchicType = new HierarchicType(type);
        Class clazz2 = hierarchicType.getRawClass();
        if (clazz2 == clazz) {
            return new HierarchicType(type);
        }
        if (clazz2 == HashMap.class && clazz == Map.class) {
            return this._hashMapSuperInterfaceChain(hierarchicType);
        }
        if (clazz2 == ArrayList.class && clazz == List.class) {
            return this._arrayListSuperInterfaceChain(hierarchicType);
        }
        return this._doFindSuperInterfaceChain(hierarchicType, clazz);
    }

    protected HierarchicType _doFindSuperInterfaceChain(HierarchicType hierarchicType, Class clazz) {
        HierarchicType hierarchicType2;
        Object object;
        Class clazz2 = hierarchicType.getRawClass();
        Type[] typeArray = clazz2.getGenericInterfaces();
        if (typeArray != null) {
            object = typeArray;
            int n2 = ((Type[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type = object[i2];
                HierarchicType hierarchicType3 = this._findSuperInterfaceChain(type, clazz);
                if (hierarchicType3 == null) continue;
                hierarchicType3.setSubType(hierarchicType);
                hierarchicType.setSuperType(hierarchicType3);
                return hierarchicType;
            }
        }
        if ((object = clazz2.getGenericSuperclass()) != null && (hierarchicType2 = this._findSuperInterfaceChain((Type)object, clazz)) != null) {
            hierarchicType2.setSubType(hierarchicType);
            hierarchicType.setSuperType(hierarchicType2);
            return hierarchicType;
        }
        return null;
    }

    protected synchronized HierarchicType _hashMapSuperInterfaceChain(HierarchicType hierarchicType) {
        HierarchicType hierarchicType2;
        if (this._cachedHashMapType == null) {
            hierarchicType2 = hierarchicType.deepCloneWithoutSubtype();
            this._doFindSuperInterfaceChain(hierarchicType2, Map.class);
            this._cachedHashMapType = hierarchicType2.getSuperType();
        }
        hierarchicType2 = this._cachedHashMapType.deepCloneWithoutSubtype();
        hierarchicType.setSuperType(hierarchicType2);
        hierarchicType2.setSubType(hierarchicType);
        return hierarchicType;
    }

    protected synchronized HierarchicType _arrayListSuperInterfaceChain(HierarchicType hierarchicType) {
        HierarchicType hierarchicType2;
        if (this._cachedArrayListType == null) {
            hierarchicType2 = hierarchicType.deepCloneWithoutSubtype();
            this._doFindSuperInterfaceChain(hierarchicType2, List.class);
            this._cachedArrayListType = hierarchicType2.getSuperType();
        }
        hierarchicType2 = this._cachedArrayListType.deepCloneWithoutSubtype();
        hierarchicType.setSuperType(hierarchicType2);
        hierarchicType2.setSubType(hierarchicType);
        return hierarchicType;
    }
}

