/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class GenericEntity {
    final Class rawType;
    final Type type;
    final Object entity;

    protected GenericEntity(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The entity must not be null");
        }
        this.entity = object;
        this.type = GenericEntity.getSuperclassTypeParameter(this.getClass());
        this.rawType = object.getClass();
    }

    public GenericEntity(Object object, Type type) {
        if (object == null || type == null) {
            throw new IllegalArgumentException("Arguments must not be null");
        }
        this.entity = object;
        this.rawType = object.getClass();
        this.checkTypeCompatibility(this.rawType, type);
        this.type = type;
    }

    private void checkTypeCompatibility(Class clazz, Type type) {
        if (type instanceof Class) {
            Class clazz2 = (Class)type;
            if (clazz2.isAssignableFrom(clazz)) {
                return;
            }
        } else {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type type2 = parameterizedType.getRawType();
                this.checkTypeCompatibility(clazz, type2);
                return;
            }
            if (clazz.isArray() && type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                Type type3 = genericArrayType.getGenericComponentType();
                this.checkTypeCompatibility(clazz.getComponentType(), type3);
                return;
            }
        }
        throw new IllegalArgumentException("The type is incompatible with the class of the entity");
    }

    private static Type getSuperclassTypeParameter(Class clazz) {
        Type type = clazz.getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return parameterizedType.getActualTypeArguments()[0];
    }

    public final Class getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    public final Object getEntity() {
        return this.entity;
    }
}

