/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class WriterBasedJsonGenerator
extends GeneratorBase {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected final IOContext _ioContext;
    protected final Writer _writer;
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _currentEscape;
    protected char[] _outputBuffer;
    protected int _outputHead = 0;
    protected int _outputTail = 0;
    protected int _outputEnd;
    protected char[] _entityBuffer;

    public WriterBasedJsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, Writer writer) {
        super(n2, objectCodec);
        this._ioContext = iOContext;
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
        if (this.isEnabled(JsonGenerator$Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    public JsonGenerator setHighestNonEscapedChar(int n2) {
        this._maximumNonEscapedChar = n2 < 0 ? 0 : n2;
        return this;
    }

    public int getHighestEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        this._outputEscapes = characterEscapes == null ? sOutputEscapes : characterEscapes.getEscapeCodesForAscii();
        return this;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public Object getOutputTarget() {
        return this._writer;
    }

    public final void writeFieldName(String string) {
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string, n2 == 1);
    }

    public final void writeStringField(String string, String string2) {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeFieldName(SerializableString serializableString) {
        int n2 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString, n2 == 1);
    }

    public final void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
    }

    public final void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.getParent();
    }

    public final void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
    }

    public final void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.getParent();
    }

    protected void _writeFieldName(String string, boolean bl) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (!this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            this._writeString(string);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void _writeFieldName(SerializableString serializableString, boolean bl) {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        char[] cArray = serializableString.asQuotedChars();
        if (!this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            this.writeRaw(cArray, 0, cArray.length);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        int n2 = cArray.length;
        if (this._outputTail + n2 + 1 >= this._outputEnd) {
            this.writeRaw(cArray, 0, n2);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            this._outputBuffer[this._outputTail++] = 34;
        }
    }

    protected final void _writePPFieldName(String string, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this._writeString(string);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            this._writeString(string);
        }
    }

    protected final void _writePPFieldName(SerializableString serializableString, boolean bl) {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        char[] cArray = serializableString.asQuotedChars();
        if (this.isEnabled(JsonGenerator$Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this.writeRaw(cArray, 0, cArray.length);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            this.writeRaw(cArray, 0, cArray.length);
        }
    }

    public void writeString(String string) {
        this._verifyValueWrite("write text value");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeString(char[] cArray, int n2, int n3) {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(cArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public final void writeString(SerializableString serializableString) {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        char[] cArray = serializableString.asQuotedChars();
        int n2 = cArray.length;
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
        } else {
            this._flushBuffer();
            this._writer.write(cArray, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String string) {
        int n2 = string.length();
        int n3 = this._outputEnd - this._outputTail;
        if (n3 == 0) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(0, n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
        } else {
            this.writeRawLong(string);
        }
    }

    public void writeRaw(String string, int n2, int n3) {
        int n4 = this._outputEnd - this._outputTail;
        if (n4 < n3) {
            this._flushBuffer();
            n4 = this._outputEnd - this._outputTail;
        }
        if (n4 >= n3) {
            string.getChars(n2, n2 + n3, this._outputBuffer, this._outputTail);
            this._outputTail += n3;
        } else {
            this.writeRawLong(string.substring(n2, n2 + n3));
        }
    }

    public void writeRaw(char[] cArray, int n2, int n3) {
        if (n3 < 32) {
            int n4 = this._outputEnd - this._outputTail;
            if (n3 > n4) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n2, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n2, n3);
    }

    public void writeRaw(char c2) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c2;
    }

    private void writeRawLong(String string) {
        int n2;
        int n3;
        int n4 = this._outputEnd - this._outputTail;
        string.getChars(0, n4, this._outputBuffer, this._outputTail);
        this._outputTail += n4;
        this._flushBuffer();
        int n5 = n4;
        for (n2 = string.length() - n4; n2 > this._outputEnd; n2 -= n3) {
            n3 = this._outputEnd;
            string.getChars(n5, n5 + n3, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n3;
            this._flushBuffer();
            n5 += n3;
        }
        string.getChars(n5, n5 + n2, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n2;
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        this._verifyValueWrite("write binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBinary(base64Variant, byArray, n2, n2 + n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeNumber(int n2) {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n2);
            return;
        }
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedInt(int n2) {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeNumber(long l2) {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l2);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedLong(long l2) {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeNumber(BigInteger bigInteger) {
        this._verifyValueWrite("write number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger);
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    public void writeNumber(double d2) {
        if (this._cfgNumbersAsStrings || (Double.isNaN(d2) || Double.isInfinite(d2)) && this.isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(d2));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(d2));
    }

    public void writeNumber(float f2) {
        if (this._cfgNumbersAsStrings || (Float.isNaN(f2) || Float.isInfinite(f2)) && this.isEnabled(JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(f2));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(f2));
    }

    public void writeNumber(BigDecimal bigDecimal) {
        this._verifyValueWrite("write number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigDecimal);
        } else {
            this.writeRaw(bigDecimal.toString());
        }
    }

    public void writeNumber(String string) {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
        } else {
            this.writeRaw(string);
        }
    }

    private final void _writeQuotedRaw(Object object) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this.writeRaw(object.toString());
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeBoolean(boolean bl) {
        this._verifyValueWrite("write boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n2 = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl) {
            cArray[n2] = 116;
            cArray[++n2] = 114;
            cArray[++n2] = 117;
            cArray[++n2] = 101;
        } else {
            cArray[n2] = 102;
            cArray[++n2] = 97;
            cArray[++n2] = 108;
            cArray[++n2] = 115;
            cArray[++n2] = 101;
        }
        this._outputTail = n2 + 1;
    }

    public void writeNull() {
        this._verifyValueWrite("write null value");
        this._writeNull();
    }

    protected final void _verifyValueWrite(String string) {
        int n2 = this._writeContext.writeValue();
        if (n2 == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        if (this._cfgPrettyPrinter == null) {
            int n3;
            switch (n2) {
                case 1: {
                    n3 = 44;
                    break;
                }
                case 2: {
                    n3 = 58;
                    break;
                }
                case 3: {
                    n3 = 32;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail] = n3;
            ++this._outputTail;
            return;
        }
        this._verifyPrettyValueWrite(string, n2);
    }

    protected final void _verifyPrettyValueWrite(String string, int n2) {
        switch (n2) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                break;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                break;
            }
            default: {
                this._cantHappen();
            }
        }
    }

    public final void flush() {
        this._flushBuffer();
        if (this._writer != null && this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    public void close() {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        if (this._writer != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
                this._writer.close();
            } else if (this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
                this._writer.flush();
            }
        }
        this._releaseBuffers();
    }

    protected void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (cArray != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    private void _writeString(String string) {
        int n2 = string.length();
        if (n2 > this._outputEnd) {
            this._writeLongString(string);
            return;
        }
        if (this._outputTail + n2 > this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n2, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n2);
        } else if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(n2, this._maximumNonEscapedChar);
        } else {
            this._writeString2(n2);
        }
    }

    private void _writeString2(int n2) {
        int n3 = this._outputTail + n2;
        int[] nArray = this._outputEscapes;
        int n4 = nArray.length;
        block0: while (this._outputTail < n3) {
            int n5;
            while ((n5 = this._outputBuffer[this._outputTail]) >= n4 || nArray[n5] == 0) {
                if (++this._outputTail < n3) continue;
                break block0;
            }
            n5 = this._outputTail - this._outputHead;
            if (n5 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n5);
            }
            char c2 = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c2, nArray[c2]);
        }
    }

    private void _writeLongString(String string) {
        int n2;
        this._flushBuffer();
        int n3 = string.length();
        int n4 = 0;
        do {
            int n5;
            n2 = n4 + (n5 = this._outputEnd) > n3 ? n3 - n4 : n5;
            string.getChars(n4, n4 + n2, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n2);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(n2, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(n2);
        } while ((n4 += n2) < n3);
    }

    private final void _writeSegment(int n2) {
        int n3;
        int[] nArray = this._outputEscapes;
        int n4 = nArray.length;
        int n5 = n3 = 0;
        while (n3 < n2) {
            char c2;
            while (((c2 = this._outputBuffer[n3]) >= n4 || nArray[c2] == 0) && ++n3 < n2) {
            }
            int n6 = n3 - n5;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, n5, n6);
                if (n3 >= n2) break;
            }
            n5 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n3, n2, c2, nArray[c2]);
        }
    }

    private final void _writeString(char[] cArray, int n2, int n3) {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n2, n3);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(cArray, n2, n3, this._maximumNonEscapedChar);
            return;
        }
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n4 = nArray.length;
        while (n2 < n3) {
            int n5;
            int n6 = n2;
            while (((n5 = cArray[n2]) >= n4 || nArray[n5] == 0) && ++n2 < n3) {
            }
            n5 = n2 - n6;
            if (n5 < 32) {
                if (this._outputTail + n5 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n5 > 0) {
                    System.arraycopy(cArray, n6, this._outputBuffer, this._outputTail, n5);
                    this._outputTail += n5;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n6, n5);
            }
            if (n2 >= n3) break;
            char c2 = cArray[n2++];
            this._appendCharacterEscape(c2, nArray[c2]);
        }
    }

    private void _writeStringASCII(int n2, int n3) {
        int n4 = this._outputTail + n2;
        int[] nArray = this._outputEscapes;
        int n5 = Math.min(nArray.length, n3 + 1);
        int n6 = 0;
        while (this._outputTail < n4) {
            char c2;
            block5: {
                do {
                    if ((c2 = this._outputBuffer[this._outputTail]) < n5) {
                        n6 = nArray[c2];
                        if (n6 == 0) continue;
                    } else {
                        if (c2 <= n3) continue;
                        n6 = -1;
                    }
                    break block5;
                } while (++this._outputTail < n4);
                break;
            }
            int n7 = this._outputTail - this._outputHead;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n7);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape(c2, n6);
        }
    }

    private final void _writeSegmentASCII(int n2, int n3) {
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        while (n5 < n2) {
            char c2;
            do {
                if ((c2 = this._outputBuffer[n5]) < n4) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                    break;
                }
                if (c2 <= n3) continue;
                n6 = -1;
                break;
            } while (++n5 < n2);
            int n8 = n5 - n7;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, n7, n8);
                if (n5 >= n2) break;
            }
            n7 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n5, n2, c2, n6);
        }
    }

    private final void _writeStringASCII(char[] cArray, int n2, int n3, int n4) {
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n5 = Math.min(nArray.length, n4 + 1);
        int n6 = 0;
        while (n2 < n3) {
            char c2;
            int n7 = n2;
            do {
                if ((c2 = cArray[n2]) < n5) {
                    n6 = nArray[c2];
                    if (n6 == 0) continue;
                    break;
                }
                if (c2 <= n4) continue;
                n6 = -1;
                break;
            } while (++n2 < n3);
            int n8 = n2 - n7;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    System.arraycopy(cArray, n7, this._outputBuffer, this._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n7, n8);
            }
            if (n2 >= n3) break;
            ++n2;
            this._appendCharacterEscape(c2, n6);
        }
    }

    private void _writeStringCustom(int n2) {
        int n3 = this._outputTail + n2;
        int[] nArray = this._outputEscapes;
        int n4 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n5 = Math.min(nArray.length, n4 + 1);
        int n6 = 0;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (this._outputTail < n3) {
            int n7;
            block7: {
                do {
                    if ((n7 = this._outputBuffer[this._outputTail]) < n5) {
                        n6 = nArray[n7];
                        if (n6 == 0) continue;
                    } else if (n7 > n4) {
                        n6 = -1;
                    } else {
                        this._currentEscape = characterEscapes.getEscapeSequence(n7);
                        if (this._currentEscape == null) continue;
                        n6 = -2;
                    }
                    break block7;
                } while (++this._outputTail < n3);
                break;
            }
            int n8 = this._outputTail - this._outputHead;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n8);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape((char)n7, n6);
        }
    }

    private final void _writeSegmentCustom(int n2) {
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        while (n5 < n2) {
            int n8;
            do {
                if ((n8 = this._outputBuffer[n5]) < n4) {
                    n6 = nArray[n8];
                    if (n6 == 0) continue;
                    break;
                }
                if (n8 > n3) {
                    n6 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n8);
                if (this._currentEscape == null) continue;
                n6 = -2;
                break;
            } while (++n5 < n2);
            int n9 = n5 - n7;
            if (n9 > 0) {
                this._writer.write(this._outputBuffer, n7, n9);
                if (n5 >= n2) break;
            }
            n7 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n5, n2, (char)n8, n6);
        }
    }

    private final void _writeStringCustom(char[] cArray, int n2, int n3) {
        n3 += n2;
        int[] nArray = this._outputEscapes;
        int n4 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n5 = Math.min(nArray.length, n4 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n6 = 0;
        while (n2 < n3) {
            int n7;
            int n8 = n2;
            do {
                if ((n7 = cArray[n2]) < n5) {
                    n6 = nArray[n7];
                    if (n6 == 0) continue;
                    break;
                }
                if (n7 > n4) {
                    n6 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n7);
                if (this._currentEscape == null) continue;
                n6 = -2;
                break;
            } while (++n2 < n3);
            int n9 = n2 - n8;
            if (n9 < 32) {
                if (this._outputTail + n9 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n9 > 0) {
                    System.arraycopy(cArray, n8, this._outputBuffer, this._outputTail, n9);
                    this._outputTail += n9;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n8, n9);
            }
            if (n2 >= n3) break;
            ++n2;
            this._appendCharacterEscape((char)n7, n6);
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n3 - 3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n2 <= n5) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n4 = byArray[n2++] << 8;
            n4 |= byArray[n2++] & 0xFF;
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n4, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        n4 = n3 - n2;
        if (n4 > 0) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            int n8 = byArray[n2++] << 16;
            if (n4 == 2) {
                n8 |= (byArray[n2++] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n8, n4, this._outputBuffer, this._outputTail);
        }
    }

    private final void _writeNull() {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n2 = this._outputTail;
        char[] cArray = this._outputBuffer;
        cArray[n2] = 110;
        cArray[++n2] = 117;
        cArray[++n2] = 108;
        cArray[++n2] = 108;
        this._outputTail = n2 + 1;
    }

    private final void _prependOrWriteCharacterEscape(char c2, int n2) {
        String string;
        if (n2 >= 0) {
            if (this._outputTail >= 2) {
                int n3;
                this._outputHead = n3 = this._outputTail - 2;
                this._outputBuffer[n3++] = 92;
                this._outputBuffer[n3] = (char)n2;
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            cArray[1] = (char)n2;
            this._writer.write(cArray, 0, 2);
            return;
        }
        if (n2 != -2) {
            if (this._outputTail >= 6) {
                int n4;
                char[] cArray = this._outputBuffer;
                this._outputHead = n4 = this._outputTail - 6;
                cArray[n4] = 92;
                cArray[++n4] = 117;
                if (c2 > '\u00ff') {
                    int n5 = c2 >> 8 & 0xFF;
                    cArray[++n4] = HEX_CHARS[n5 >> 4];
                    cArray[++n4] = HEX_CHARS[n5 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    cArray[++n4] = 48;
                    cArray[++n4] = 48;
                }
                cArray[++n4] = HEX_CHARS[c2 >> 4];
                cArray[++n4] = HEX_CHARS[c2 & 0xF];
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c2 > '\u00ff') {
                int n6 = c2 >> 8 & 0xFF;
                int n7 = c2 & 0xFF;
                cArray[10] = HEX_CHARS[n6 >> 4];
                cArray[11] = HEX_CHARS[n6 & 0xF];
                cArray[12] = HEX_CHARS[n7 >> 4];
                cArray[13] = HEX_CHARS[n7 & 0xF];
                this._writer.write(cArray, 8, 6);
            } else {
                cArray[6] = HEX_CHARS[c2 >> 4];
                cArray[7] = HEX_CHARS[c2 & 0xF];
                this._writer.write(cArray, 2, 6);
            }
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n8 = string.length();
        if (this._outputTail >= n8) {
            int n9;
            this._outputHead = n9 = this._outputTail - n8;
            string.getChars(0, n8, this._outputBuffer, n9);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(string);
    }

    private final int _prependOrWriteCharacterEscape(char[] cArray, int n2, int n3, char c2, int n4) {
        String string;
        if (n4 >= 0) {
            if (n2 > 1 && n2 < n3) {
                cArray[n2 -= 2] = 92;
                cArray[n2 + 1] = (char)n4;
            } else {
                char[] cArray2 = this._entityBuffer;
                if (cArray2 == null) {
                    cArray2 = this._allocateEntityBuffer();
                }
                cArray2[1] = (char)n4;
                this._writer.write(cArray2, 0, 2);
            }
            return n2;
        }
        if (n4 != -2) {
            if (n2 > 5 && n2 < n3) {
                n2 -= 6;
                cArray[n2++] = 92;
                cArray[n2++] = 117;
                if (c2 > '\u00ff') {
                    int n5 = c2 >> 8 & 0xFF;
                    cArray[n2++] = HEX_CHARS[n5 >> 4];
                    cArray[n2++] = HEX_CHARS[n5 & 0xF];
                    c2 = (char)(c2 & 0xFF);
                } else {
                    cArray[n2++] = 48;
                    cArray[n2++] = 48;
                }
                cArray[n2++] = HEX_CHARS[c2 >> 4];
                cArray[n2] = HEX_CHARS[c2 & 0xF];
                n2 -= 5;
            } else {
                char[] cArray3 = this._entityBuffer;
                if (cArray3 == null) {
                    cArray3 = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (c2 > '\u00ff') {
                    int n6 = c2 >> 8 & 0xFF;
                    int n7 = c2 & 0xFF;
                    cArray3[10] = HEX_CHARS[n6 >> 4];
                    cArray3[11] = HEX_CHARS[n6 & 0xF];
                    cArray3[12] = HEX_CHARS[n7 >> 4];
                    cArray3[13] = HEX_CHARS[n7 & 0xF];
                    this._writer.write(cArray3, 8, 6);
                } else {
                    cArray3[6] = HEX_CHARS[c2 >> 4];
                    cArray3[7] = HEX_CHARS[c2 & 0xF];
                    this._writer.write(cArray3, 2, 6);
                }
            }
            return n2;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n8 = string.length();
        if (n2 >= n8 && n2 < n3) {
            string.getChars(0, n8, cArray, n2 -= n8);
        } else {
            this._writer.write(string);
        }
        return n2;
    }

    private final void _appendCharacterEscape(char c2, int n2) {
        String string;
        if (n2 >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = (char)n2;
            return;
        }
        if (n2 != -2) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            int n3 = this._outputTail;
            char[] cArray = this._outputBuffer;
            cArray[n3++] = 92;
            cArray[n3++] = 117;
            if (c2 > '\u00ff') {
                int n4 = c2 >> 8 & 0xFF;
                cArray[n3++] = HEX_CHARS[n4 >> 4];
                cArray[n3++] = HEX_CHARS[n4 & 0xF];
                c2 = (char)(c2 & 0xFF);
            } else {
                cArray[n3++] = 48;
                cArray[n3++] = 48;
            }
            cArray[n3++] = HEX_CHARS[c2 >> 4];
            cArray[n3] = HEX_CHARS[c2 & 0xF];
            this._outputTail = n3;
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c2).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n5 = string.length();
        if (this._outputTail + n5 > this._outputEnd) {
            this._flushBuffer();
            if (n5 > this._outputEnd) {
                this._writer.write(string);
                return;
            }
        }
        string.getChars(0, n5, this._outputBuffer, this._outputTail);
        this._outputTail += n5;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray = new char[14];
        cArray[0] = 92;
        cArray[2] = 92;
        cArray[3] = 117;
        cArray[4] = 48;
        cArray[5] = 48;
        cArray[8] = 92;
        cArray[9] = 117;
        this._entityBuffer = cArray;
        return cArray;
    }

    protected final void _flushBuffer() {
        int n2 = this._outputTail - this._outputHead;
        if (n2 > 0) {
            int n3 = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n3, n2);
        }
    }
}

