/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonAutoDetect$Visibility;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper$1;
import com.fasterxml.jackson.databind.ObjectMapper$DefaultTypeResolverBuilder;
import com.fasterxml.jackson.databind.ObjectMapper$DefaultTyping;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.DatabindVersion;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext$Impl;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker$Std;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider$Impl;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMapper
extends ObjectCodec
implements Versioned {
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected static final ClassIntrospector DEFAULT_INTROSPECTOR = BasicClassIntrospector.instance;
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final VisibilityChecker<?> STD_VISIBILITY_CHECKER = VisibilityChecker$Std.defaultInstance();
    protected static final BaseSettings DEFAULT_BASE = new BaseSettings(DEFAULT_INTROSPECTOR, DEFAULT_ANNOTATION_INTROSPECTOR, STD_VISIBILITY_CHECKER, null, TypeFactory.defaultInstance(), null, StdDateFormat.instance, null, Locale.getDefault(), TimeZone.getTimeZone("GMT"));
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final RootNameLookup _rootNames;
    protected final HashMap<ClassKey, Class<?>> _mixInAnnotations = new HashMap();
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory) {
        this(jsonFactory, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory, DefaultSerializerProvider defaultSerializerProvider, DefaultDeserializationContext defaultDeserializationContext) {
        if (jsonFactory == null) {
            this._jsonFactory = new MappingJsonFactory(this);
        } else {
            this._jsonFactory = jsonFactory;
            if (jsonFactory.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new StdSubtypeResolver();
        this._rootNames = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        this._serializationConfig = new SerializationConfig(DEFAULT_BASE, this._subtypeResolver, this._mixInAnnotations);
        this._deserializationConfig = new DeserializationConfig(DEFAULT_BASE, this._subtypeResolver, this._mixInAnnotations);
        this._serializerProvider = defaultSerializerProvider == null ? new DefaultSerializerProvider$Impl() : defaultSerializerProvider;
        this._deserializationContext = defaultDeserializationContext == null ? new DefaultDeserializationContext$Impl(BeanDeserializerFactory.instance) : defaultDeserializationContext;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    @Override
    public Version version() {
        return DatabindVersion.instance.version();
    }

    public ObjectMapper registerModule(Module module) {
        String string = module.getModuleName();
        if (string == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        Version version = module.version();
        if (version == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        ObjectMapper objectMapper = this;
        module.setupModule(new ObjectMapper$1(this, objectMapper));
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public ObjectMapper setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
        return this;
    }

    public ObjectMapper setSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        this._serializerProvider = defaultSerializerProvider;
        return this;
    }

    public SerializerProvider getSerializerProvider() {
        return this._serializerProvider;
    }

    public final void setMixInAnnotations(Map<Class<?>, Class<?>> map) {
        this._mixInAnnotations.clear();
        if (map != null && map.size() > 0) {
            for (Map.Entry<Class<?>, Class<?>> entry : map.entrySet()) {
                this._mixInAnnotations.put(new ClassKey(entry.getKey()), entry.getValue());
            }
        }
    }

    public final void addMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
        this._mixInAnnotations.put(new ClassKey(clazz), clazz2);
    }

    public final Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixInAnnotations == null ? null : this._mixInAnnotations.get(new ClassKey(clazz));
    }

    public final int mixInCount() {
        return this._mixInAnnotations == null ? 0 : this._mixInAnnotations.size();
    }

    public VisibilityChecker<?> getVisibilityChecker() {
        return this._serializationConfig.getDefaultVisibilityChecker();
    }

    public void setVisibilityChecker(VisibilityChecker<?> visibilityChecker) {
        this._deserializationConfig = this._deserializationConfig.with((VisibilityChecker)visibilityChecker);
        this._serializationConfig = this._serializationConfig.with((VisibilityChecker)visibilityChecker);
    }

    public ObjectMapper setVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect$Visibility jsonAutoDetect$Visibility) {
        this._deserializationConfig = this._deserializationConfig.withVisibility(propertyAccessor, jsonAutoDetect$Visibility);
        this._serializationConfig = this._serializationConfig.withVisibility(propertyAccessor, jsonAutoDetect$Visibility);
        return this;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setSubtypeResolver(SubtypeResolver subtypeResolver) {
        this._subtypeResolver = subtypeResolver;
        this._deserializationConfig = this._deserializationConfig.with(subtypeResolver);
        this._serializationConfig = this._serializationConfig.with(subtypeResolver);
        return this;
    }

    public ObjectMapper setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this._serializationConfig = this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = this._deserializationConfig.with(annotationIntrospector);
        return this;
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this._serializationConfig = this._serializationConfig.with(propertyNamingStrategy);
        this._deserializationConfig = this._deserializationConfig.with(propertyNamingStrategy);
        return this;
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include include) {
        this._serializationConfig = this._serializationConfig.withSerializationInclusion(include);
        return this;
    }

    public ObjectMapper enableDefaultTyping() {
        return this.enableDefaultTyping(ObjectMapper$DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public ObjectMapper enableDefaultTyping(ObjectMapper$DefaultTyping objectMapper$DefaultTyping) {
        return this.enableDefaultTyping(objectMapper$DefaultTyping, JsonTypeInfo$As.WRAPPER_ARRAY);
    }

    public ObjectMapper enableDefaultTyping(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, JsonTypeInfo$As jsonTypeInfo$As) {
        ObjectMapper$DefaultTypeResolverBuilder objectMapper$DefaultTypeResolverBuilder = new ObjectMapper$DefaultTypeResolverBuilder(objectMapper$DefaultTyping);
        objectMapper$DefaultTypeResolverBuilder = objectMapper$DefaultTypeResolverBuilder.init(JsonTypeInfo$Id.CLASS, null);
        objectMapper$DefaultTypeResolverBuilder = objectMapper$DefaultTypeResolverBuilder.inclusion(jsonTypeInfo$As);
        return this.setDefaultTyping(objectMapper$DefaultTypeResolverBuilder);
    }

    public ObjectMapper enableDefaultTypingAsProperty(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, String string) {
        ObjectMapper$DefaultTypeResolverBuilder objectMapper$DefaultTypeResolverBuilder = new ObjectMapper$DefaultTypeResolverBuilder(objectMapper$DefaultTyping);
        objectMapper$DefaultTypeResolverBuilder = objectMapper$DefaultTypeResolverBuilder.init(JsonTypeInfo$Id.CLASS, null);
        objectMapper$DefaultTypeResolverBuilder = objectMapper$DefaultTypeResolverBuilder.inclusion(JsonTypeInfo$As.PROPERTY);
        objectMapper$DefaultTypeResolverBuilder = objectMapper$DefaultTypeResolverBuilder.typeProperty(string);
        return this.setDefaultTyping(objectMapper$DefaultTypeResolverBuilder);
    }

    public ObjectMapper disableDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public ObjectMapper setDefaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        this._deserializationConfig = this._deserializationConfig.with((TypeResolverBuilder)typeResolverBuilder);
        this._serializationConfig = this._serializationConfig.with((TypeResolverBuilder)typeResolverBuilder);
        return this;
    }

    public void registerSubtypes(Class<?> ... classArray) {
        this.getSubtypeResolver().registerSubtypes(classArray);
    }

    public void registerSubtypes(NamedType ... namedTypeArray) {
        this.getSubtypeResolver().registerSubtypes(namedTypeArray);
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public ObjectMapper setTypeFactory(TypeFactory typeFactory) {
        this._typeFactory = typeFactory;
        this._deserializationConfig = this._deserializationConfig.with(typeFactory);
        this._serializationConfig = this._serializationConfig.with(typeFactory);
        return this;
    }

    public JavaType constructType(Type type) {
        return this._typeFactory.constructType(type);
    }

    public ObjectMapper setNodeFactory(JsonNodeFactory jsonNodeFactory) {
        this._deserializationConfig = this._deserializationConfig.with(jsonNodeFactory);
        return this;
    }

    public ObjectMapper addHandler(DeserializationProblemHandler deserializationProblemHandler) {
        this._deserializationConfig = this._deserializationConfig.withHandler(deserializationProblemHandler);
        return this;
    }

    public ObjectMapper clearProblemHandlers() {
        this._deserializationConfig = this._deserializationConfig.withNoProblemHandlers();
        return this;
    }

    public void setFilters(FilterProvider filterProvider) {
        this._serializationConfig = this._serializationConfig.withFilters(filterProvider);
    }

    @Override
    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public ObjectMapper setDateFormat(DateFormat dateFormat) {
        this._deserializationConfig = this._deserializationConfig.with(dateFormat);
        this._serializationConfig = this._serializationConfig.with(dateFormat);
        return this;
    }

    public Object setHandlerInstantiator(HandlerInstantiator handlerInstantiator) {
        this._deserializationConfig = this._deserializationConfig.with(handlerInstantiator);
        this._serializationConfig = this._serializationConfig.with(handlerInstantiator);
        return this;
    }

    public ObjectMapper setInjectableValues(InjectableValues injectableValues) {
        this._injectableValues = injectableValues;
        return this;
    }

    public ObjectMapper setLocale(Locale locale) {
        this._deserializationConfig = this._deserializationConfig.with(locale);
        this._serializationConfig = this._serializationConfig.with(locale);
        return this;
    }

    public ObjectMapper setTimeZone(TimeZone timeZone) {
        this._deserializationConfig = this._deserializationConfig.with(timeZone);
        this._serializationConfig = this._serializationConfig.with(timeZone);
        return this;
    }

    public ObjectMapper configure(MapperFeature mapperFeature, boolean bl) {
        this._serializationConfig = bl ? this._serializationConfig.with(mapperFeature) : this._serializationConfig.without(mapperFeature);
        this._deserializationConfig = bl ? this._deserializationConfig.with(mapperFeature) : this._deserializationConfig.without(mapperFeature);
        return this;
    }

    public ObjectMapper configure(SerializationFeature serializationFeature, boolean bl) {
        this._serializationConfig = bl ? this._serializationConfig.with(serializationFeature) : this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper configure(DeserializationFeature deserializationFeature, boolean bl) {
        this._deserializationConfig = bl ? this._deserializationConfig.with(deserializationFeature) : this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        this._jsonFactory.configure(jsonParser$Feature, bl);
        return this;
    }

    public ObjectMapper configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        this._jsonFactory.configure(jsonGenerator$Feature, bl);
        return this;
    }

    public ObjectMapper enable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(mapperFeatureArray);
        this._serializationConfig = this._serializationConfig.with(mapperFeatureArray);
        return this;
    }

    public ObjectMapper disable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(mapperFeatureArray);
        this._serializationConfig = this._serializationConfig.without(mapperFeatureArray);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature, serializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature, serializationFeatureArray);
        return this;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._serializationConfig.isEnabled(mapperFeature);
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._serializationConfig.isEnabled(serializationFeature);
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._deserializationConfig.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(JsonFactory$Feature jsonFactory$Feature) {
        return this._jsonFactory.isEnabled(jsonFactory$Feature);
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return this._jsonFactory.isEnabled(jsonParser$Feature);
    }

    public boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return this._jsonFactory.isEnabled(jsonGenerator$Feature);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(clazz));
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<?> typeReference) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(typeReference));
    }

    @Override
    public final <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, (JavaType)resolvedType);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) {
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, javaType);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) {
        DeserializationConfig deserializationConfig = this.getDeserializationConfig();
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            return null;
        }
        JsonNode jsonNode = (JsonNode)this._readValue(deserializationConfig, jsonParser, JSON_NODE_TYPE);
        if (jsonNode == null) {
            jsonNode = this.getNodeFactory().nullNode();
        }
        JsonNode jsonNode2 = jsonNode;
        return (T)jsonNode2;
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, JavaType javaType) {
        DeserializationConfig deserializationConfig = this.getDeserializationConfig();
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
        JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
        return new MappingIterator(javaType, jsonParser, defaultDeserializationContext, jsonDeserializer, false, null);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, Class<T> clazz) {
        return this.readValues(jsonParser, this._typeFactory.constructType(clazz));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, TypeReference<?> typeReference) {
        return this.readValues(jsonParser, this._typeFactory.constructType(typeReference));
    }

    public JsonNode readTree(InputStream inputStream) {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createJsonParser(inputStream), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(Reader reader) {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createJsonParser(reader), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(String string) {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createJsonParser(string), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(byte[] byArray) {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createJsonParser(byArray), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(File file) {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createJsonParser(file), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    public JsonNode readTree(URL uRL) {
        JsonNode jsonNode = (JsonNode)this._readMapAndClose(this._jsonFactory.createJsonParser(uRL), JSON_NODE_TYPE);
        return jsonNode == null ? NullNode.instance : jsonNode;
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, serializationConfig);
        } else {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public void writeTree(JsonGenerator jsonGenerator, JsonNode jsonNode) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, jsonNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    @Override
    public ObjectNode createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    @Override
    public ArrayNode createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) {
        try {
            if (clazz != Object.class && clazz.isAssignableFrom(treeNode.getClass())) {
                return (T)treeNode;
            }
            return this.readValue(this.treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T extends JsonNode> T valueToTree(Object object) {
        JsonNode jsonNode;
        if (object == null) {
            return null;
        }
        TokenBuffer tokenBuffer = new TokenBuffer(this);
        try {
            this.writeValue(tokenBuffer, object);
            JsonParser jsonParser = tokenBuffer.asParser();
            jsonNode = (JsonNode)this.readTree(jsonParser);
            jsonParser.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        return (T)jsonNode;
    }

    public boolean canSerialize(Class<?> clazz) {
        return this._serializerProvider(this.getSerializationConfig()).hasSerializerFor(clazz);
    }

    public boolean canDeserialize(JavaType javaType) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(javaType);
    }

    public <T> T readValue(File file, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(file), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(File file, TypeReference typeReference) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(file), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(File file, JavaType javaType) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(file), javaType);
    }

    public <T> T readValue(URL uRL, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(uRL), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(URL uRL, TypeReference typeReference) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(uRL), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(URL uRL, JavaType javaType) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(uRL), javaType);
    }

    public <T> T readValue(String string, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(string), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(String string, TypeReference typeReference) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(string), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(String string, JavaType javaType) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(string), javaType);
    }

    public <T> T readValue(Reader reader, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(reader), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(Reader reader, TypeReference typeReference) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(reader), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(Reader reader, JavaType javaType) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(reader), javaType);
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(inputStream), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(InputStream inputStream, TypeReference typeReference) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(inputStream), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(InputStream inputStream, JavaType javaType) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(inputStream), javaType);
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(byArray), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, Class<T> clazz) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(byArray, n2, n3), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, TypeReference typeReference) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(byArray), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, TypeReference typeReference) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(byArray, n2, n3), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, JavaType javaType) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(byArray), javaType);
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, JavaType javaType) {
        return (T)this._readMapAndClose(this._jsonFactory.createJsonParser(byArray, n2, n3), javaType);
    }

    public void writeValue(File file, Object object) {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(Writer writer, Object object) {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(writer), object);
    }

    public String writeValueAsString(Object object) {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(segmentedStringWriter), object);
        return segmentedStringWriter.getAndClear();
    }

    public byte[] writeValueAsBytes(Object object) {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(byteArrayBuilder, JsonEncoding.UTF8), object);
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public ObjectWriter writer() {
        return new ObjectWriter(this, this.getSerializationConfig());
    }

    public ObjectWriter writer(SerializationFeature serializationFeature) {
        return new ObjectWriter(this, this.getSerializationConfig().with(serializationFeature));
    }

    public ObjectWriter writer(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        return new ObjectWriter(this, this.getSerializationConfig().with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter writer(DateFormat dateFormat) {
        return new ObjectWriter(this, this.getSerializationConfig().with(dateFormat));
    }

    public ObjectWriter writerWithView(Class<?> clazz) {
        return new ObjectWriter(this, (SerializationConfig)this.getSerializationConfig().withView((Class)clazz));
    }

    public ObjectWriter writerWithType(Class<?> clazz) {
        JavaType javaType = clazz == null ? null : this._typeFactory.constructType(clazz);
        return new ObjectWriter(this, this.getSerializationConfig(), javaType, null);
    }

    public ObjectWriter writerWithType(JavaType javaType) {
        return new ObjectWriter(this, this.getSerializationConfig(), javaType, null);
    }

    public ObjectWriter writerWithType(TypeReference<?> typeReference) {
        JavaType javaType = typeReference == null ? null : this._typeFactory.constructType(typeReference);
        return new ObjectWriter(this, this.getSerializationConfig(), javaType, null);
    }

    public ObjectWriter writer(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == null) {
            prettyPrinter = ObjectWriter.NULL_PRETTY_PRINTER;
        }
        return new ObjectWriter(this, this.getSerializationConfig(), null, prettyPrinter);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        return new ObjectWriter(this, this.getSerializationConfig(), null, this._defaultPrettyPrinter());
    }

    public ObjectWriter writer(FilterProvider filterProvider) {
        return new ObjectWriter(this, this.getSerializationConfig().withFilters(filterProvider));
    }

    public ObjectWriter writer(FormatSchema formatSchema) {
        return new ObjectWriter(this, this.getSerializationConfig(), formatSchema);
    }

    public ObjectReader reader() {
        return new ObjectReader(this, this.getDeserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature) {
        return new ObjectReader(this, this.getDeserializationConfig().with(deserializationFeature));
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return new ObjectReader(this, this.getDeserializationConfig().with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader readerForUpdating(Object object) {
        JavaType javaType = this._typeFactory.constructType(object.getClass());
        return new ObjectReader(this, this.getDeserializationConfig(), javaType, object, null, this._injectableValues);
    }

    public ObjectReader reader(JavaType javaType) {
        return new ObjectReader(this, this.getDeserializationConfig(), javaType, null, null, this._injectableValues);
    }

    public ObjectReader reader(Class<?> clazz) {
        return this.reader(this._typeFactory.constructType(clazz));
    }

    public ObjectReader reader(TypeReference<?> typeReference) {
        return this.reader(this._typeFactory.constructType(typeReference));
    }

    public ObjectReader reader(JsonNodeFactory jsonNodeFactory) {
        return new ObjectReader(this, this.getDeserializationConfig()).with(jsonNodeFactory);
    }

    public ObjectReader reader(FormatSchema formatSchema) {
        return new ObjectReader(this, this.getDeserializationConfig(), null, null, formatSchema, this._injectableValues);
    }

    public ObjectReader reader(InjectableValues injectableValues) {
        return new ObjectReader(this, this.getDeserializationConfig(), null, null, null, injectableValues);
    }

    public ObjectReader readerWithView(Class<?> clazz) {
        return new ObjectReader(this, (DeserializationConfig)this.getDeserializationConfig().withView((Class)clazz));
    }

    public <T> T convertValue(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz != Object.class && clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        return (T)this._convert(object, this._typeFactory.constructType(clazz));
    }

    public <T> T convertValue(Object object, TypeReference<?> typeReference) {
        return this.convertValue(object, this._typeFactory.constructType(typeReference));
    }

    public <T> T convertValue(Object object, JavaType javaType) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = javaType.getRawClass();
        if (clazz != Object.class && !javaType.hasGenericTypes() && clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        return (T)this._convert(object, javaType);
    }

    protected Object _convert(Object object, JavaType javaType) {
        TokenBuffer tokenBuffer = new TokenBuffer(this);
        try {
            Object object2;
            SerializationConfig serializationConfig = this.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
            this._serializerProvider(serializationConfig).serializeValue(tokenBuffer, object);
            JsonParser jsonParser = tokenBuffer.asParser();
            DeserializationConfig deserializationConfig = this.getDeserializationConfig();
            JsonToken jsonToken = this._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                object2 = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue();
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object2 = null;
            } else {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
                object2 = jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            }
            jsonParser.close();
            return object2;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public JsonSchema generateJsonSchema(Class<?> clazz) {
        return this._serializerProvider(this.getSerializationConfig()).generateJsonSchema(clazz);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    protected PrettyPrinter _defaultPrettyPrinter() {
        return new DefaultPrettyPrinter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, serializationConfig);
            return;
        }
        boolean bl = false;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object, Class<?> clazz) {
        MapperConfigBase mapperConfigBase = this.getSerializationConfig().withView((Class)clazz);
        if (((SerializationConfig)mapperConfigBase).isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        if (((SerializationConfig)mapperConfigBase).isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._configAndWriteCloseable(jsonGenerator, object, (SerializationConfig)mapperConfigBase);
            return;
        }
        boolean bl = false;
        try {
            this._serializerProvider((SerializationConfig)mapperConfigBase).serializeValue(jsonGenerator, object);
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _configAndWriteCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            JsonGenerator jsonGenerator2 = jsonGenerator;
            jsonGenerator = null;
            jsonGenerator2.close();
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (jsonGenerator != null) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        finally {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected final DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._deserializationContext.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    protected Object _readValue(DeserializationConfig deserializationConfig, JsonParser jsonParser, JavaType javaType) {
        Object object;
        JsonToken jsonToken = this._initForReading(jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL) {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
            object = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue();
        } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            object = null;
        } else {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
            object = deserializationConfig.useRootWrapping() ? this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, deserializationConfig, javaType, jsonDeserializer) : jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
        }
        jsonParser.clearCurrentToken();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _readMapAndClose(JsonParser jsonParser, JavaType javaType) {
        try {
            Object object;
            Object object2;
            JsonToken jsonToken = this._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                object2 = this.createDeserializationContext(jsonParser, this.getDeserializationConfig());
                object = this._findRootDeserializer((DeserializationContext)object2, javaType).getNullValue();
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object = null;
            } else {
                object2 = this.getDeserializationConfig();
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, (DeserializationConfig)object2);
                JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, javaType);
                object = ((DeserializationConfig)object2).useRootWrapping() ? this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, (DeserializationConfig)object2, javaType, jsonDeserializer) : jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            }
            jsonParser.clearCurrentToken();
            object2 = object;
            return object2;
        }
        finally {
            try {
                jsonParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected JsonToken _initForReading(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JsonMappingException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        Object object;
        String string = deserializationConfig.getRootName();
        if (string == null) {
            object = this._rootNames.findRootName(javaType, deserializationConfig);
            string = ((SerializedString)object).getValue();
        }
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not START_OBJECT (needed to unwrap root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            throw JsonMappingException.from(jsonParser, "Current token not FIELD_NAME (to contain expected root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        object = jsonParser.getCurrentName();
        if (!string.equals(object)) {
            throw JsonMappingException.from(jsonParser, "Root name '" + (String)object + "' does not match expected ('" + string + "') for type " + javaType);
        }
        jsonParser.nextToken();
        Object object2 = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not END_OBJECT (to match wrapper object with root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        return object2;
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            throw new JsonMappingException("Can not find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }
}

