/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.DatabindVersion;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectReader
extends ObjectCodec
implements Versioned {
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _jsonFactory;
    protected final boolean _unwrapRoot;
    protected final JavaType _valueType;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;
    protected final RootNameLookup _rootNames;

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig) {
        this(objectMapper, deserializationConfig, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        this._config = deserializationConfig;
        this._context = objectMapper._deserializationContext;
        this._rootDeserializers = objectMapper._rootDeserializers;
        this._jsonFactory = objectMapper._jsonFactory;
        this._rootNames = objectMapper._rootNames;
        this._valueType = javaType;
        this._valueToUpdate = object;
        if (object != null && javaType.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._jsonFactory = objectReader._jsonFactory;
        this._rootNames = objectReader._rootNames;
        this._valueType = javaType;
        this._valueToUpdate = object;
        if (object != null && javaType.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._jsonFactory = objectReader._jsonFactory;
        this._rootNames = objectReader._rootNames;
        this._valueType = objectReader._valueType;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
    }

    @Override
    public Version version() {
        return DatabindVersion.instance.version();
    }

    public ObjectReader with(DeserializationFeature deserializationFeature) {
        DeserializationConfig deserializationConfig = this._config.with(deserializationFeature);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        DeserializationConfig deserializationConfig = this._config.with(deserializationFeature, deserializationFeatureArray);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        DeserializationConfig deserializationConfig = this._config.withFeatures(deserializationFeatureArray);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader without(DeserializationFeature deserializationFeature) {
        DeserializationConfig deserializationConfig = this._config.without(deserializationFeature);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        DeserializationConfig deserializationConfig = this._config.without(deserializationFeature, deserializationFeatureArray);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        DeserializationConfig deserializationConfig = this._config.withoutFeatures(deserializationFeatureArray);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return new ObjectReader(this, this._config, this._valueType, this._valueToUpdate, this._schema, injectableValues);
    }

    public ObjectReader with(JsonNodeFactory jsonNodeFactory) {
        DeserializationConfig deserializationConfig = this._config.with(jsonNodeFactory);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader withRootName(String string) {
        DeserializationConfig deserializationConfig = this._config.withRootName(string);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader with(FormatSchema formatSchema) {
        if (this._schema == formatSchema) {
            return this;
        }
        return new ObjectReader(this, this._config, this._valueType, this._valueToUpdate, formatSchema, this._injectableValues);
    }

    public ObjectReader withType(JavaType javaType) {
        if (javaType != null && javaType.equals(this._valueType)) {
            return this;
        }
        return new ObjectReader(this, this._config, javaType, this._valueToUpdate, this._schema, this._injectableValues);
    }

    public ObjectReader withType(Class<?> clazz) {
        return this.withType(this._config.constructType(clazz));
    }

    public ObjectReader withType(Type type) {
        return this.withType(this._config.getTypeFactory().constructType(type));
    }

    public ObjectReader withType(TypeReference<?> typeReference) {
        return this.withType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectReader withValueToUpdate(Object object) {
        if (object == this._valueToUpdate) {
            return this;
        }
        if (object == null) {
            throw new IllegalArgumentException("cat not update null value");
        }
        JavaType javaType = this._valueType == null ? this._config.constructType(object.getClass()) : this._valueType;
        return new ObjectReader(this, this._config, javaType, object, this._schema, this._injectableValues);
    }

    public ObjectReader withView(Class<?> clazz) {
        MapperConfigBase mapperConfigBase = this._config.withView((Class)clazz);
        return mapperConfigBase == this._config ? this : new ObjectReader(this, (DeserializationConfig)mapperConfigBase);
    }

    public ObjectReader with(Locale locale) {
        DeserializationConfig deserializationConfig = this._config.with(locale);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public ObjectReader with(TimeZone timeZone) {
        DeserializationConfig deserializationConfig = this._config.with(timeZone);
        return deserializationConfig == this._config ? this : new ObjectReader(this, deserializationConfig);
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._config.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return this._jsonFactory.isEnabled(jsonParser$Feature);
    }

    @Override
    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public <T> T readValue(JsonParser jsonParser) {
        return (T)this._bind(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) {
        return this.withType(clazz).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<?> typeReference) {
        return this.withType(typeReference).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) {
        return this.withType((JavaType)resolvedType).readValue(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) {
        return this.withType(javaType).readValue(jsonParser);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) {
        return (T)this._bindAsTree(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, Class<T> clazz) {
        return this.withType(clazz).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, TypeReference<?> typeReference) {
        return this.withType(typeReference).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, JavaType javaType) {
        return this.withType(javaType).readValues(jsonParser);
    }

    public <T> T readValue(InputStream inputStream) {
        return (T)this._bindAndClose(this._jsonFactory.createJsonParser(inputStream));
    }

    public <T> T readValue(Reader reader) {
        return (T)this._bindAndClose(this._jsonFactory.createJsonParser(reader));
    }

    public <T> T readValue(String string) {
        return (T)this._bindAndClose(this._jsonFactory.createJsonParser(string));
    }

    public <T> T readValue(byte[] byArray) {
        return (T)this._bindAndClose(this._jsonFactory.createJsonParser(byArray));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3) {
        return (T)this._bindAndClose(this._jsonFactory.createJsonParser(byArray, n2, n3));
    }

    public <T> T readValue(File file) {
        return (T)this._bindAndClose(this._jsonFactory.createJsonParser(file));
    }

    public <T> T readValue(URL uRL) {
        return (T)this._bindAndClose(this._jsonFactory.createJsonParser(uRL));
    }

    public <T> T readValue(JsonNode jsonNode) {
        return (T)this._bindAndClose(this.treeAsTokens(jsonNode));
    }

    public JsonNode readTree(InputStream inputStream) {
        return this._bindAndCloseAsTree(this._jsonFactory.createJsonParser(inputStream));
    }

    public JsonNode readTree(Reader reader) {
        return this._bindAndCloseAsTree(this._jsonFactory.createJsonParser(reader));
    }

    public JsonNode readTree(String string) {
        return this._bindAndCloseAsTree(this._jsonFactory.createJsonParser(string));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser) {
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), false, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(InputStream inputStream) {
        JsonParser jsonParser = this._jsonFactory.createJsonParser(inputStream);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(Reader reader) {
        JsonParser jsonParser = this._jsonFactory.createJsonParser(reader);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(String string) {
        JsonParser jsonParser = this._jsonFactory.createJsonParser(string);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(byte[] byArray, int n2, int n3) {
        JsonParser jsonParser = this._jsonFactory.createJsonParser(byArray, n2, n3);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    public final <T> MappingIterator<T> readValues(byte[] byArray) {
        return this.readValues(byArray, 0, byArray.length);
    }

    public <T> MappingIterator<T> readValues(File file) {
        JsonParser jsonParser = this._jsonFactory.createJsonParser(file);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    public <T> MappingIterator<T> readValues(URL uRL) {
        JsonParser jsonParser = this._jsonFactory.createJsonParser(uRL);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
        return new MappingIterator(this._valueType, jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext, this._valueType), true, this._valueToUpdate);
    }

    protected final DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._context.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    protected Object _bind(JsonParser jsonParser) {
        Object object;
        JsonToken jsonToken = ObjectReader._initForReading(jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL) {
            if (this._valueToUpdate == null) {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
                object = this._findRootDeserializer(defaultDeserializationContext, this._valueType).getNullValue();
            } else {
                object = this._valueToUpdate;
            }
        } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            object = this._valueToUpdate;
        } else {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, this._valueType);
            if (this._unwrapRoot) {
                object = this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, this._valueType, jsonDeserializer);
            } else if (this._valueToUpdate == null) {
                object = jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
            } else {
                jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext, this._valueToUpdate);
                object = this._valueToUpdate;
            }
        }
        jsonParser.clearCurrentToken();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object _bindAndClose(JsonParser jsonParser) {
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        try {
            Object object;
            Object object2;
            JsonToken jsonToken = ObjectReader._initForReading(jsonParser);
            if (jsonToken == JsonToken.VALUE_NULL) {
                if (this._valueToUpdate == null) {
                    object2 = this.createDeserializationContext(jsonParser, this._config);
                    object = this._findRootDeserializer((DeserializationContext)object2, this._valueType).getNullValue();
                } else {
                    object = this._valueToUpdate;
                }
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object = this._valueToUpdate;
            } else {
                object2 = this.createDeserializationContext(jsonParser, this._config);
                JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer((DeserializationContext)object2, this._valueType);
                if (this._unwrapRoot) {
                    object = this._unwrapAndDeserialize(jsonParser, (DeserializationContext)object2, this._valueType, jsonDeserializer);
                } else if (this._valueToUpdate == null) {
                    object = jsonDeserializer.deserialize(jsonParser, (DeserializationContext)object2);
                } else {
                    jsonDeserializer.deserialize(jsonParser, (DeserializationContext)object2, this._valueToUpdate);
                    object = this._valueToUpdate;
                }
            }
            object2 = object;
            return object2;
        }
        finally {
            try {
                jsonParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected JsonNode _bindAsTree(JsonParser jsonParser) {
        JsonNode jsonNode;
        JsonToken jsonToken = ObjectReader._initForReading(jsonParser);
        if (jsonToken == JsonToken.VALUE_NULL || jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
            jsonNode = NullNode.instance;
        } else {
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, this._config);
            JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer(defaultDeserializationContext, JSON_NODE_TYPE);
            jsonNode = this._unwrapRoot ? (JsonNode)this._unwrapAndDeserialize(jsonParser, defaultDeserializationContext, JSON_NODE_TYPE, jsonDeserializer) : (JsonNode)jsonDeserializer.deserialize(jsonParser, defaultDeserializationContext);
        }
        jsonParser.clearCurrentToken();
        return jsonNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonNode _bindAndCloseAsTree(JsonParser jsonParser) {
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        try {
            JsonNode jsonNode = this._bindAsTree(jsonParser);
            return jsonNode;
        }
        finally {
            try {
                jsonParser.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static JsonToken _initForReading(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JsonMappingException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) {
        if (javaType == null) {
            throw new JsonMappingException("No value type configured for ObjectReader");
        }
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            throw new JsonMappingException("Can not find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected Object _unwrapAndDeserialize(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType, JsonDeserializer<Object> jsonDeserializer) {
        Object object;
        Object object2;
        String string = this._config.getRootName();
        if (string == null) {
            object2 = this._rootNames.findRootName(javaType, this._config);
            string = ((SerializedString)object2).getValue();
        }
        if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not START_OBJECT (needed to unwrap root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        if (jsonParser.nextToken() != JsonToken.FIELD_NAME) {
            throw JsonMappingException.from(jsonParser, "Current token not FIELD_NAME (to contain expected root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        object2 = jsonParser.getCurrentName();
        if (!string.equals(object2)) {
            throw JsonMappingException.from(jsonParser, "Root name '" + (String)object2 + "' does not match expected ('" + string + "') for type " + javaType);
        }
        jsonParser.nextToken();
        if (this._valueToUpdate == null) {
            object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        } else {
            jsonDeserializer.deserialize(jsonParser, deserializationContext, this._valueToUpdate);
            object = this._valueToUpdate;
        }
        if (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            throw JsonMappingException.from(jsonParser, "Current token not END_OBJECT (to match wrapper object with root name '" + string + "'), but " + (Object)((Object)jsonParser.getCurrentToken()));
        }
        return object;
    }

    @Override
    public JsonNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    @Override
    public JsonNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) {
        try {
            return this.readValue(this.treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }
}

