/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonAutoDetect$Visibility;
import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig> {
    protected final int _serFeatures;
    protected JsonInclude$Include _serializationInclusion = null;
    protected final FilterProvider _filterProvider;

    public SerializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, Map<ClassKey, Class<?>> map) {
        super(baseSettings, subtypeResolver, map);
        this._serFeatures = SerializationConfig.collectFeatureDefaults(SerializationFeature.class);
        this._filterProvider = null;
    }

    private SerializationConfig(SerializationConfig serializationConfig, SubtypeResolver subtypeResolver) {
        super(serializationConfig, subtypeResolver);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
    }

    private SerializationConfig(SerializationConfig serializationConfig, int n2, int n3) {
        super(serializationConfig, n2);
        this._serFeatures = n3;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
    }

    private SerializationConfig(SerializationConfig serializationConfig, BaseSettings baseSettings) {
        super(serializationConfig, baseSettings);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
    }

    private SerializationConfig(SerializationConfig serializationConfig, FilterProvider filterProvider) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = filterProvider;
    }

    private SerializationConfig(SerializationConfig serializationConfig, Class<?> clazz) {
        super(serializationConfig, clazz);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
    }

    private SerializationConfig(SerializationConfig serializationConfig, JsonInclude$Include include) {
        super(serializationConfig);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = include;
        this._filterProvider = serializationConfig._filterProvider;
    }

    private SerializationConfig(SerializationConfig serializationConfig, String string) {
        super(serializationConfig, string);
        this._serFeatures = serializationConfig._serFeatures;
        this._serializationInclusion = serializationConfig._serializationInclusion;
        this._filterProvider = serializationConfig._filterProvider;
    }

    @Override
    public SerializationConfig with(MapperFeature ... mapperFeatureArray) {
        int n2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n2 |= mapperFeature.getMask();
        }
        return n2 == this._mapperFeatures ? this : new SerializationConfig(this, n2, this._serFeatures);
    }

    @Override
    public SerializationConfig without(MapperFeature ... mapperFeatureArray) {
        int n2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n2 &= ~mapperFeature.getMask();
        }
        return n2 == this._mapperFeatures ? this : new SerializationConfig(this, n2, this._serFeatures);
    }

    @Override
    public SerializationConfig with(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public SerializationConfig withAppendedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAppendedAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public SerializationConfig withInsertedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withInsertedAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public SerializationConfig with(ClassIntrospector classIntrospector) {
        return this._withBase(this._base.withClassIntrospector(classIntrospector));
    }

    @Override
    public SerializationConfig with(DateFormat dateFormat) {
        SerializationConfig serializationConfig = new SerializationConfig(this, this._base.withDateFormat(dateFormat));
        serializationConfig = dateFormat == null ? serializationConfig.with(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS) : serializationConfig.without(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return serializationConfig;
    }

    @Override
    public SerializationConfig with(HandlerInstantiator handlerInstantiator) {
        return this._withBase(this._base.withHandlerInstantiator(handlerInstantiator));
    }

    @Override
    public SerializationConfig with(PropertyNamingStrategy propertyNamingStrategy) {
        return this._withBase(this._base.withPropertyNamingStrategy(propertyNamingStrategy));
    }

    @Override
    public SerializationConfig withRootName(String string) {
        if (string == null ? this._rootName == null : string.equals(this._rootName)) {
            return this;
        }
        return new SerializationConfig(this, string);
    }

    @Override
    public SerializationConfig with(SubtypeResolver subtypeResolver) {
        return subtypeResolver == this._subtypeResolver ? this : new SerializationConfig(this, subtypeResolver);
    }

    @Override
    public SerializationConfig with(TypeFactory typeFactory) {
        return this._withBase(this._base.withTypeFactory(typeFactory));
    }

    @Override
    public SerializationConfig with(TypeResolverBuilder<?> typeResolverBuilder) {
        return this._withBase(this._base.withTypeResolverBuilder(typeResolverBuilder));
    }

    @Override
    public SerializationConfig withView(Class<?> clazz) {
        return this._view == clazz ? this : new SerializationConfig(this, clazz);
    }

    @Override
    public SerializationConfig with(VisibilityChecker<?> visibilityChecker) {
        return this._withBase(this._base.withVisibilityChecker(visibilityChecker));
    }

    @Override
    public SerializationConfig withVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect$Visibility jsonAutoDetect$Visibility) {
        return this._withBase(this._base.withVisibility(propertyAccessor, jsonAutoDetect$Visibility));
    }

    @Override
    public SerializationConfig with(Locale locale) {
        return this._withBase(this._base.with(locale));
    }

    @Override
    public SerializationConfig with(TimeZone timeZone) {
        return this._withBase(this._base.with(timeZone));
    }

    private final SerializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new SerializationConfig(this, baseSettings);
    }

    public SerializationConfig with(SerializationFeature serializationFeature) {
        int n2 = this._serFeatures | serializationFeature.getMask();
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2);
    }

    public SerializationConfig with(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures | serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n2 |= serializationFeature2.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2);
    }

    public SerializationConfig withFeatures(SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n2 |= serializationFeature.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2);
    }

    public SerializationConfig without(SerializationFeature serializationFeature) {
        int n2 = this._serFeatures & ~serializationFeature.getMask();
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2);
    }

    public SerializationConfig without(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures & ~serializationFeature.getMask();
        for (SerializationFeature serializationFeature2 : serializationFeatureArray) {
            n2 &= ~serializationFeature2.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2);
    }

    public SerializationConfig withoutFeatures(SerializationFeature ... serializationFeatureArray) {
        int n2 = this._serFeatures;
        for (SerializationFeature serializationFeature : serializationFeatureArray) {
            n2 &= ~serializationFeature.getMask();
        }
        return n2 == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, n2);
    }

    public SerializationConfig withFilters(FilterProvider filterProvider) {
        return filterProvider == this._filterProvider ? this : new SerializationConfig(this, filterProvider);
    }

    public SerializationConfig withSerializationInclusion(JsonInclude$Include jsonInclude$Include) {
        return this._serializationInclusion == jsonInclude$Include ? this : new SerializationConfig(this, jsonInclude$Include);
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return this._rootName.length() > 0;
        }
        return this.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
    }

    @Override
    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return super.getAnnotationIntrospector();
        }
        return AnnotationIntrospector.nopInstance();
    }

    @Override
    public BeanDescription introspectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forClassAnnotations(this, javaType, this);
    }

    @Override
    public BeanDescription introspectDirectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forDirectClassAnnotations(this, javaType, this);
    }

    @Override
    public VisibilityChecker<?> getDefaultVisibilityChecker() {
        VisibilityChecker<?> visibilityChecker = super.getDefaultVisibilityChecker();
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_GETTERS)) {
            visibilityChecker = visibilityChecker.withGetterVisibility(JsonAutoDetect$Visibility.NONE);
        }
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_IS_GETTERS)) {
            visibilityChecker = visibilityChecker.withIsGetterVisibility(JsonAutoDetect$Visibility.NONE);
        }
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_FIELDS)) {
            visibilityChecker = visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.NONE);
        }
        return visibilityChecker;
    }

    public final boolean isEnabled(SerializationFeature serializationFeature) {
        return (this._serFeatures & serializationFeature.getMask()) != 0;
    }

    public final int getSerializationFeatures() {
        return this._serFeatures;
    }

    public JsonInclude$Include getSerializationInclusion() {
        if (this._serializationInclusion != null) {
            return this._serializationInclusion;
        }
        return JsonInclude$Include.ALWAYS;
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public <T extends BeanDescription> T introspect(JavaType javaType) {
        return (T)this.getClassIntrospector().forSerialization(this, javaType, this);
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._serFeatures) + "]";
    }
}

