/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector$MixInResolver;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapperConfig<T extends MapperConfig<T>>
implements ClassIntrospector$MixInResolver {
    protected final int _mapperFeatures;
    protected final BaseSettings _base;

    protected MapperConfig(BaseSettings baseSettings, int n2) {
        this._base = baseSettings;
        this._mapperFeatures = n2;
    }

    protected MapperConfig(MapperConfig<T> mapperConfig) {
        this._base = mapperConfig._base;
        this._mapperFeatures = mapperConfig._mapperFeatures;
    }

    public static <F extends Enum<F>> int collectFeatureDefaults(Class<F> clazz) {
        int n2 = 0;
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (!((ConfigFeature)((Object)enum_)).enabledByDefault()) continue;
            n2 |= ((ConfigFeature)((Object)enum_)).getMask();
        }
        return n2;
    }

    public abstract T with(MapperFeature ... var1);

    public abstract T without(MapperFeature ... var1);

    public final boolean isEnabled(MapperFeature mapperFeature) {
        return (this._mapperFeatures & mapperFeature.getMask()) != 0;
    }

    public final boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(MapperFeature.USE_ANNOTATIONS);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
    }

    public final boolean shouldSortPropertiesAlphabetically() {
        return this.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
    }

    public abstract boolean useRootWrapping();

    public ClassIntrospector getClassIntrospector() {
        return this._base.getClassIntrospector();
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._base.getAnnotationIntrospector();
    }

    public VisibilityChecker<?> getDefaultVisibilityChecker() {
        return this._base.getVisibilityChecker();
    }

    public final PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._base.getPropertyNamingStrategy();
    }

    public final HandlerInstantiator getHandlerInstantiator() {
        return this._base.getHandlerInstantiator();
    }

    public final TypeResolverBuilder<?> getDefaultTyper(JavaType javaType) {
        return this._base.getTypeResolverBuilder();
    }

    public abstract SubtypeResolver getSubtypeResolver();

    public final TypeFactory getTypeFactory() {
        return this._base.getTypeFactory();
    }

    public final JavaType constructType(Class<?> clazz) {
        return this.getTypeFactory().constructType(clazz, (TypeBindings)null);
    }

    public final JavaType constructType(TypeReference<?> typeReference) {
        return this.getTypeFactory().constructType(typeReference.getType(), (TypeBindings)null);
    }

    public JavaType constructSpecializedType(JavaType javaType, Class<?> clazz) {
        return this.getTypeFactory().constructSpecializedType(javaType, clazz);
    }

    public BeanDescription introspectClassAnnotations(Class<?> clazz) {
        return this.introspectClassAnnotations(this.constructType(clazz));
    }

    public abstract BeanDescription introspectClassAnnotations(JavaType var1);

    public BeanDescription introspectDirectClassAnnotations(Class<?> clazz) {
        return this.introspectDirectClassAnnotations(this.constructType(clazz));
    }

    public abstract BeanDescription introspectDirectClassAnnotations(JavaType var1);

    public final DateFormat getDateFormat() {
        return this._base.getDateFormat();
    }

    public final Locale getLocale() {
        return this._base.getLocale();
    }

    public final TimeZone getTimeZone() {
        return this._base.getTimeZone();
    }

    public abstract Class<?> getActiveView();

    public TypeResolverBuilder<?> typeResolverBuilderInstance(Annotated annotated, Class<? extends TypeResolverBuilder<?>> clazz) {
        TypeResolverBuilder<?> typeResolverBuilder;
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (typeResolverBuilder = handlerInstantiator.typeResolverBuilderInstance(this, annotated, clazz)) != null) {
            return typeResolverBuilder;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }

    public TypeIdResolver typeIdResolverInstance(Annotated annotated, Class<? extends TypeIdResolver> clazz) {
        TypeIdResolver typeIdResolver;
        HandlerInstantiator handlerInstantiator = this.getHandlerInstantiator();
        if (handlerInstantiator != null && (typeIdResolver = handlerInstantiator.typeIdResolverInstance(this, annotated, clazz)) != null) {
            return typeIdResolver;
        }
        return ClassUtil.createInstance(clazz, this.canOverrideAccessModifiers());
    }
}

