/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerator$IdKey;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonDeserializer$None;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer$None;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultDeserializationContext
extends DeserializationContext {
    protected LinkedHashMap<ObjectIdGenerator$IdKey, ReadableObjectId> _objectIds;

    protected DefaultDeserializationContext(DeserializerFactory deserializerFactory, DeserializerCache deserializerCache) {
        super(deserializerFactory, deserializerCache);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializationConfig deserializationConfig, JsonParser jsonParser, InjectableValues injectableValues) {
        super(defaultDeserializationContext, deserializationConfig, jsonParser, injectableValues);
    }

    protected DefaultDeserializationContext(DefaultDeserializationContext defaultDeserializationContext, DeserializerFactory deserializerFactory) {
        super(defaultDeserializationContext, deserializerFactory);
    }

    @Override
    public ReadableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator) {
        ReadableObjectId readableObjectId;
        ObjectIdGenerator$IdKey objectIdGenerator$IdKey = objectIdGenerator.key(object);
        if (this._objectIds == null) {
            this._objectIds = new LinkedHashMap();
        } else {
            readableObjectId = this._objectIds.get(objectIdGenerator$IdKey);
            if (readableObjectId != null) {
                return readableObjectId;
            }
        }
        readableObjectId = new ReadableObjectId(object);
        this._objectIds.put(objectIdGenerator$IdKey, readableObjectId);
        return readableObjectId;
    }

    @Override
    public ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) {
        Class<? extends ObjectIdGenerator<?>> clazz = objectIdInfo.getGeneratorType();
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        ObjectIdGenerator<?> objectIdGenerator = handlerInstantiator != null ? handlerInstantiator.objectIdGeneratorInstance(this._config, annotated, clazz) : ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        return objectIdGenerator.forScope(objectIdInfo.getScope());
    }

    @Override
    public JsonDeserializer<Object> deserializerInstance(Annotated annotated, Object object) {
        JsonDeserializer jsonDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonDeserializer) {
            jsonDeserializer = (JsonDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + object.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == JsonDeserializer$None.class || clazz == NoClass.class) {
                return null;
            }
            if (!JsonDeserializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            jsonDeserializer = handlerInstantiator != null ? handlerInstantiator.deserializerInstance(this._config, annotated, clazz) : (JsonDeserializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        if (jsonDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)jsonDeserializer)).resolve(this);
        }
        return jsonDeserializer;
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated annotated, Object object) {
        KeyDeserializer keyDeserializer;
        if (object == null) {
            return null;
        }
        if (object instanceof KeyDeserializer) {
            keyDeserializer = (KeyDeserializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + object.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == KeyDeserializer$None.class || clazz == NoClass.class) {
                return null;
            }
            if (!KeyDeserializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<KeyDeserializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            keyDeserializer = handlerInstantiator != null ? handlerInstantiator.keyDeserializerInstance(this._config, annotated, clazz) : (KeyDeserializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        if (keyDeserializer instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)((Object)keyDeserializer)).resolve(this);
        }
        return keyDeserializer;
    }

    public abstract DefaultDeserializationContext with(DeserializerFactory var1);

    public abstract DefaultDeserializationContext createInstance(DeserializationConfig var1, JsonParser var2, InjectableValues var3);
}

