/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler$ExtTypedProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTypeHandler {
    private final ExternalTypeHandler$ExtTypedProperty[] _properties;
    private final HashMap<String, Integer> _nameToPropertyIndex;
    private final String[] _typeIds;
    private final TokenBuffer[] _tokens;

    protected ExternalTypeHandler(ExternalTypeHandler$ExtTypedProperty[] externalTypeHandler$ExtTypedPropertyArray, HashMap<String, Integer> hashMap, String[] stringArray, TokenBuffer[] tokenBufferArray) {
        this._properties = externalTypeHandler$ExtTypedPropertyArray;
        this._nameToPropertyIndex = hashMap;
        this._typeIds = stringArray;
        this._tokens = tokenBufferArray;
    }

    protected ExternalTypeHandler(ExternalTypeHandler externalTypeHandler) {
        this._properties = externalTypeHandler._properties;
        this._nameToPropertyIndex = externalTypeHandler._nameToPropertyIndex;
        int n2 = this._properties.length;
        this._typeIds = new String[n2];
        this._tokens = new TokenBuffer[n2];
    }

    public ExternalTypeHandler start() {
        return new ExternalTypeHandler(this);
    }

    public boolean handleTypePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) {
        boolean bl;
        Integer n2 = this._nameToPropertyIndex.get(string);
        if (n2 == null) {
            return false;
        }
        int n3 = n2;
        ExternalTypeHandler$ExtTypedProperty externalTypeHandler$ExtTypedProperty = this._properties[n3];
        if (!externalTypeHandler$ExtTypedProperty.hasTypePropertyName(string)) {
            return false;
        }
        this._typeIds[n3] = jsonParser.getText();
        boolean bl2 = bl = object != null && this._tokens[n3] != null;
        if (bl) {
            this._deserializeAndSet(jsonParser, deserializationContext, object, n3);
            this._typeIds[n3] = null;
            this._tokens[n3] = null;
        }
        return true;
    }

    public boolean handlePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) {
        boolean bl;
        Integer n2 = this._nameToPropertyIndex.get(string);
        if (n2 == null) {
            return false;
        }
        int n3 = n2;
        ExternalTypeHandler$ExtTypedProperty externalTypeHandler$ExtTypedProperty = this._properties[n3];
        if (externalTypeHandler$ExtTypedProperty.hasTypePropertyName(string)) {
            this._typeIds[n3] = jsonParser.getText();
            jsonParser.skipChildren();
            bl = object != null && this._tokens[n3] != null;
        } else {
            TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
            tokenBuffer.copyCurrentStructure(jsonParser);
            this._tokens[n3] = tokenBuffer;
            boolean bl2 = bl = object != null && this._typeIds[n3] != null;
        }
        if (bl) {
            this._deserializeAndSet(jsonParser, deserializationContext, object, n3);
            this._typeIds[n3] = null;
            this._tokens[n3] = null;
        }
        return true;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        int n2 = this._properties.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._typeIds[i2] == null) {
                if (this._tokens[i2] == null) continue;
                throw deserializationContext.mappingException("Missing external type id property '" + this._properties[i2].getTypePropertyName());
            }
            if (this._tokens[i2] == null) {
                SettableBeanProperty settableBeanProperty = this._properties[i2].getProperty();
                throw deserializationContext.mappingException("Missing property '" + settableBeanProperty.getName() + "' for external type id '" + this._properties[i2].getTypePropertyName());
            }
            this._deserializeAndSet(jsonParser, deserializationContext, object, i2);
        }
        return object;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer, PropertyBasedCreator propertyBasedCreator) {
        int n2;
        int n3 = this._properties.length;
        Object[] objectArray = new Object[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            if (this._typeIds[n2] == null) {
                if (this._tokens[n2] == null) continue;
                throw deserializationContext.mappingException("Missing external type id property '" + this._properties[n2].getTypePropertyName());
            }
            if (this._tokens[n2] == null) {
                SettableBeanProperty settableBeanProperty = this._properties[n2].getProperty();
                throw deserializationContext.mappingException("Missing property '" + settableBeanProperty.getName() + "' for external type id '" + this._properties[n2].getTypePropertyName());
            }
            objectArray[n2] = this._deserialize(jsonParser, deserializationContext, n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            SettableBeanProperty settableBeanProperty = this._properties[n2].getProperty();
            if (propertyBasedCreator.findCreatorProperty(settableBeanProperty.getName()) == null) continue;
            propertyValueBuffer.assignParameter(settableBeanProperty.getPropertyIndex(), objectArray[n2]);
        }
        Object object = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        for (int i2 = 0; i2 < n3; ++i2) {
            SettableBeanProperty settableBeanProperty = this._properties[i2].getProperty();
            if (propertyBasedCreator.findCreatorProperty(settableBeanProperty.getName()) != null) continue;
            settableBeanProperty.set(object, objectArray[i2]);
        }
        return object;
    }

    protected final Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) {
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(this._typeIds[n2]);
        JsonParser jsonParser2 = this._tokens[n2].asParser(jsonParser);
        jsonParser2.nextToken();
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        jsonParser2 = tokenBuffer.asParser(jsonParser);
        jsonParser2.nextToken();
        return this._properties[n2].getProperty().deserialize(jsonParser2, deserializationContext);
    }

    protected final void _deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, int n2) {
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser.getCodec());
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(this._typeIds[n2]);
        JsonParser jsonParser2 = this._tokens[n2].asParser(jsonParser);
        jsonParser2.nextToken();
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        jsonParser2 = tokenBuffer.asParser(jsonParser);
        jsonParser2.nextToken();
        this._properties[n2].getProperty().deserializeAndSet(jsonParser2, deserializationContext, object);
    }
}

