/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyBasedCreator {
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _properties;
    protected final int _propertyCount;
    protected final Object[] _defaultValues;
    protected final SettableBeanProperty[] _propertiesWithInjectables;

    protected PropertyBasedCreator(ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, Object[] objectArray) {
        int n2;
        this._valueInstantiator = valueInstantiator;
        this._properties = new HashMap();
        SettableBeanProperty[] settableBeanPropertyArray2 = null;
        this._propertyCount = n2 = settableBeanPropertyArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
            this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
            Object object = settableBeanProperty.getInjectableValueId();
            if (object == null) continue;
            if (settableBeanPropertyArray2 == null) {
                settableBeanPropertyArray2 = new SettableBeanProperty[n2];
            }
            settableBeanPropertyArray2[i2] = settableBeanProperty;
        }
        this._defaultValues = objectArray;
        this._propertiesWithInjectables = settableBeanPropertyArray2;
    }

    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        int n2 = settableBeanPropertyArray.length;
        SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n2];
        Object[] objectArray = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
            if (!settableBeanProperty.hasValueDeserializer()) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.findContextualValueDeserializer(settableBeanProperty.getType(), settableBeanProperty));
            }
            settableBeanPropertyArray2[i2] = settableBeanProperty;
            JsonDeserializer<Object> jsonDeserializer = settableBeanProperty.getValueDeserializer();
            Object object2 = object = jsonDeserializer == null ? null : jsonDeserializer.getNullValue();
            if (object == null && settableBeanProperty.getType().isPrimitive()) {
                object = ClassUtil.defaultValue(settableBeanProperty.getType().getRawClass());
            }
            if (object == null) continue;
            if (objectArray == null) {
                objectArray = new Object[n2];
            }
            objectArray[i2] = object;
        }
        return new PropertyBasedCreator(valueInstantiator, settableBeanPropertyArray2, objectArray);
    }

    public void assignDeserializer(SettableBeanProperty settableBeanProperty, JsonDeserializer<Object> jsonDeserializer) {
        settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
        this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
    }

    public Collection<SettableBeanProperty> properties() {
        return this._properties.values();
    }

    public SettableBeanProperty findCreatorProperty(String string) {
        return this._properties.get(string);
    }

    public PropertyValueBuffer startBuilding(JsonParser jsonParser, DeserializationContext deserializationContext) {
        PropertyValueBuffer propertyValueBuffer = new PropertyValueBuffer(jsonParser, deserializationContext, this._propertyCount);
        if (this._propertiesWithInjectables != null) {
            propertyValueBuffer.inject(this._propertiesWithInjectables);
        }
        return propertyValueBuffer;
    }

    public Object build(DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer) {
        Object object = this._valueInstantiator.createFromObjectWith(deserializationContext, propertyValueBuffer.getParameters(this._defaultValues));
        PropertyValue propertyValue = propertyValueBuffer.buffered();
        while (propertyValue != null) {
            propertyValue.assign(object);
            propertyValue = propertyValue.next;
        }
        return object;
    }
}

