/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    public FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public final T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return null;
            }
            try {
                T t2 = this._deserialize(string, deserializationContext);
                if (t2 != null) {
                    return t2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw deserializationContext.weirdStringException(this._valueClass, "not a valid textual representation");
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        throw deserializationContext.mappingException(this._valueClass);
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2);

    protected T _deserializeEmbedded(Object object, DeserializationContext deserializationContext) {
        throw deserializationContext.mappingException("Don't know how to convert embedded Object of type " + object.getClass().getName() + " into " + this._valueClass.getName());
    }
}

