/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public final class NumberDeserializers$NumberDeserializer
extends StdScalarDeserializer<Number> {
    public NumberDeserializers$NumberDeserializer() {
        super(Number.class);
    }

    @Override
    public Number deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                return jsonParser.getBigIntegerValue();
            }
            return jsonParser.getNumberValue();
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                return jsonParser.getDecimalValue();
            }
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                if (string.indexOf(46) >= 0) {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return new BigDecimal(string);
                    }
                    return new Double(string);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return new BigInteger(string);
                }
                long l2 = Long.parseLong(string);
                if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                    return (int)l2;
                }
                return l2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid number");
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_STRING: {
                return this.deserialize(jsonParser, deserializationContext);
            }
        }
        return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
    }
}

