/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.ArrayBuilders$DoubleBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
final class PrimitiveArrayDeserializers$DoubleDeser
extends PrimitiveArrayDeserializers$Base<double[]> {
    public PrimitiveArrayDeserializers$DoubleDeser() {
        super(double[].class);
    }

    @Override
    public double[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$DoubleBuilder arrayBuilders$DoubleBuilder = deserializationContext.getArrayBuilders().getDoubleBuilder();
        double[] dArray = (double[])arrayBuilders$DoubleBuilder.resetAndStart();
        int n2 = 0;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            double d2 = this._parseDoublePrimitive(jsonParser, deserializationContext);
            if (n2 >= dArray.length) {
                dArray = arrayBuilders$DoubleBuilder.appendCompletedChunk(dArray, n2);
                n2 = 0;
            }
            dArray[n2++] = d2;
        }
        return arrayBuilders$DoubleBuilder.completeAndClearBuffer(dArray, n2);
    }

    private final double[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new double[]{this._parseDoublePrimitive(jsonParser, deserializationContext)};
    }
}

