/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.ArrayBuilders$ShortBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
final class PrimitiveArrayDeserializers$ShortDeser
extends PrimitiveArrayDeserializers$Base<short[]> {
    public PrimitiveArrayDeserializers$ShortDeser() {
        super(short[].class);
    }

    @Override
    public short[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$ShortBuilder arrayBuilders$ShortBuilder = deserializationContext.getArrayBuilders().getShortBuilder();
        short[] sArray = (short[])arrayBuilders$ShortBuilder.resetAndStart();
        int n2 = 0;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            short s2 = this._parseShortPrimitive(jsonParser, deserializationContext);
            if (n2 >= sArray.length) {
                sArray = arrayBuilders$ShortBuilder.appendCompletedChunk(sArray, n2);
                n2 = 0;
            }
            sArray[n2++] = s2;
        }
        return arrayBuilders$ShortBuilder.completeAndClearBuffer(sArray, n2);
    }

    private final short[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new short[]{this._parseShortPrimitive(jsonParser, deserializationContext)};
    }
}

