/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.EnumValues;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class EnumMapSerializer
extends ContainerSerializer<EnumMap<? extends Enum<?>, ?>>
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final BeanProperty _property;
    protected final EnumValues _keyEnums;
    protected final JavaType _valueType;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;

    public EnumMapSerializer(JavaType javaType, boolean bl, EnumValues enumValues, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(EnumMap.class, false);
        this._property = null;
        this._staticTyping = bl || javaType != null && javaType.isFinal();
        this._valueType = javaType;
        this._keyEnums = enumValues;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
    }

    public EnumMapSerializer(EnumMapSerializer enumMapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        super(enumMapSerializer);
        this._property = beanProperty;
        this._staticTyping = enumMapSerializer._staticTyping;
        this._valueType = enumMapSerializer._valueType;
        this._keyEnums = enumMapSerializer._keyEnums;
        this._valueTypeSerializer = enumMapSerializer._valueTypeSerializer;
        this._valueSerializer = jsonSerializer;
    }

    public EnumMapSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new EnumMapSerializer(this._valueType, this._staticTyping, this._keyEnums, typeSerializer, this._valueSerializer);
    }

    public EnumMapSerializer withValueSerializer(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) {
        if (this._property == beanProperty && jsonSerializer == this._valueSerializer) {
            return this;
        }
        return new EnumMapSerializer(this, beanProperty, jsonSerializer);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        if (this._valueSerializer == null) {
            if (this._staticTyping) {
                return this.withValueSerializer(beanProperty, serializerProvider.findValueSerializer(this._valueType, beanProperty));
            }
        } else if (this._valueSerializer instanceof ContextualSerializer) {
            return this.withValueSerializer(beanProperty, ((ContextualSerializer)((Object)this._valueSerializer)).createContextual(serializerProvider, beanProperty));
        }
        return this;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(EnumMap<? extends Enum<?>, ?> enumMap) {
        return enumMap == null || enumMap.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumMap<? extends Enum<?>, ?> enumMap) {
        return enumMap.size() == 1;
    }

    @Override
    public void serialize(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartObject();
        if (!enumMap.isEmpty()) {
            this.serializeContents(enumMap, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    @Override
    public void serializeWithType(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        typeSerializer.writeTypePrefixForObject(enumMap, jsonGenerator);
        if (!enumMap.isEmpty()) {
            this.serializeContents(enumMap, jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForObject(enumMap, jsonGenerator);
    }

    protected void serializeContents(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._valueSerializer != null) {
            this.serializeContentsUsing(enumMap, jsonGenerator, serializerProvider, this._valueSerializer);
            return;
        }
        JsonSerializer<Object> jsonSerializer = null;
        Class<?> clazz = null;
        EnumValues enumValues = this._keyEnums;
        for (Map.Entry<Enum<?>, ?> entry : enumMap.entrySet()) {
            JsonSerializer<Object> jsonSerializer2;
            StdSerializer<Object> stdSerializer;
            Enum<?> enum_ = entry.getKey();
            if (enumValues == null) {
                stdSerializer = (StdSerializer)serializerProvider.findValueSerializer(enum_.getDeclaringClass(), this._property);
                enumValues = ((EnumSerializer)stdSerializer).getEnumValues();
            }
            jsonGenerator.writeFieldName(enumValues.serializedValueFor(enum_));
            stdSerializer = entry.getValue();
            if (stdSerializer == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz2 = stdSerializer.getClass();
            if (clazz2 == clazz) {
                jsonSerializer2 = jsonSerializer;
            } else {
                jsonSerializer = jsonSerializer2 = serializerProvider.findValueSerializer(clazz2, this._property);
                clazz = clazz2;
            }
            try {
                jsonSerializer2.serialize(stdSerializer, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, enumMap, entry.getKey().name());
            }
        }
    }

    protected void serializeContentsUsing(EnumMap<? extends Enum<?>, ?> enumMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) {
        EnumValues enumValues = this._keyEnums;
        for (Map.Entry<Enum<?>, ?> entry : enumMap.entrySet()) {
            StdSerializer<Object> stdSerializer;
            Enum<?> enum_ = entry.getKey();
            if (enumValues == null) {
                stdSerializer = (StdSerializer)serializerProvider.findValueSerializer(enum_.getDeclaringClass(), this._property);
                enumValues = ((EnumSerializer)stdSerializer).getEnumValues();
            }
            jsonGenerator.writeFieldName(enumValues.serializedValueFor(enum_));
            stdSerializer = entry.getValue();
            if (stdSerializer == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            try {
                jsonSerializer.serialize(stdSerializer, jsonGenerator, serializerProvider);
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, enumMap, entry.getKey().name());
            }
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        Type[] typeArray;
        ObjectNode objectNode = this.createSchemaNode("object", true);
        if (type instanceof ParameterizedType && (typeArray = ((ParameterizedType)type).getActualTypeArguments()).length == 2) {
            JavaType javaType = serializerProvider.constructType(typeArray[0]);
            JavaType javaType2 = serializerProvider.constructType(typeArray[1]);
            ObjectNode objectNode2 = JsonNodeFactory.instance.objectNode();
            Class<?> clazz = javaType.getRawClass();
            for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                JsonSerializer<Object> jsonSerializer = serializerProvider.findValueSerializer(javaType2.getRawClass(), this._property);
                JsonNode jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(serializerProvider, null) : JsonSchema.getDefaultSchemaNode();
                objectNode2.put(serializerProvider.getConfig().getAnnotationIntrospector().findEnumValue(enum_), jsonNode);
            }
            objectNode.put("properties", objectNode2);
        }
        return objectNode;
    }
}

