/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public final class StdArraySerializers$CharArraySerializer
extends StdSerializer<char[]> {
    public StdArraySerializers$CharArraySerializer() {
        super(char[].class);
    }

    @Override
    public boolean isEmpty(char[] cArray) {
        return cArray == null || cArray.length == 0;
    }

    @Override
    public void serialize(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
            jsonGenerator.writeStartArray();
            this._writeArrayContents(jsonGenerator, cArray);
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(cArray, 0, cArray.length);
        }
    }

    @Override
    public void serializeWithType(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
            typeSerializer.writeTypePrefixForArray(cArray, jsonGenerator);
            this._writeArrayContents(jsonGenerator, cArray);
            typeSerializer.writeTypeSuffixForArray(cArray, jsonGenerator);
        } else {
            typeSerializer.writeTypePrefixForScalar(cArray, jsonGenerator);
            jsonGenerator.writeString(cArray, 0, cArray.length);
            typeSerializer.writeTypeSuffixForScalar(cArray, jsonGenerator);
        }
    }

    private final void _writeArrayContents(JsonGenerator jsonGenerator, char[] cArray) {
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jsonGenerator.writeString(cArray, i2, 1);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        ObjectNode objectNode = this.createSchemaNode("array", true);
        ObjectNode objectNode2 = this.createSchemaNode("string");
        objectNode2.put("type", "string");
        objectNode.put("items", objectNode2);
        return objectNode;
    }
}

