/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumResolver<T extends Enum<T>> {
    protected final Class<T> _enumClass;
    protected final T[] _enums;
    protected final HashMap<String, T> _enumsById;

    protected EnumResolver(Class<T> clazz, T[] TArray, HashMap<String, T> hashMap) {
        this._enumClass = clazz;
        this._enums = TArray;
        this._enumsById = hashMap;
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructFor(Class<ET> clazz, AnnotationIntrospector annotationIntrospector) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        for (Enum enum_ : enumArray) {
            hashMap.put(annotationIntrospector.findEnumValue(enum_), enum_);
        }
        return new EnumResolver(clazz, enumArray, hashMap);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingToString(Class<ET> clazz) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum enum_ = enumArray[n2];
            hashMap.put(enum_.toString(), enum_);
        }
        return new EnumResolver(clazz, enumArray, hashMap);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingMethod(Class<ET> clazz, Method method) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum enum_ = enumArray[n2];
            try {
                Object object = method.invoke((Object)enum_, new Object[0]);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz, enumArray, hashMap);
    }

    public static EnumResolver<?> constructUnsafe(Class<?> clazz, AnnotationIntrospector annotationIntrospector) {
        Class<?> clazz2 = clazz;
        return EnumResolver.constructFor(clazz2, annotationIntrospector);
    }

    public static EnumResolver<?> constructUnsafeUsingToString(Class<?> clazz) {
        Class<?> clazz2 = clazz;
        return EnumResolver.constructUsingToString(clazz2);
    }

    public static EnumResolver<?> constructUnsafeUsingMethod(Class<?> clazz, Method method) {
        Class<?> clazz2 = clazz;
        return EnumResolver.constructUsingMethod(clazz2, method);
    }

    public T findEnum(String string) {
        return (T)((Enum)this._enumsById.get(string));
    }

    public T getEnum(int n2) {
        if (n2 < 0 || n2 >= this._enums.length) {
            return null;
        }
        return this._enums[n2];
    }

    public Class<T> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

