/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.ObjectBuffer$Node;
import java.lang.reflect.Array;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectBuffer {
    static final int INITIAL_CHUNK_SIZE = 12;
    static final int SMALL_CHUNK_SIZE = 16384;
    static final int MAX_CHUNK_SIZE = 262144;
    private ObjectBuffer$Node _bufferHead;
    private ObjectBuffer$Node _bufferTail;
    private int _bufferedEntryCount;
    private Object[] _freeBuffer;

    public Object[] resetAndStart() {
        this._reset();
        if (this._freeBuffer == null) {
            return new Object[12];
        }
        return this._freeBuffer;
    }

    public Object[] appendCompletedChunk(Object[] objectArray) {
        ObjectBuffer$Node objectBuffer$Node = new ObjectBuffer$Node(objectArray);
        if (this._bufferHead == null) {
            this._bufferHead = this._bufferTail = objectBuffer$Node;
        } else {
            this._bufferTail.linkNext(objectBuffer$Node);
            this._bufferTail = objectBuffer$Node;
        }
        int n2 = objectArray.length;
        this._bufferedEntryCount += n2;
        n2 = n2 < 16384 ? (n2 += n2) : (n2 += n2 >> 2);
        return new Object[n2];
    }

    public Object[] completeAndClearBuffer(Object[] objectArray, int n2) {
        int n3 = n2 + this._bufferedEntryCount;
        Object[] objectArray2 = new Object[n3];
        this._copyTo(objectArray2, n3, objectArray, n2);
        return objectArray2;
    }

    public <T> T[] completeAndClearBuffer(Object[] objectArray, int n2, Class<T> clazz) {
        int n3 = n2 + this._bufferedEntryCount;
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n3);
        this._copyTo(objectArray2, n3, objectArray, n2);
        this._reset();
        return objectArray2;
    }

    public void completeAndClearBuffer(Object[] objectArray, int n2, List<Object> list) {
        for (ObjectBuffer$Node objectBuffer$Node = this._bufferHead; objectBuffer$Node != null; objectBuffer$Node = objectBuffer$Node.next()) {
            Object[] objectArray2 = objectBuffer$Node.getData();
            int n3 = objectArray2.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                list.add(objectArray2[i2]);
            }
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            list.add(objectArray[i3]);
        }
    }

    public int initialCapacity() {
        return this._freeBuffer == null ? 0 : this._freeBuffer.length;
    }

    public int bufferedSize() {
        return this._bufferedEntryCount;
    }

    protected void _reset() {
        if (this._bufferTail != null) {
            this._freeBuffer = this._bufferTail.getData();
        }
        this._bufferTail = null;
        this._bufferHead = null;
        this._bufferedEntryCount = 0;
    }

    protected final void _copyTo(Object object, int n2, Object[] objectArray, int n3) {
        int n4 = 0;
        for (ObjectBuffer$Node objectBuffer$Node = this._bufferHead; objectBuffer$Node != null; objectBuffer$Node = objectBuffer$Node.next()) {
            Object[] objectArray2 = objectBuffer$Node.getData();
            int n5 = objectArray2.length;
            System.arraycopy(objectArray2, 0, object, n4, n5);
            n4 += n5;
        }
        System.arraycopy(objectArray, 0, object, n4, n3);
        if ((n4 += n3) != n2) {
            throw new IllegalStateException("Should have gotten " + n2 + " entries, got " + n4);
        }
    }
}

