/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.type.ClassKey;
import com.fasterxml.jackson.databind.util.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNameLookup {
    protected LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    public synchronized SerializedString findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        Object object;
        ClassKey classKey = new ClassKey(clazz);
        if (this._rootNames == null) {
            this._rootNames = new LRUMap(20, 200);
        } else {
            object = (SerializedString)this._rootNames.get(classKey);
            if (object != null) {
                return object;
            }
        }
        object = mapperConfig.introspectClassAnnotations(clazz);
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = ((BeanDescription)object).getClassInfo();
        String string = annotationIntrospector.findRootName(annotatedClass);
        if (string == null) {
            string = clazz.getSimpleName();
        }
        SerializedString serializedString = new SerializedString(string);
        this._rootNames.put(classKey, serializedString);
        return serializedString;
    }
}

