/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb;

import com.fasterxml.jackson.annotation.JsonAutoDetect$Visibility;
import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.annotation.ObjectIdGenerators$PropertyGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.jaxb.ModuleVersion;
import com.fasterxml.jackson.module.jaxb.deser.XmlAdapterJsonDeserializer;
import com.fasterxml.jackson.module.jaxb.ser.XmlAdapterJsonSerializer;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbAnnotationIntrospector
extends AnnotationIntrospector
implements Versioned {
    protected static final String MARKER_FOR_DEFAULT = "##default";
    protected final String _jaxbPackageName;
    protected final JsonSerializer<?> _dataHandlerSerializer;
    protected final JsonDeserializer<?> _dataHandlerDeserializer;
    protected final TypeFactory _typeFactory;

    public JaxbAnnotationIntrospector() {
        this(TypeFactory.defaultInstance());
    }

    public JaxbAnnotationIntrospector(MapperConfig<?> mapperConfig) {
        this(mapperConfig.getTypeFactory());
    }

    public JaxbAnnotationIntrospector(TypeFactory typeFactory) {
        this._typeFactory = typeFactory == null ? TypeFactory.defaultInstance() : typeFactory;
        this._jaxbPackageName = XmlElement.class.getPackage().getName();
        JsonSerializer jsonSerializer = null;
        JsonDeserializer jsonDeserializer = null;
        try {
            jsonSerializer = (JsonSerializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonSerializer").newInstance();
            jsonDeserializer = (JsonDeserializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonDeserializer").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._dataHandlerSerializer = jsonSerializer;
        this._dataHandlerDeserializer = jsonDeserializer;
    }

    @Override
    public Version version() {
        return ModuleVersion.instance.version();
    }

    @Override
    public boolean isHandled(Annotation annotation) {
        String string;
        Class<? extends Annotation> clazz = annotation.annotationType();
        Package package_ = clazz.getPackage();
        String string2 = string = package_ != null ? package_.getName() : clazz.getName();
        return string.startsWith(this._jaxbPackageName);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        XmlID xmlID;
        if (!(annotated instanceof AnnotatedClass)) {
            return null;
        }
        AnnotatedClass annotatedClass = (AnnotatedClass)annotated;
        String string = null;
        block4: for (AnnotatedMethod annotatedMember : annotatedClass.memberMethods()) {
            xmlID = annotatedMember.getAnnotation(XmlID.class);
            if (xmlID == null) continue;
            switch (annotatedMember.getParameterCount()) {
                case 0: {
                    string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMember, annotatedMember.getRawType(), BeanUtil.okNameForGetter(annotatedMember));
                    break block4;
                }
                case 1: {
                    string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMember, annotatedMember.getRawType(), BeanUtil.okNameForSetter(annotatedMember));
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (string == null) {
            for (AnnotatedField annotatedField : annotatedClass.fields()) {
                xmlID = annotatedField.getAnnotation(XmlID.class);
                if (xmlID == null) continue;
                string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), annotatedField.getName());
                break;
            }
        }
        if (string != null) {
            Class<Object> clazz = Object.class;
            return new ObjectIdInfo(string, clazz, ObjectIdGenerators$PropertyGenerator.class);
        }
        return null;
    }

    @Override
    public String findRootName(AnnotatedClass annotatedClass) {
        XmlRootElement xmlRootElement = this.findRootElementAnnotation(annotatedClass);
        if (xmlRootElement != null) {
            String string = xmlRootElement.name();
            return MARKER_FOR_DEFAULT.equals(string) ? "" : string;
        }
        return null;
    }

    @Override
    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        return null;
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        return null;
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return annotatedMember.getAnnotation(XmlTransient.class) != null;
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        XmlAccessType xmlAccessType = this.findAccessType(annotatedClass);
        if (xmlAccessType == null) {
            return visibilityChecker;
        }
        switch (xmlAccessType) {
            case FIELD: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.ANY).withSetterVisibility(JsonAutoDetect$Visibility.NONE).withGetterVisibility(JsonAutoDetect$Visibility.NONE).withIsGetterVisibility(JsonAutoDetect$Visibility.NONE);
            }
            case NONE: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.NONE).withSetterVisibility(JsonAutoDetect$Visibility.NONE).withGetterVisibility(JsonAutoDetect$Visibility.NONE).withIsGetterVisibility(JsonAutoDetect$Visibility.NONE);
            }
            case PROPERTY: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.NONE).withSetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY);
            }
            case PUBLIC_MEMBER: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY);
            }
        }
        return visibilityChecker;
    }

    protected XmlAccessType findAccessType(Annotated annotated) {
        XmlAccessorType xmlAccessorType = this.findAnnotation(XmlAccessorType.class, annotated, true, true, true);
        return xmlAccessorType == null ? null : xmlAccessorType.value();
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return null;
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.isContainerType()) {
            return null;
        }
        return this._typeResolverFromXmlElements(annotatedMember);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (!javaType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + javaType + ")");
        }
        return this._typeResolverFromXmlElements(annotatedMember);
    }

    protected TypeResolverBuilder<?> _typeResolverFromXmlElements(AnnotatedMember annotatedMember) {
        XmlElements xmlElements = this.findAnnotation(XmlElements.class, annotatedMember, false, false, false);
        XmlElementRefs xmlElementRefs = this.findAnnotation(XmlElementRefs.class, annotatedMember, false, false, false);
        if (xmlElements == null && xmlElementRefs == null) {
            return null;
        }
        StdTypeResolverBuilder stdTypeResolverBuilder = new StdTypeResolverBuilder();
        stdTypeResolverBuilder = stdTypeResolverBuilder.init(JsonTypeInfo$Id.NAME, null);
        stdTypeResolverBuilder = stdTypeResolverBuilder.inclusion(JsonTypeInfo$As.WRAPPER_OBJECT);
        return stdTypeResolverBuilder;
    }

    @Override
    public List<NamedType> findSubtypes(Annotated annotated) {
        XmlElements xmlElements = this.findAnnotation(XmlElements.class, annotated, false, false, false);
        if (xmlElements != null) {
            ArrayList<NamedType> arrayList = new ArrayList<NamedType>();
            for (XmlElement xmlElement : xmlElements.value()) {
                String string = xmlElement.name();
                if (MARKER_FOR_DEFAULT.equals(string)) {
                    string = null;
                }
                arrayList.add(new NamedType(xmlElement.type(), string));
            }
            return arrayList;
        }
        XmlElementRefs xmlElementRefs = this.findAnnotation(XmlElementRefs.class, annotated, false, false, false);
        if (xmlElementRefs != null) {
            ArrayList<NamedType> arrayList = new ArrayList<NamedType>();
            for (XmlElementRef xmlElementRef : xmlElementRefs.value()) {
                XmlRootElement xmlRootElement;
                Class clazz = xmlElementRef.type();
                if (JAXBElement.class.isAssignableFrom(clazz)) continue;
                String string = xmlElementRef.name();
                if ((string == null || MARKER_FOR_DEFAULT.equals(string)) && (xmlRootElement = clazz.getAnnotation(XmlRootElement.class)) != null) {
                    string = xmlRootElement.name();
                }
                if (string == null || MARKER_FOR_DEFAULT.equals(string)) {
                    string = Introspector.decapitalize(clazz.getSimpleName());
                }
                arrayList.add(new NamedType(clazz, string));
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        String string;
        XmlType xmlType = this.findAnnotation(XmlType.class, annotatedClass, false, false, false);
        if (xmlType != null && !MARKER_FOR_DEFAULT.equals(string = xmlType.name())) {
            return string;
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findSerializer(Annotated annotated) {
        Class<?> clazz = annotated.getRawType();
        XmlAdapter<Object, Object> xmlAdapter = this.findAdapter(annotated, true, clazz);
        if (xmlAdapter != null) {
            if (this.isContainerType(clazz)) {
                if (this.adapterTypeMatches(xmlAdapter, clazz)) {
                    return new XmlAdapterJsonSerializer(xmlAdapter);
                }
            } else {
                return new XmlAdapterJsonSerializer(xmlAdapter);
            }
        }
        if (clazz != null && this._dataHandlerSerializer != null && this.isDataHandler(clazz)) {
            return this._dataHandlerSerializer;
        }
        return null;
    }

    private boolean isDataHandler(Class<?> clazz) {
        return clazz != null && Object.class != clazz && ("javax.activation.DataHandler".equals(clazz.getName()) || this.isDataHandler(clazz.getSuperclass()));
    }

    @Override
    public Object findContentSerializer(Annotated annotated) {
        XmlAdapter<?, ?> xmlAdapter = this._findContentAdapter(annotated);
        return xmlAdapter == null ? null : new XmlAdapterJsonSerializer(xmlAdapter);
    }

    @Override
    public Class<?> findSerializationType(Annotated annotated) {
        XmlElement xmlElement = this.findAnnotation(XmlElement.class, annotated, false, false, false);
        if (xmlElement == null || xmlElement.type() == XmlElement.DEFAULT.class) {
            return null;
        }
        Class<?> clazz = annotated.getRawType();
        if (this.isContainerType(clazz)) {
            return null;
        }
        Class clazz2 = xmlElement.type();
        if (annotated.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return null;
        }
        return clazz2;
    }

    @Override
    public JsonInclude$Include findSerializationInclusion(Annotated annotated, JsonInclude$Include jsonInclude$Include) {
        XmlElementWrapper xmlElementWrapper = annotated.getAnnotation(XmlElementWrapper.class);
        if (xmlElementWrapper != null) {
            return xmlElementWrapper.nillable() ? JsonInclude$Include.ALWAYS : JsonInclude$Include.NON_NULL;
        }
        XmlElement xmlElement = annotated.getAnnotation(XmlElement.class);
        if (xmlElement != null) {
            return xmlElement.nillable() ? JsonInclude$Include.ALWAYS : JsonInclude$Include.NON_NULL;
        }
        return jsonInclude$Include;
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        XmlType xmlType = this.findAnnotation(XmlType.class, annotatedClass, true, true, true);
        if (xmlType == null) {
            return null;
        }
        String[] stringArray = xmlType.propOrder();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    @Override
    public Boolean findSerializationSortAlphabetically(AnnotatedClass annotatedClass) {
        XmlAccessorOrder xmlAccessorOrder = this.findAnnotation(XmlAccessorOrder.class, annotatedClass, true, true, true);
        return xmlAccessorOrder == null ? null : Boolean.valueOf(xmlAccessorOrder.value() == XmlAccessOrder.ALPHABETICAL);
    }

    @Override
    public String findSerializationName(AnnotatedMethod annotatedMethod) {
        if (!this.isVisible(annotatedMethod)) {
            return null;
        }
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, annotatedMethod.getRawType(), BeanUtil.okNameForGetter(annotatedMethod));
        if (string == null) {
            // empty if block
        }
        return string;
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    @Override
    public String findEnumValue(Enum<?> enum_) {
        Class<?> clazz = enum_.getDeclaringClass();
        String string = enum_.name();
        try {
            XmlEnumValue xmlEnumValue = clazz.getDeclaredField(string).getAnnotation(XmlEnumValue.class);
            return xmlEnumValue != null ? xmlEnumValue.value() : string;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("Could not locate Enum entry '" + string + "' (Enum class " + clazz.getName() + ")", noSuchFieldException);
        }
    }

    @Override
    public String findSerializationName(AnnotatedField annotatedField) {
        if (!this.isVisible(annotatedField)) {
            return null;
        }
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
        return string == null ? annotatedField.getName() : string;
    }

    @Override
    public Object findDeserializer(Annotated annotated) {
        Class<?> clazz = annotated.getRawType();
        XmlAdapter<Object, Object> xmlAdapter = this.findAdapter(annotated, true, clazz);
        if (xmlAdapter != null) {
            if (this.isContainerType(clazz)) {
                if (this.adapterTypeMatches(xmlAdapter, clazz)) {
                    return new XmlAdapterJsonDeserializer(xmlAdapter);
                }
            } else {
                return new XmlAdapterJsonDeserializer(xmlAdapter);
            }
        }
        if (clazz != null && this._dataHandlerDeserializer != null && this.isDataHandler(clazz)) {
            return this._dataHandlerDeserializer;
        }
        return null;
    }

    @Override
    public Object findKeyDeserializer(Annotated annotated) {
        return null;
    }

    @Override
    public Object findContentDeserializer(Annotated annotated) {
        XmlAdapter<?, ?> xmlAdapter = this._findContentAdapter(annotated);
        return xmlAdapter == null ? null : new XmlAdapterJsonDeserializer(xmlAdapter);
    }

    @Override
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        if (!javaType.isContainerType()) {
            return this._doFindDeserializationType(annotated, javaType);
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        return this._doFindDeserializationType(annotated, javaType);
    }

    protected Class<?> _doFindDeserializationType(Annotated annotated, JavaType javaType) {
        Class clazz;
        if (annotated.hasAnnotation(XmlJavaTypeAdapter.class)) {
            return null;
        }
        XmlElement xmlElement = this.findAnnotation(XmlElement.class, annotated, false, false, false);
        if (xmlElement != null && (clazz = xmlElement.type()) != XmlElement.DEFAULT.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public String findDeserializationName(AnnotatedMethod annotatedMethod) {
        if (!this.isVisible(annotatedMethod)) {
            return null;
        }
        Class<?> clazz = annotatedMethod.getRawParameterType(0);
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, clazz, BeanUtil.okNameForSetter(annotatedMethod));
        return string;
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated annotated) {
        return false;
    }

    @Override
    public String findDeserializationName(AnnotatedField annotatedField) {
        if (!this.isVisible(annotatedField)) {
            return null;
        }
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
        return string == null ? annotatedField.getName() : string;
    }

    @Override
    public String findDeserializationName(AnnotatedParameter annotatedParameter) {
        return null;
    }

    private boolean isVisible(AnnotatedField annotatedField) {
        for (XmlAccessType xmlAccessType : annotatedField.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled((Annotation)xmlAccessType)) continue;
            return true;
        }
        XmlAccessType xmlAccessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType xmlAccessorType = this.findAnnotation(XmlAccessorType.class, annotatedField, true, true, true);
        if (xmlAccessorType != null) {
            xmlAccessType = xmlAccessorType.value();
        }
        if (xmlAccessType == XmlAccessType.FIELD) {
            return true;
        }
        if (xmlAccessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(annotatedField.getAnnotated().getModifiers());
        }
        return false;
    }

    private boolean isVisible(AnnotatedMethod annotatedMethod) {
        for (XmlAccessType xmlAccessType : annotatedMethod.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled((Annotation)xmlAccessType)) continue;
            return true;
        }
        XmlAccessType xmlAccessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType xmlAccessorType = this.findAnnotation(XmlAccessorType.class, annotatedMethod, true, true, true);
        if (xmlAccessorType != null) {
            xmlAccessType = xmlAccessorType.value();
        }
        if (xmlAccessType == XmlAccessType.PROPERTY || xmlAccessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(annotatedMethod.getModifiers());
        }
        return false;
    }

    private <A extends Annotation> A findAnnotation(Class<A> clazz, Annotated annotated, boolean bl, boolean bl2, boolean bl3) {
        AnnotatedElement annotatedElement;
        A a2 = annotated.getAnnotation(clazz);
        if (a2 != null) {
            return a2;
        }
        Class clazz2 = null;
        if (annotated instanceof AnnotatedParameter) {
            clazz2 = ((AnnotatedParameter)annotated).getDeclaringClass();
        } else {
            annotatedElement = annotated.getAnnotated();
            if (annotatedElement instanceof Member) {
                clazz2 = ((Member)((Object)annotatedElement)).getDeclaringClass();
                if (bl2 && (a2 = clazz2.getAnnotation(clazz)) != null) {
                    return a2;
                }
            } else if (annotatedElement instanceof Class) {
                clazz2 = (Class)annotatedElement;
            } else {
                throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
            }
        }
        if (clazz2 != null) {
            if (bl3) {
                for (annotatedElement = clazz2.getSuperclass(); annotatedElement != null && annotatedElement != Object.class; annotatedElement = ((Class)annotatedElement).getSuperclass()) {
                    a2 = ((Class)annotatedElement).getAnnotation(clazz);
                    if (a2 == null) continue;
                    return a2;
                }
            }
            if (bl && (annotatedElement = clazz2.getPackage()) != null) {
                return clazz2.getPackage().getAnnotation(clazz);
            }
        }
        return null;
    }

    private static String findJaxbPropertyName(Annotated annotated, Class<?> clazz, String string) {
        String string2;
        XmlAttribute xmlAttribute = annotated.getAnnotation(XmlAttribute.class);
        if (xmlAttribute != null) {
            String string3 = xmlAttribute.name();
            if (!MARKER_FOR_DEFAULT.equals(string3)) {
                return string3;
            }
            return string;
        }
        XmlElement xmlElement = annotated.getAnnotation(XmlElement.class);
        if (xmlElement != null) {
            String string4 = xmlElement.name();
            if (!MARKER_FOR_DEFAULT.equals(string4)) {
                return string4;
            }
            return string;
        }
        XmlElementWrapper xmlElementWrapper = annotated.getAnnotation(XmlElementWrapper.class);
        if (xmlElementWrapper != null) {
            String string5 = xmlElementWrapper.name();
            if (!MARKER_FOR_DEFAULT.equals(string5)) {
                return string5;
            }
            return string;
        }
        XmlElementRef xmlElementRef = annotated.getAnnotation(XmlElementRef.class);
        if (xmlElementRef != null) {
            XmlRootElement xmlRootElement;
            string2 = xmlElementRef.name();
            if (!MARKER_FOR_DEFAULT.equals(string2)) {
                return string2;
            }
            if (clazz != null && (xmlRootElement = clazz.getAnnotation(XmlRootElement.class)) != null) {
                string2 = xmlRootElement.name();
                if (!MARKER_FOR_DEFAULT.equals(string2)) {
                    return string2;
                }
                return Introspector.decapitalize(clazz.getSimpleName());
            }
        }
        if ((string2 = annotated.getAnnotation(XmlValue.class)) != null) {
            return "value";
        }
        return null;
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass annotatedClass) {
        return this.findAnnotation(XmlRootElement.class, annotatedClass, true, false, true);
    }

    private XmlAdapter<Object, Object> findAdapter(Annotated annotated, boolean bl, Class<?> clazz) {
        XmlJavaTypeAdapter[] xmlJavaTypeAdapterArray;
        XmlJavaTypeAdapters xmlJavaTypeAdapters;
        XmlJavaTypeAdapter xmlJavaTypeAdapter;
        if (annotated instanceof AnnotatedClass) {
            return this.findAdapterForClass((AnnotatedClass)annotated, bl);
        }
        Member member = (Member)((Object)annotated.getAnnotated());
        if (member != null && (xmlJavaTypeAdapter = member.getDeclaringClass()) != null && (xmlJavaTypeAdapters = xmlJavaTypeAdapter.getAnnotation(XmlJavaTypeAdapter.class)) != null && (xmlJavaTypeAdapterArray = this.checkAdapter((XmlJavaTypeAdapter)xmlJavaTypeAdapters, clazz)) != null) {
            return xmlJavaTypeAdapterArray;
        }
        xmlJavaTypeAdapter = this.findAnnotation(XmlJavaTypeAdapter.class, annotated, true, false, false);
        if (xmlJavaTypeAdapter != null && (xmlJavaTypeAdapters = this.checkAdapter(xmlJavaTypeAdapter, clazz)) != null) {
            return xmlJavaTypeAdapters;
        }
        xmlJavaTypeAdapters = this.findAnnotation(XmlJavaTypeAdapters.class, annotated, true, false, false);
        if (xmlJavaTypeAdapters != null) {
            for (XmlJavaTypeAdapter xmlJavaTypeAdapter2 : xmlJavaTypeAdapters.value()) {
                XmlAdapter<Object, Object> xmlAdapter = this.checkAdapter(xmlJavaTypeAdapter2, clazz);
                if (xmlAdapter == null) continue;
                return xmlAdapter;
            }
        }
        return null;
    }

    private final XmlAdapter<Object, Object> checkAdapter(XmlJavaTypeAdapter xmlJavaTypeAdapter, Class<?> clazz) {
        Class clazz2 = xmlJavaTypeAdapter.type();
        if (clazz2 == XmlJavaTypeAdapter.DEFAULT.class || clazz2.isAssignableFrom(clazz)) {
            Class clazz3 = xmlJavaTypeAdapter.value();
            return (XmlAdapter)ClassUtil.createInstance(clazz3, false);
        }
        return null;
    }

    private XmlAdapter<Object, Object> findAdapterForClass(AnnotatedClass annotatedClass, boolean bl) {
        XmlJavaTypeAdapter xmlJavaTypeAdapter = ((Class)annotatedClass.getAnnotated()).getAnnotation(XmlJavaTypeAdapter.class);
        if (xmlJavaTypeAdapter != null) {
            Class clazz = xmlJavaTypeAdapter.value();
            return (XmlAdapter)ClassUtil.createInstance(clazz, false);
        }
        return null;
    }

    private final TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    private boolean isContainerType(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private boolean adapterTypeMatches(XmlAdapter<?, ?> xmlAdapter, Class<?> clazz) {
        return this.findAdapterBoundType(xmlAdapter).isAssignableFrom(clazz);
    }

    private Class<?> findAdapterBoundType(XmlAdapter<?, ?> xmlAdapter) {
        JavaType javaType;
        TypeFactory typeFactory = this.getTypeFactory();
        JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType = typeFactory.constructType(xmlAdapter.getClass()), XmlAdapter.class);
        if (javaTypeArray == null || javaTypeArray.length < 2) {
            return Object.class;
        }
        return javaTypeArray[1].getRawClass();
    }

    protected XmlAdapter<?, ?> _findContentAdapter(Annotated annotated) {
        Class<?> clazz = annotated.getRawType();
        if (this.isContainerType(clazz) && annotated instanceof AnnotatedMember) {
            AnnotatedMember annotatedMember = (AnnotatedMember)annotated;
            JavaType javaType = this.getTypeFactory().constructType(annotatedMember.getGenericType(), annotatedMember.getDeclaringClass());
            Class<?> clazz2 = javaType.getContentType().getRawClass();
            XmlAdapter<Object, Object> xmlAdapter = this.findAdapter(annotatedMember, true, clazz);
            if (xmlAdapter != null && this.adapterTypeMatches(xmlAdapter, clazz2)) {
                return xmlAdapter;
            }
        }
        return null;
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        XmlElement xmlElement = annotatedMember.getAnnotation(XmlElement.class);
        return xmlElement == null ? null : Boolean.valueOf(xmlElement.required());
    }
}

