/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.CoreVersion;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.sym.Name;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class UTF8StreamJsonParser
extends ParserBase {
    static final byte BYTE_LF = 10;
    private static final int[] sInputCodesUtf8 = CharTypes.getInputCodeUtf8();
    private static final int[] sInputCodesLatin1 = CharTypes.getInputCodeLatin1();
    protected ObjectCodec _objectCodec;
    protected final BytesToNameCanonicalizer _symbols;
    protected int[] _quadBuffer = new int[16];
    protected boolean _tokenIncomplete = false;
    private int _quad1;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;

    public UTF8StreamJsonParser(IOContext iOContext, int n2, InputStream inputStream, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer, byte[] byArray, int n3, int n4, boolean bl) {
        super(iOContext, n2);
        this._inputStream = inputStream;
        this._objectCodec = objectCodec;
        this._symbols = bytesToNameCanonicalizer;
        this._inputBuffer = byArray;
        this._inputPtr = n3;
        this._inputEnd = n4;
        this._bufferRecyclable = bl;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public Version version() {
        return CoreVersion.instance.version();
    }

    public int releaseBuffered(OutputStream outputStream) {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 < 1) {
            return 0;
        }
        int n3 = this._inputPtr;
        outputStream.write(this._inputBuffer, n3, n2);
        return n2;
    }

    public Object getInputSource() {
        return this._inputStream;
    }

    protected final boolean loadMore() {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._inputStream != null) {
            int n2 = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n2 > 0) {
                this._inputPtr = 0;
                this._inputEnd = n2;
                return true;
            }
            this._closeInput();
            if (n2 == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final boolean _loadToHaveAtLeast(int n2) {
        if (this._inputStream == null) {
            return false;
        }
        int n3 = this._inputEnd - this._inputPtr;
        if (n3 > 0 && this._inputPtr > 0) {
            this._currInputProcessed += (long)this._inputPtr;
            this._currInputRowStart -= this._inputPtr;
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n3);
            this._inputEnd = n3;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < n2) {
            int n4 = this._inputStream.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n4 < 1) {
                this._closeInput();
                if (n4 == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + n3 + " bytes");
                }
                return false;
            }
            this._inputEnd += n4;
        }
        return true;
    }

    protected void _closeInput() {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser$Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    protected void _releaseBuffers() {
        byte[] byArray;
        super._releaseBuffers();
        if (this._bufferRecyclable && (byArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(byArray);
        }
    }

    public String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken) {
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    public char[] getTextCharacters() {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return 0;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    public Object getEmbeddedObject() {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    public JsonToken nextToken() {
        JsonToken jsonToken;
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n2 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n2 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n2 = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            return this._nextTokenNotInObject(n2);
        }
        Name name = this._parseFieldName(n2);
        this._parsingContext.setCurrentName(name.getName());
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipWS();
        if (n2 != 58) {
            this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
        }
        if ((n2 = this._skipWS()) == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this.parseNumberText(n2);
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
        return this._currToken;
    }

    private final JsonToken _nextTokenNotInObject(int n2) {
        if (n2 == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n2) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this.parseNumberText(n2);
                return this._currToken;
            }
        }
        this._currToken = this._handleUnexpectedValue(n2);
        return this._currToken;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    public void close() {
        super.close();
        this._symbols.release();
    }

    public boolean nextFieldName(SerializableString serializableString) {
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return false;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n4 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return false;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n4 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n4, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return false;
        }
        if (n4 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n4, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return false;
        }
        if (this._parsingContext.expectComma()) {
            if (n4 != 44) {
                this._reportUnexpectedChar(n4, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n4 = this._skipWS();
        }
        if (!this._parsingContext.inObject()) {
            this._nextTokenNotInObject(n4);
            return false;
        }
        if (n4 == 34 && this._inputPtr + (n3 = (byArray = serializableString.asQuotedUTF8()).length) < this._inputEnd && this._inputBuffer[n2 = this._inputPtr + n3] == 34) {
            int n5 = 0;
            int n6 = this._inputPtr;
            while (true) {
                if (n5 == n3) {
                    this._inputPtr = n2 + 1;
                    this._parsingContext.setCurrentName(serializableString.getValue());
                    this._currToken = JsonToken.FIELD_NAME;
                    this._isNextTokenNameYes();
                    return true;
                }
                if (byArray[n5] != this._inputBuffer[n6 + n5]) break;
                ++n5;
            }
        }
        this._isNextTokenNameNo(n4);
        return false;
    }

    private final void _isNextTokenNameYes() {
        int n2;
        if (this._inputPtr < this._inputEnd && this._inputBuffer[this._inputPtr] == 58) {
            ++this._inputPtr;
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 34) {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            if (n2 == 123) {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            if (n2 == 91) {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            if ((n2 &= 0xFF) <= 32 || n2 == 47) {
                --this._inputPtr;
                n2 = this._skipWS();
            }
        } else {
            n2 = this._skipColon();
        }
        switch (n2) {
            case 34: {
                this._tokenIncomplete = true;
                this._nextToken = JsonToken.VALUE_STRING;
                return;
            }
            case 91: {
                this._nextToken = JsonToken.START_ARRAY;
                return;
            }
            case 123: {
                this._nextToken = JsonToken.START_OBJECT;
                return;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                this._nextToken = JsonToken.VALUE_TRUE;
                return;
            }
            case 102: {
                this._matchToken("false", 1);
                this._nextToken = JsonToken.VALUE_FALSE;
                return;
            }
            case 110: {
                this._matchToken("null", 1);
                this._nextToken = JsonToken.VALUE_NULL;
                return;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._nextToken = this.parseNumberText(n2);
                return;
            }
        }
        this._nextToken = this._handleUnexpectedValue(n2);
    }

    private final void _isNextTokenNameNo(int n2) {
        JsonToken jsonToken;
        Name name = this._parseFieldName(n2);
        this._parsingContext.setCurrentName(name.getName());
        this._currToken = JsonToken.FIELD_NAME;
        n2 = this._skipWS();
        if (n2 != 58) {
            this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
        }
        if ((n2 = this._skipWS()) == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return;
        }
        switch (n2) {
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this.parseNumberText(n2);
                break;
            }
            default: {
                jsonToken = this._handleUnexpectedValue(n2);
            }
        }
        this._nextToken = jsonToken;
    }

    public String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int n2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n2;
    }

    public long nextLongValue(long l2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l2;
    }

    public Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected final JsonToken parseNumberText(int n2) {
        boolean bl;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n3 = 0;
        boolean bl2 = bl = n2 == 45;
        if (bl) {
            cArray[n3++] = 45;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) {
                return this._handleInvalidNumberStart(n2, true);
            }
        }
        if (n2 == 48) {
            n2 = this._verifyNoLeadingZeroes();
        }
        cArray[n3++] = (char)n2;
        int n4 = 1;
        int n5 = this._inputPtr + cArray.length;
        if (n5 > this._inputEnd) {
            n5 = this._inputEnd;
        }
        while (true) {
            if (this._inputPtr >= n5) {
                return this._parserNumber2(cArray, n3, bl, n4);
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n2 > 57) break;
            ++n4;
            cArray[n3++] = (char)n2;
        }
        if (n2 == 46 || n2 == 101 || n2 == 69) {
            return this._parseFloatText(cArray, n3, n2, bl, n4);
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n3);
        return this.resetInt(bl, n4);
    }

    private final JsonToken _parserNumber2(char[] cArray, int n2, boolean bl, int n3) {
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuffer.setCurrentLength(n2);
                return this.resetInt(bl, n3);
            }
            if ((n4 = this._inputBuffer[this._inputPtr++] & 0xFF) > 57 || n4 < 48) {
                if (n4 != 46 && n4 != 101 && n4 != 69) break;
                return this._parseFloatText(cArray, n2, n4, bl, n3);
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n4;
            ++n3;
        }
        --this._inputPtr;
        this._textBuffer.setCurrentLength(n2);
        return this.resetInt(bl, n3);
    }

    private final int _verifyNoLeadingZeroes() {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return 48;
        }
        int n2 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n2 < 48 || n2 > 57) {
            return 48;
        }
        if (!this.isEnabled(JsonParser$Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (n2 == 48) {
            while (this._inputPtr < this._inputEnd || this.loadMore()) {
                n2 = this._inputBuffer[this._inputPtr] & 0xFF;
                if (n2 < 48 || n2 > 57) {
                    return 48;
                }
                ++this._inputPtr;
                if (n2 == 48) continue;
                break;
            }
        }
        return n2;
    }

    private final JsonToken _parseFloatText(char[] cArray, int n2, int n3, boolean bl, int n4) {
        int n5 = 0;
        boolean bl2 = false;
        if (n3 == 46) {
            cArray[n2++] = (char)n3;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) < 48 || n3 > 57) break;
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(n3, "Decimal point not followed by a digit");
            }
        }
        int n6 = 0;
        if (n3 == 101 || n3 == 69) {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n3 = this._inputBuffer[this._inputPtr++] & 0xFF) == 45 || n3 == 43) {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            while (n3 <= 57 && n3 >= 48) {
                ++n6;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = (char)n3;
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                n3 = this._inputBuffer[this._inputPtr++] & 0xFF;
            }
            if (n6 == 0) {
                this.reportUnexpectedNumberChar(n3, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
        }
        this._textBuffer.setCurrentLength(n2);
        return this.resetFloat(bl, n4, n5, n6);
    }

    protected final Name _parseFieldName(int n2) {
        int n3;
        if (n2 != 34) {
            return this._handleUnusualFieldName(n2);
        }
        if (this._inputPtr + 9 > this._inputEnd) {
            return this.slowParseFieldName();
        }
        int[] nArray = sInputCodesLatin1;
        byte[] byArray = this._inputBuffer;
        if (nArray[n3 = byArray[this._inputPtr++] & 0xFF] == 0) {
            if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                n3 = n3 << 8 | n2;
                if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                    n3 = n3 << 8 | n2;
                    if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                        n3 = n3 << 8 | n2;
                        if (nArray[n2 = byArray[this._inputPtr++] & 0xFF] == 0) {
                            this._quad1 = n3;
                            return this.parseMediumFieldName(n2, nArray);
                        }
                        if (n2 == 34) {
                            return this.findName(n3, 4);
                        }
                        return this.parseFieldName(n3, n2, 4);
                    }
                    if (n2 == 34) {
                        return this.findName(n3, 3);
                    }
                    return this.parseFieldName(n3, n2, 3);
                }
                if (n2 == 34) {
                    return this.findName(n3, 2);
                }
                return this.parseFieldName(n3, n2, 2);
            }
            if (n2 == 34) {
                return this.findName(n3, 1);
            }
            return this.parseFieldName(n3, n2, 1);
        }
        if (n3 == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseFieldName(0, n3, 0);
    }

    protected final Name parseMediumFieldName(int n2, int[] nArray) {
        int n3;
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 1);
            }
            return this.parseFieldName(this._quad1, n2, n3, 1);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 2);
            }
            return this.parseFieldName(this._quad1, n2, n3, 2);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 3);
            }
            return this.parseFieldName(this._quad1, n2, n3, 3);
        }
        n2 = n2 << 8 | n3;
        if (nArray[n3 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
            if (n3 == 34) {
                return this.findName(this._quad1, n2, 4);
            }
            return this.parseFieldName(this._quad1, n2, n3, 4);
        }
        this._quadBuffer[0] = this._quad1;
        this._quadBuffer[1] = n2;
        return this.parseLongFieldName(n3);
    }

    protected Name parseLongFieldName(int n2) {
        int[] nArray = sInputCodesLatin1;
        int n3 = 2;
        while (this._inputEnd - this._inputPtr >= 4) {
            int n4;
            if (nArray[n4 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n4 == 34) {
                    return this.findName(this._quadBuffer, n3, n2, 1);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n2, n4, 1);
            }
            n2 = n2 << 8 | n4;
            if (nArray[n4 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n4 == 34) {
                    return this.findName(this._quadBuffer, n3, n2, 2);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n2, n4, 2);
            }
            n2 = n2 << 8 | n4;
            if (nArray[n4 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n4 == 34) {
                    return this.findName(this._quadBuffer, n3, n2, 3);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n2, n4, 3);
            }
            n2 = n2 << 8 | n4;
            if (nArray[n4 = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                if (n4 == 34) {
                    return this.findName(this._quadBuffer, n3, n2, 4);
                }
                return this.parseEscapedFieldName(this._quadBuffer, n3, n2, n4, 4);
            }
            if (n3 >= this._quadBuffer.length) {
                this._quadBuffer = UTF8StreamJsonParser.growArrayBy(this._quadBuffer, n3);
            }
            this._quadBuffer[n3++] = n2;
            n2 = n4;
        }
        return this.parseEscapedFieldName(this._quadBuffer, n3, 0, n2, 0);
    }

    protected Name slowParseFieldName() {
        int n2;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing '\"' for name");
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 34) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        return this.parseEscapedFieldName(this._quadBuffer, 0, 0, n2, 0);
    }

    private final Name parseFieldName(int n2, int n3, int n4) {
        return this.parseEscapedFieldName(this._quadBuffer, 0, n2, n3, n4);
    }

    private final Name parseFieldName(int n2, int n3, int n4, int n5) {
        this._quadBuffer[0] = n2;
        return this.parseEscapedFieldName(this._quadBuffer, 1, n3, n4, n5);
    }

    protected Name parseEscapedFieldName(int[] nArray, int n2, int n3, int n4, int n5) {
        Name name;
        int[] nArray2 = sInputCodesLatin1;
        while (true) {
            if (nArray2[n4] != 0) {
                if (n4 == 34) break;
                if (n4 != 92) {
                    this._throwUnquotedSpace(n4, "name");
                } else {
                    n4 = this._decodeEscaped();
                }
                if (n4 > 127) {
                    if (n5 >= 4) {
                        if (n2 >= nArray.length) {
                            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            this._quadBuffer = nArray;
                        }
                        nArray[n2++] = n3;
                        n3 = 0;
                        n5 = 0;
                    }
                    if (n4 < 2048) {
                        n3 = n3 << 8 | (0xC0 | n4 >> 6);
                        ++n5;
                    } else {
                        n3 = n3 << 8 | (0xE0 | n4 >> 12);
                        if (++n5 >= 4) {
                            if (n2 >= nArray.length) {
                                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                                this._quadBuffer = nArray;
                            }
                            nArray[n2++] = n3;
                            n3 = 0;
                            n5 = 0;
                        }
                        n3 = n3 << 8 | (0x80 | n4 >> 6 & 0x3F);
                        ++n5;
                    }
                    n4 = 0x80 | n4 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n3 = n3 << 8 | n4;
            } else {
                if (n2 >= nArray.length) {
                    nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                    this._quadBuffer = nArray;
                }
                nArray[n2++] = n3;
                n3 = n4;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            n4 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n5 > 0) {
            if (n2 >= nArray.length) {
                nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                this._quadBuffer = nArray;
            }
            nArray[n2++] = n3;
        }
        if ((name = this._symbols.findName(nArray, n2)) == null) {
            name = this.addName(nArray, n2, n5);
        }
        return name;
    }

    protected final Name _handleUnusualFieldName(int n2) {
        Name name;
        int[] nArray;
        if (n2 == 39 && this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseApostropheFieldName();
        }
        if (!this.isEnabled(JsonParser$Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n2, "was expecting double-quote to start field name");
        }
        if ((nArray = CharTypes.getInputCodeUtf8JsNames())[n2] != 0) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int[] nArray2 = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray2.length) {
                    this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
                }
                nArray2[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            if (nArray[n2 = this._inputBuffer[this._inputPtr] & 0xFF] != 0) break;
            ++this._inputPtr;
        }
        if (n5 > 0) {
            if (n3 >= nArray2.length) {
                this._quadBuffer = nArray2 = UTF8StreamJsonParser.growArrayBy(nArray2, nArray2.length);
            }
            nArray2[n3++] = n4;
        }
        if ((name = this._symbols.findName(nArray2, n3)) == null) {
            name = this.addName(nArray2, n3, n5);
        }
        return name;
    }

    protected final Name _parseApostropheFieldName() {
        Name name;
        int n2;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(": was expecting closing ''' for name");
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 39) {
            return BytesToNameCanonicalizer.getEmptyName();
        }
        int[] nArray = this._quadBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray2 = sInputCodesLatin1;
        while (n2 != 39) {
            if (n2 != 34 && nArray2[n2] != 0) {
                if (n2 != 92) {
                    this._throwUnquotedSpace(n2, "name");
                } else {
                    n2 = this._decodeEscaped();
                }
                if (n2 > 127) {
                    if (n5 >= 4) {
                        if (n3 >= nArray.length) {
                            this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                        }
                        nArray[n3++] = n4;
                        n4 = 0;
                        n5 = 0;
                    }
                    if (n2 < 2048) {
                        n4 = n4 << 8 | (0xC0 | n2 >> 6);
                        ++n5;
                    } else {
                        n4 = n4 << 8 | (0xE0 | n2 >> 12);
                        if (++n5 >= 4) {
                            if (n3 >= nArray.length) {
                                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                            }
                            nArray[n3++] = n4;
                            n4 = 0;
                            n5 = 0;
                        }
                        n4 = n4 << 8 | (0x80 | n2 >> 6 & 0x3F);
                        ++n5;
                    }
                    n2 = 0x80 | n2 & 0x3F;
                }
            }
            if (n5 < 4) {
                ++n5;
                n4 = n4 << 8 | n2;
            } else {
                if (n3 >= nArray.length) {
                    this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
                }
                nArray[n3++] = n4;
                n4 = n2;
                n5 = 1;
            }
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in field name");
            }
            n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        }
        if (n5 > 0) {
            if (n3 >= nArray.length) {
                this._quadBuffer = nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            }
            nArray[n3++] = n4;
        }
        if ((name = this._symbols.findName(nArray, n3)) == null) {
            name = this.addName(nArray, n3, n5);
        }
        return name;
    }

    private final Name findName(int n2, int n3) {
        Name name = this._symbols.findName(n2);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n2;
        return this.addName(this._quadBuffer, 1, n3);
    }

    private final Name findName(int n2, int n3, int n4) {
        Name name = this._symbols.findName(n2, n3);
        if (name != null) {
            return name;
        }
        this._quadBuffer[0] = n2;
        this._quadBuffer[1] = n3;
        return this.addName(this._quadBuffer, 2, n4);
    }

    private final Name findName(int[] nArray, int n2, int n3, int n4) {
        if (n2 >= nArray.length) {
            nArray = UTF8StreamJsonParser.growArrayBy(nArray, nArray.length);
            this._quadBuffer = nArray;
        }
        nArray[n2++] = n3;
        Name name = this._symbols.findName(nArray, n2);
        if (name == null) {
            return this.addName(nArray, n2, n4);
        }
        return name;
    }

    private final Name addName(int[] nArray, int n2, int n3) {
        int n4;
        int n5 = (n2 << 2) - 4 + n3;
        if (n3 < 4) {
            n4 = nArray[n2 - 1];
            nArray[n2 - 1] = n4 << (4 - n3 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n5) {
            int n8 = nArray[n7 >> 2];
            int n9 = n7 & 3;
            n8 = n8 >> (3 - n9 << 3) & 0xFF;
            ++n7;
            if (n8 > 127) {
                int n10;
                if ((n8 & 0xE0) == 192) {
                    n8 &= 0x1F;
                    n10 = 1;
                } else if ((n8 & 0xF0) == 224) {
                    n8 &= 0xF;
                    n10 = 2;
                } else if ((n8 & 0xF8) == 240) {
                    n8 &= 7;
                    n10 = 3;
                } else {
                    this._reportInvalidInitial(n8);
                    n8 = 1;
                    n10 = 1;
                }
                if (n7 + n10 > n5) {
                    this._reportInvalidEOF(" in field name");
                }
                int n11 = nArray[n7 >> 2];
                n9 = n7 & 3;
                ++n7;
                if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n11);
                }
                n8 = n8 << 6 | n11 & 0x3F;
                if (n10 > 1) {
                    n11 = nArray[n7 >> 2];
                    n9 = n7 & 3;
                    ++n7;
                    if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n11);
                    }
                    n8 = n8 << 6 | n11 & 0x3F;
                    if (n10 > 2) {
                        n11 = nArray[n7 >> 2];
                        n9 = n7 & 3;
                        ++n7;
                        if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n11 & 0xFF);
                        }
                        n8 = n8 << 6 | n11 & 0x3F;
                    }
                }
                if (n10 > 2) {
                    n8 -= 65536;
                    if (n6 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n6++] = (char)(55296 + (n8 >> 10));
                    n8 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n6++] = (char)n8;
        }
        String string = new String(cArray, 0, n6);
        if (n3 < 4) {
            nArray[n2 - 1] = n4;
        }
        return this._symbols.addName(string, nArray, n2);
    }

    protected void _finishString() {
        int n2 = this._inputPtr;
        if (n2 >= this._inputEnd) {
            this.loadMoreGuaranteed();
            n2 = this._inputPtr;
        }
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = sInputCodesUtf8;
        int n4 = Math.min(this._inputEnd, n2 + cArray.length);
        byte[] byArray = this._inputBuffer;
        while (n2 < n4) {
            int n5 = byArray[n2] & 0xFF;
            if (nArray[n5] != 0) {
                if (n5 != 34) break;
                this._inputPtr = n2 + 1;
                this._textBuffer.setCurrentLength(n3);
                return;
            }
            ++n2;
            cArray[n3++] = (char)n5;
        }
        this._inputPtr = n2;
        this._finishString2(cArray, n3);
    }

    private final void _finishString2(char[] cArray, int n2) {
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n3;
            int n4;
            block15: {
                if ((n4 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n4 = this._inputPtr;
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                int n5 = Math.min(this._inputEnd, n4 + (cArray.length - n2));
                while (n4 < n5) {
                    if (nArray[n3 = byArray[n4++] & 0xFF] == 0) {
                        cArray[n2++] = (char)n3;
                        continue;
                    }
                    break block15;
                }
                this._inputPtr = n4;
                continue;
            }
            this._inputPtr = n4;
            if (n3 == 34) break;
            switch (nArray[n3]) {
                case 1: {
                    n3 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n3 = this._decodeUtf8_2(n3);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n3 = this._decodeUtf8_3fast(n3);
                        break;
                    }
                    n3 = this._decodeUtf8_3(n3);
                    break;
                }
                case 4: {
                    n3 = this._decodeUtf8_4(n3);
                    cArray[n2++] = (char)(0xD800 | n3 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    if (n3 < 32) {
                        this._throwUnquotedSpace(n3, "string value");
                        break;
                    }
                    this._reportInvalidChar(n3);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected void _skipString() {
        this._tokenIncomplete = false;
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n2;
            int n3;
            block10: {
                int n4;
                if ((n3 = this._inputPtr) >= (n4 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                    n4 = this._inputEnd;
                }
                while (n3 < n4) {
                    if (nArray[n2 = byArray[n3++] & 0xFF] == 0) continue;
                    break block10;
                }
                this._inputPtr = n3;
                continue;
            }
            this._inputPtr = n3;
            if (n2 == 34) break;
            switch (nArray[n2]) {
                case 1: {
                    this._decodeEscaped();
                    continue block6;
                }
                case 2: {
                    this._skipUtf8_2(n2);
                    continue block6;
                }
                case 3: {
                    this._skipUtf8_3(n2);
                    continue block6;
                }
                case 4: {
                    this._skipUtf8_4(n2);
                    continue block6;
                }
            }
            if (n2 < 32) {
                this._throwUnquotedSpace(n2, "string value");
                continue;
            }
            this._reportInvalidChar(n2);
        }
    }

    protected JsonToken _handleUnexpectedValue(int n2) {
        switch (n2) {
            case 39: {
                if (!this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApostropheValue();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this._reportInvalidEOFInValue();
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++] & 0xFF, false);
            }
        }
        this._reportUnexpectedChar(n2, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected JsonToken _handleApostropheValue() {
        int n2 = 0;
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = sInputCodesUtf8;
        byte[] byArray = this._inputBuffer;
        block6: while (true) {
            int n4;
            int n5;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            if ((n5 = this._inputPtr + (cArray.length - n3)) < (n4 = this._inputEnd)) {
                n4 = n5;
            }
            while (true) {
                if (this._inputPtr >= n4) continue block6;
                if ((n2 = byArray[this._inputPtr++] & 0xFF) == 39 || nArray[n2] != 0) break;
                cArray[n3++] = (char)n2;
            }
            if (n2 == 39) break;
            switch (nArray[n2]) {
                case 1: {
                    if (n2 == 34) break;
                    n2 = this._decodeEscaped();
                    break;
                }
                case 2: {
                    n2 = this._decodeUtf8_2(n2);
                    break;
                }
                case 3: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n2 = this._decodeUtf8_3fast(n2);
                        break;
                    }
                    n2 = this._decodeUtf8_3(n2);
                    break;
                }
                case 4: {
                    n2 = this._decodeUtf8_4(n2);
                    cArray[n3++] = (char)(0xD800 | n2 >> 10);
                    if (n3 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n3 = 0;
                    }
                    n2 = 0xDC00 | n2 & 0x3FF;
                    break;
                }
                default: {
                    if (n2 < 32) {
                        this._throwUnquotedSpace(n2, "string value");
                    }
                    this._reportInvalidChar(n2);
                }
            }
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            cArray[n3++] = (char)n2;
        }
        this._textBuffer.setCurrentLength(n3);
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl) {
        if (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 78) {
                String string = bl ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n2 == 110) {
                String string = bl ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected final void _matchToken(String string, int n2) {
        int n3 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in a value");
            }
            if (this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2), "'null', 'true', 'false' or NaN");
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return;
        }
        int n4 = this._inputBuffer[this._inputPtr] & 0xFF;
        if (n4 < 48 || n4 == 93 || n4 == 125) {
            return;
        }
        char c2 = (char)this._decodeCharForError(n4);
        if (Character.isJavaIdentifierPart(c2)) {
            ++this._inputPtr;
            this._reportInvalidToken(string.substring(0, n2), "'null', 'true', 'false' or NaN");
        }
    }

    protected void _reportInvalidToken(String string, String string2) {
        byte by2;
        char c2;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c2 = (char)this._decodeCharForError(by2 = this._inputBuffer[this._inputPtr++]))) {
            stringBuilder.append(c2);
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting " + string2);
    }

    private final int _skipWS() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 != 47) {
                    return n2;
                }
                this._skipComment();
                continue;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                this._skipLF();
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final int _skipWSOrEnd() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n2;
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 != 47) {
                    return n2;
                }
                this._skipComment();
                continue;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                this._skipLF();
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        this._handleEOF();
        return -1;
    }

    private final int _skipColon() {
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++]) == 58) {
            if (this._inputPtr < this._inputEnd && (n2 = this._inputBuffer[this._inputPtr] & 0xFF) > 32 && n2 != 47) {
                ++this._inputPtr;
                return n2;
            }
        } else {
            n2 &= 0xFF;
            block5: while (true) {
                switch (n2) {
                    case 9: 
                    case 13: 
                    case 32: {
                        this._skipCR();
                        continue block5;
                    }
                    case 10: {
                        this._skipLF();
                        continue block5;
                    }
                    case 47: {
                        this._skipComment();
                        continue block5;
                    }
                }
                break;
            }
            if (n2 < 32) {
                this._throwInvalidSpace(n2);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) != 58) {
                this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
            }
        }
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) > 32) {
                if (n2 != 47) {
                    return n2;
                }
                this._skipComment();
                continue;
            }
            if (n2 == 32) continue;
            if (n2 == 10) {
                this._skipLF();
                continue;
            }
            if (n2 == 13) {
                this._skipCR();
                continue;
            }
            if (n2 == 9) continue;
            this._throwInvalidSpace(n2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final void _skipComment() {
        int n2;
        if (!this.isEnabled(JsonParser$Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) == 47) {
            this._skipCppComment();
        } else if (n2 == 42) {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(n2, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n3) {
                case 42: {
                    if (this._inputPtr >= this._inputEnd && !this.loadMore()) break block8;
                    if (this._inputBuffer[this._inputPtr] != 47) continue block8;
                    ++this._inputPtr;
                    return;
                }
                case 10: {
                    this._skipLF();
                    break;
                }
                case 13: {
                    this._skipCR();
                    break;
                }
                case 2: {
                    this._skipUtf8_2(n2);
                    break;
                }
                case 3: {
                    this._skipUtf8_3(n2);
                    break;
                }
                case 4: {
                    this._skipUtf8_4(n2);
                    break;
                }
                default: {
                    this._reportInvalidChar(n2);
                }
            }
        }
        this._reportInvalidEOF(" in a comment");
    }

    private final void _skipCppComment() {
        int[] nArray = CharTypes.getInputCodeComment();
        block8: while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int n2;
            int n3;
            if ((n3 = nArray[n2 = this._inputBuffer[this._inputPtr++] & 0xFF]) == 0) continue;
            switch (n3) {
                case 10: {
                    this._skipLF();
                    return;
                }
                case 13: {
                    this._skipCR();
                    return;
                }
                case 42: {
                    continue block8;
                }
                case 2: {
                    this._skipUtf8_2(n2);
                    continue block8;
                }
                case 3: {
                    this._skipUtf8_3(n2);
                    continue block8;
                }
                case 4: {
                    this._skipUtf8_4(n2);
                    continue block8;
                }
            }
            this._reportInvalidChar(n2);
        }
    }

    protected final char _decodeEscaped() {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        byte by2 = this._inputBuffer[this._inputPtr++];
        switch (by2) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)by2;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)this._decodeCharForError(by2));
            }
        }
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            byte by3;
            int n3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n3 = CharTypes.charToHex(by3 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(by3, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n3;
        }
        return (char)n2;
    }

    protected int _decodeCharForError(int n2) {
        int n3 = n2;
        if (n3 < 0) {
            int n4;
            if ((n3 & 0xE0) == 192) {
                n3 &= 0x1F;
                n4 = 1;
            } else if ((n3 & 0xF0) == 224) {
                n3 &= 0xF;
                n4 = 2;
            } else if ((n3 & 0xF8) == 240) {
                n3 &= 7;
                n4 = 3;
            } else {
                this._reportInvalidInitial(n3 & 0xFF);
                n4 = 1;
            }
            int n5 = this.nextByte();
            if ((n5 & 0xC0) != 128) {
                this._reportInvalidOther(n5 & 0xFF);
            }
            n3 = n3 << 6 | n5 & 0x3F;
            if (n4 > 1) {
                n5 = this.nextByte();
                if ((n5 & 0xC0) != 128) {
                    this._reportInvalidOther(n5 & 0xFF);
                }
                n3 = n3 << 6 | n5 & 0x3F;
                if (n4 > 2) {
                    n5 = this.nextByte();
                    if ((n5 & 0xC0) != 128) {
                        this._reportInvalidOther(n5 & 0xFF);
                    }
                    n3 = n3 << 6 | n5 & 0x3F;
                }
            }
        }
        return n3;
    }

    private final int _decodeUtf8_2(int n2) {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        return (n2 & 0x1F) << 6 | by2 & 0x3F;
    }

    private final int _decodeUtf8_3(int n2) {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        n2 &= 0xF;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n3 = n2 << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | by2 & 0x3F;
        return n3;
    }

    private final int _decodeUtf8_3fast(int n2) {
        byte by2;
        n2 &= 0xF;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n3 = n2 << 6 | by2 & 0x3F;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | by2 & 0x3F;
        return n3;
    }

    private final int _decodeUtf8_4(int n2) {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n2 = (n2 & 7) << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        return (n2 << 6 | by2 & 0x3F) - 65536;
    }

    private final void _skipUtf8_2(int n2) {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_3(int n2) {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((n2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(n2 & 0xFF, this._inputPtr);
        }
    }

    private final void _skipUtf8_4(int n2) {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
    }

    protected final void _skipCR() {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == 10) {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected final void _skipLF() {
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private int nextByte() {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        return this._inputBuffer[this._inputPtr++] & 0xFF;
    }

    protected void _reportInvalidChar(int n2) {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2) {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2, int n3) {
        this._inputPtr = n3;
        this._reportInvalidOther(n2);
    }

    public static int[] growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        int[] nArray2 = nArray;
        int n3 = nArray.length;
        nArray = new int[n3 + n2];
        System.arraycopy(nArray2, 0, nArray, 0, n3);
        return nArray;
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) continue;
            int n3 = base64Variant.decodeBase64Char(n2);
            if (n3 < 0) {
                if (n2 == 34) {
                    return byteArrayBuilder.toByteArray();
                }
                n3 = this._decodeBase64Escape(base64Variant, n2, 0);
                if (n3 < 0) continue;
            }
            int n4 = n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                n3 = this._decodeBase64Escape(base64Variant, n2, 1);
            }
            n4 = n4 << 6 | n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n3 != -2) {
                    if (n2 == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n4 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 2);
                }
                if (n3 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) {
                        throw this.reportInvalidBase64Char(base64Variant, n2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n4 >>= 4);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n3 = base64Variant.decodeBase64Char(n2 = this._inputBuffer[this._inputPtr++] & 0xFF)) < 0) {
                if (n3 != -2) {
                    if (n2 == 34 && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n3 = this._decodeBase64Escape(base64Variant, n2, 3);
                }
                if (n3 == -2) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    continue;
                }
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }
}

