/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.KeyDeserializer;

public abstract class StdKeyDeserializer
extends KeyDeserializer {
    protected final Class _keyClass;

    protected StdKeyDeserializer(Class clazz) {
        this._keyClass = clazz;
    }

    public final Object deserializeKey(String string, DeserializationContext deserializationContext) {
        if (string == null) {
            return null;
        }
        try {
            Object object = this._parse(string, deserializationContext);
            if (object != null) {
                return object;
            }
        }
        catch (Exception exception) {
            throw deserializationContext.weirdKeyException(this._keyClass, string, "not a valid representation: " + exception.getMessage());
        }
        if (this._keyClass.isEnum() && deserializationContext.getConfig().isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            return null;
        }
        throw deserializationContext.weirdKeyException(this._keyClass, string, "not a valid representation");
    }

    public Class getKeyClass() {
        return this._keyClass;
    }

    protected abstract Object _parse(String var1, DeserializationContext var2);

    protected int _parseInt(String string) {
        return Integer.parseInt(string);
    }

    protected long _parseLong(String string) {
        return Long.parseLong(string);
    }

    protected double _parseDouble(String string) {
        return NumberInput.parseDouble(string);
    }
}

