/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.AnnotationIntrospector$ReferenceProperty;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder$Value;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.Annotations;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicBeanDescription
extends BeanDescription {
    protected final MapperConfig _config;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final AnnotatedClass _classInfo;
    protected TypeBindings _bindings;
    protected final List _properties;
    protected ObjectIdInfo _objectIdInfo;
    protected AnnotatedMethod _anySetterMethod;
    protected Map _injectables;
    protected Set _ignoredPropertyNames;
    protected AnnotatedMethod _jsonValueMethod;
    protected AnnotatedMember _anyGetter;

    protected BasicBeanDescription(MapperConfig mapperConfig, JavaType javaType, AnnotatedClass annotatedClass, List list) {
        super(javaType);
        this._config = mapperConfig;
        this._annotationIntrospector = mapperConfig == null ? null : mapperConfig.getAnnotationIntrospector();
        this._classInfo = annotatedClass;
        this._properties = list;
    }

    protected BasicBeanDescription(POJOPropertiesCollector pOJOPropertiesCollector) {
        this(pOJOPropertiesCollector.getConfig(), pOJOPropertiesCollector.getType(), pOJOPropertiesCollector.getClassDef(), pOJOPropertiesCollector.getProperties());
        this._objectIdInfo = pOJOPropertiesCollector.getObjectIdInfo();
    }

    public static BasicBeanDescription forDeserialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        BasicBeanDescription basicBeanDescription = new BasicBeanDescription(pOJOPropertiesCollector);
        basicBeanDescription._anySetterMethod = pOJOPropertiesCollector.getAnySetterMethod();
        basicBeanDescription._ignoredPropertyNames = pOJOPropertiesCollector.getIgnoredPropertyNames();
        basicBeanDescription._injectables = pOJOPropertiesCollector.getInjectables();
        basicBeanDescription._jsonValueMethod = pOJOPropertiesCollector.getJsonValueMethod();
        return basicBeanDescription;
    }

    public static BasicBeanDescription forSerialization(POJOPropertiesCollector pOJOPropertiesCollector) {
        BasicBeanDescription basicBeanDescription = new BasicBeanDescription(pOJOPropertiesCollector);
        basicBeanDescription._jsonValueMethod = pOJOPropertiesCollector.getJsonValueMethod();
        basicBeanDescription._anyGetter = pOJOPropertiesCollector.getAnyGetter();
        return basicBeanDescription;
    }

    public static BasicBeanDescription forOtherUse(MapperConfig mapperConfig, JavaType javaType, AnnotatedClass annotatedClass) {
        return new BasicBeanDescription(mapperConfig, javaType, annotatedClass, Collections.emptyList());
    }

    public AnnotatedClass getClassInfo() {
        return this._classInfo;
    }

    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    public List findProperties() {
        return this._properties;
    }

    public AnnotatedMethod findJsonValueMethod() {
        return this._jsonValueMethod;
    }

    public Set getIgnoredPropertyNames() {
        if (this._ignoredPropertyNames == null) {
            return Collections.emptySet();
        }
        return this._ignoredPropertyNames;
    }

    public boolean hasKnownClassAnnotations() {
        return this._classInfo.hasAnnotations();
    }

    public Annotations getClassAnnotations() {
        return this._classInfo.getAnnotations();
    }

    public TypeBindings bindingsForBeanType() {
        if (this._bindings == null) {
            this._bindings = new TypeBindings(this._config.getTypeFactory(), this._type);
        }
        return this._bindings;
    }

    public JavaType resolveType(Type type) {
        if (type == null) {
            return null;
        }
        return this.bindingsForBeanType().resolveType(type);
    }

    public AnnotatedConstructor findDefaultConstructor() {
        return this._classInfo.getDefaultConstructor();
    }

    public AnnotatedMethod findAnySetter() {
        Class clazz;
        if (this._anySetterMethod != null && (clazz = this._anySetterMethod.getRawParameterType(0)) != String.class && clazz != Object.class) {
            throw new IllegalArgumentException("Invalid 'any-setter' annotation on method " + this._anySetterMethod.getName() + "(): first argument not of type String or Object, but " + clazz.getName());
        }
        return this._anySetterMethod;
    }

    public Map findInjectables() {
        return this._injectables;
    }

    public List getConstructors() {
        return this._classInfo.getConstructors();
    }

    public Object instantiateBean(boolean bl) {
        AnnotatedConstructor annotatedConstructor = this._classInfo.getDefaultConstructor();
        if (annotatedConstructor == null) {
            return null;
        }
        if (bl) {
            annotatedConstructor.fixAccess();
        }
        try {
            return annotatedConstructor.getAnnotated().newInstance(new Object[0]);
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalArgumentException("Failed to instantiate bean of type " + this._classInfo.getAnnotated().getName() + ": (" + throwable.getClass().getName() + ") " + throwable.getMessage(), throwable);
        }
    }

    public AnnotatedMethod findMethod(String string, Class[] classArray) {
        return this._classInfo.findMethod(string, classArray);
    }

    public List getFactoryMethods() {
        List list = this._classInfo.getStaticMethods();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<AnnotatedMethod> arrayList = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod annotatedMethod : list) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            arrayList.add(annotatedMethod);
        }
        return arrayList;
    }

    public Constructor findSingleArgConstructor(Class ... classArray) {
        for (AnnotatedConstructor annotatedConstructor : this._classInfo.getConstructors()) {
            if (annotatedConstructor.getParameterCount() != 1) continue;
            Class clazz = annotatedConstructor.getRawParameterType(0);
            for (Class clazz2 : classArray) {
                if (clazz2 != clazz) continue;
                return annotatedConstructor.getAnnotated();
            }
        }
        return null;
    }

    public Method findFactoryMethod(Class ... classArray) {
        for (AnnotatedMethod annotatedMethod : this._classInfo.getStaticMethods()) {
            if (!this.isFactoryMethod(annotatedMethod)) continue;
            Class clazz = annotatedMethod.getRawParameterType(0);
            for (Class clazz2 : classArray) {
                if (!clazz.isAssignableFrom(clazz2)) continue;
                return annotatedMethod.getAnnotated();
            }
        }
        return null;
    }

    protected boolean isFactoryMethod(AnnotatedMethod annotatedMethod) {
        Class clazz = annotatedMethod.getRawReturnType();
        if (!this.getBeanClass().isAssignableFrom(clazz)) {
            return false;
        }
        if (this._annotationIntrospector.hasCreatorAnnotation(annotatedMethod)) {
            return true;
        }
        return "valueOf".equals(annotatedMethod.getName());
    }

    public List findCreatorPropertyNames() {
        ArrayList<String> arrayList = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            List list = i2 == 0 ? this.getConstructors() : this.getFactoryMethods();
            for (AnnotatedWithParams annotatedWithParams : list) {
                String string;
                int n2 = annotatedWithParams.getParameterCount();
                if (n2 < 1 || (string = this._annotationIntrospector.findDeserializationName(annotatedWithParams.getParameter(0))) == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
                for (int i3 = 1; i3 < n2; ++i3) {
                    arrayList.add(this._annotationIntrospector.findDeserializationName(annotatedWithParams.getParameter(i3)));
                }
            }
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return arrayList;
    }

    public JsonInclude$Include findSerializationInclusion(JsonInclude$Include jsonInclude$Include) {
        if (this._annotationIntrospector == null) {
            return jsonInclude$Include;
        }
        return this._annotationIntrospector.findSerializationInclusion(this._classInfo, jsonInclude$Include);
    }

    public AnnotatedMember findAnyGetter() {
        Class clazz;
        if (this._anyGetter != null && !Map.class.isAssignableFrom(clazz = this._anyGetter.getRawType())) {
            throw new IllegalArgumentException("Invalid 'any-getter' annotation on method " + this._anyGetter.getName() + "(): return type is not instance of java.util.Map");
        }
        return this._anyGetter;
    }

    public Map findBackReferenceProperties() {
        HashMap<String, AnnotatedMember> hashMap = null;
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties) {
            String string;
            AnnotationIntrospector$ReferenceProperty annotationIntrospector$ReferenceProperty;
            AnnotatedMember annotatedMember = beanPropertyDefinition.getMutator();
            if (annotatedMember == null || (annotationIntrospector$ReferenceProperty = this._annotationIntrospector.findReferenceType(annotatedMember)) == null || !annotationIntrospector$ReferenceProperty.isBackReference()) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, AnnotatedMember>();
            }
            if (hashMap.put(string = annotationIntrospector$ReferenceProperty.getName(), annotatedMember) == null) continue;
            throw new IllegalArgumentException("Multiple back-reference properties with name '" + string + "'");
        }
        return hashMap;
    }

    public Class findPOJOBuilder() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilder(this._classInfo);
    }

    public JsonPOJOBuilder$Value findPOJOBuilderConfig() {
        return this._annotationIntrospector == null ? null : this._annotationIntrospector.findPOJOBuilderConfig(this._classInfo);
    }

    public LinkedHashMap _findPropertyFields(Collection collection, boolean bl) {
        LinkedHashMap<String, AnnotatedField> linkedHashMap = new LinkedHashMap<String, AnnotatedField>();
        for (BeanPropertyDefinition beanPropertyDefinition : this._properties) {
            AnnotatedField annotatedField = beanPropertyDefinition.getField();
            if (annotatedField == null) continue;
            String string = beanPropertyDefinition.getName();
            if (collection != null && collection.contains(string)) continue;
            linkedHashMap.put(string, annotatedField);
        }
        return linkedHashMap;
    }
}

