/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.util.Collection;
import java.util.Iterator;

public class CollectionSerializer
extends AsArraySerializerBase {
    public CollectionSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer jsonSerializer) {
        super(Collection.class, javaType, bl, typeSerializer, beanProperty, jsonSerializer);
    }

    public CollectionSerializer(CollectionSerializer collectionSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        super(collectionSerializer, beanProperty, typeSerializer, jsonSerializer);
    }

    public ContainerSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new CollectionSerializer(this._elementType, this._staticTyping, typeSerializer, this._property, this._elementSerializer);
    }

    public CollectionSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        return new CollectionSerializer(this, beanProperty, typeSerializer, jsonSerializer);
    }

    public boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public boolean hasSingleElement(Collection collection) {
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        iterator.next();
        return !iterator.hasNext();
    }

    public void serializeContents(Collection collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(collection, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        int n2 = 0;
        try {
            do {
                Object e2;
                if ((e2 = iterator.next()) == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                } else {
                    Class<?> clazz = e2.getClass();
                    JsonSerializer jsonSerializer = propertySerializerMap.serializerFor(clazz);
                    if (jsonSerializer == null) {
                        jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                        propertySerializerMap = this._dynamicSerializers;
                    }
                    if (typeSerializer == null) {
                        jsonSerializer.serialize(e2, jsonGenerator, serializerProvider);
                    } else {
                        jsonSerializer.serializeWithType(e2, jsonGenerator, serializerProvider, typeSerializer);
                    }
                }
                ++n2;
            } while (iterator.hasNext());
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)collection, n2);
        }
    }

    public void serializeContentsUsing(Collection collection, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer jsonSerializer) {
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            TypeSerializer typeSerializer = this._valueTypeSerializer;
            int n2 = 0;
            do {
                Object e2 = iterator.next();
                try {
                    if (e2 == null) {
                        serializerProvider.defaultSerializeNull(jsonGenerator);
                    } else if (typeSerializer == null) {
                        jsonSerializer.serialize(e2, jsonGenerator, serializerProvider);
                    } else {
                        jsonSerializer.serializeWithType(e2, jsonGenerator, serializerProvider, typeSerializer);
                    }
                    ++n2;
                }
                catch (Exception exception) {
                    this.wrapAndThrow(serializerProvider, (Throwable)exception, (Object)collection, n2);
                }
            } while (iterator.hasNext());
        }
    }
}

