/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import java.util.Collection;
import java.util.Map;

public final class SimpleType
extends TypeBase {
    protected final JavaType[] _typeParameters;
    protected final String[] _typeNames;

    protected SimpleType(Class clazz) {
        this(clazz, null, null, null, null);
    }

    protected SimpleType(Class clazz, String[] stringArray, JavaType[] javaTypeArray, Object object, Object object2) {
        super(clazz, 0, object, object2);
        if (stringArray == null || stringArray.length == 0) {
            this._typeNames = null;
            this._typeParameters = null;
        } else {
            this._typeNames = stringArray;
            this._typeParameters = javaTypeArray;
        }
    }

    public static SimpleType constructUnsafe(Class clazz) {
        return new SimpleType(clazz, null, null, null, null);
    }

    protected JavaType _narrow(Class clazz) {
        return new SimpleType(clazz, this._typeNames, this._typeParameters, this._valueHandler, this._typeHandler);
    }

    public JavaType narrowContentsBy(Class clazz) {
        throw new IllegalArgumentException("Internal error: SimpleType.narrowContentsBy() should never be called");
    }

    public JavaType widenContentsBy(Class clazz) {
        throw new IllegalArgumentException("Internal error: SimpleType.widenContentsBy() should never be called");
    }

    public static SimpleType construct(Class clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Can not construct SimpleType for a Map (class: " + clazz.getName() + ")");
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Can not construct SimpleType for a Collection (class: " + clazz.getName() + ")");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Can not construct SimpleType for an array (class: " + clazz.getName() + ")");
        }
        return new SimpleType(clazz);
    }

    public SimpleType withTypeHandler(Object object) {
        return new SimpleType(this._class, this._typeNames, this._typeParameters, this._valueHandler, object);
    }

    public JavaType withContentTypeHandler(Object object) {
        throw new IllegalArgumentException("Simple types have no content types; can not call withContenTypeHandler()");
    }

    public SimpleType withValueHandler(Object object) {
        if (object == this._valueHandler) {
            return this;
        }
        return new SimpleType(this._class, this._typeNames, this._typeParameters, object, this._typeHandler);
    }

    public SimpleType withContentValueHandler(Object object) {
        throw new IllegalArgumentException("Simple types have no content types; can not call withContenValueHandler()");
    }

    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._typeParameters != null && this._typeParameters.length > 0) {
            stringBuilder.append('<');
            boolean bl = true;
            for (JavaType javaType : this._typeParameters) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(javaType.toCanonical());
            }
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    public boolean isContainerType() {
        return false;
    }

    public int containedTypeCount() {
        return this._typeParameters == null ? 0 : this._typeParameters.length;
    }

    public JavaType containedType(int n2) {
        if (n2 < 0 || this._typeParameters == null || n2 >= this._typeParameters.length) {
            return null;
        }
        return this._typeParameters[n2];
    }

    public String containedTypeName(int n2) {
        if (n2 < 0 || this._typeNames == null || n2 >= this._typeNames.length) {
            return null;
        }
        return this._typeNames[n2];
    }

    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return SimpleType._classSignature(this._class, stringBuilder, true);
    }

    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        SimpleType._classSignature(this._class, stringBuilder, false);
        if (this._typeParameters != null) {
            stringBuilder.append('<');
            for (JavaType javaType : this._typeParameters) {
                stringBuilder = javaType.getGenericSignature(stringBuilder);
            }
            stringBuilder.append('>');
        }
        stringBuilder.append(';');
        return stringBuilder;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append("[simple type, class ").append(this.buildCanonicalName()).append(']');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        SimpleType simpleType = (SimpleType)object;
        if (simpleType._class != this._class) {
            return false;
        }
        JavaType[] javaTypeArray = this._typeParameters;
        JavaType[] javaTypeArray2 = simpleType._typeParameters;
        if (javaTypeArray == null) {
            return javaTypeArray2 == null || javaTypeArray2.length == 0;
        }
        if (javaTypeArray2 == null) {
            return false;
        }
        if (javaTypeArray.length != javaTypeArray2.length) {
            return false;
        }
        int n2 = javaTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (javaTypeArray[i2].equals(javaTypeArray2[i2])) continue;
            return false;
        }
        return true;
    }
}

