/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601Utils {
    private static final String GMT_ID = "GMT";
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");

    public static TimeZone timeZoneGMT() {
        return TIMEZONE_GMT;
    }

    public static String format(Date date) {
        return ISO8601Utils.format(date, false, TIMEZONE_GMT);
    }

    public static String format(Date date, boolean bl) {
        return ISO8601Utils.format(date, bl, TIMEZONE_GMT);
    }

    public static String format(Date date, boolean bl, TimeZone timeZone) {
        int n2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, Locale.US);
        gregorianCalendar.setTime(date);
        int n3 = "yyyy-MM-ddThh:mm:ss".length();
        n3 += bl ? ".sss".length() : 0;
        StringBuilder stringBuilder = new StringBuilder(n3 += timeZone.getRawOffset() == 0 ? "Z".length() : "+hh:mm".length());
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(1), "yyyy".length());
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(2) + 1, "MM".length());
        stringBuilder.append('-');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(5), "dd".length());
        stringBuilder.append('T');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(11), "hh".length());
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(12), "mm".length());
        stringBuilder.append(':');
        ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(13), "ss".length());
        if (bl) {
            stringBuilder.append('.');
            ISO8601Utils.padInt(stringBuilder, gregorianCalendar.get(14), "sss".length());
        }
        if ((n2 = timeZone.getOffset(gregorianCalendar.getTimeInMillis())) != 0) {
            int n4 = Math.abs(n2 / 60000 / 60);
            int n5 = Math.abs(n2 / 60000 % 60);
            stringBuilder.append(n2 < 0 ? (char)'-' : '+');
            ISO8601Utils.padInt(stringBuilder, n4, "hh".length());
            stringBuilder.append(':');
            ISO8601Utils.padInt(stringBuilder, n5, "mm".length());
        } else {
            stringBuilder.append('Z');
        }
        return stringBuilder.toString();
    }

    public static Date parse(String string) {
        try {
            String string2;
            char c2;
            int n2 = 0;
            int n3 = ISO8601Utils.parseInt(string, n2, n2 += 4);
            ISO8601Utils.checkOffset(string, n2, '-');
            int n4 = ISO8601Utils.parseInt(string, ++n2, n2 += 2);
            ISO8601Utils.checkOffset(string, n2, '-');
            int n5 = ISO8601Utils.parseInt(string, ++n2, n2 += 2);
            ISO8601Utils.checkOffset(string, n2, 'T');
            int n6 = ISO8601Utils.parseInt(string, ++n2, n2 += 2);
            ISO8601Utils.checkOffset(string, n2, ':');
            int n7 = ISO8601Utils.parseInt(string, ++n2, n2 += 2);
            ISO8601Utils.checkOffset(string, n2, ':');
            int n8 = ISO8601Utils.parseInt(string, ++n2, n2 += 2);
            int n9 = 0;
            if (string.charAt(n2) == '.') {
                ISO8601Utils.checkOffset(string, n2, '.');
                n9 = ISO8601Utils.parseInt(string, ++n2, n2 += 3);
            }
            if ((c2 = string.charAt(n2)) == '+' || c2 == '-') {
                string2 = GMT_ID + string.substring(n2);
            } else if (c2 == 'Z') {
                string2 = GMT_ID;
            } else {
                throw new IndexOutOfBoundsException("Invalid time zone indicator " + c2);
            }
            TimeZone timeZone = TimeZone.getTimeZone(string2);
            if (!timeZone.getID().equals(string2)) {
                throw new IndexOutOfBoundsException();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.setLenient(false);
            gregorianCalendar.set(1, n3);
            gregorianCalendar.set(2, n4 - 1);
            gregorianCalendar.set(5, n5);
            gregorianCalendar.set(11, n6);
            gregorianCalendar.set(12, n7);
            gregorianCalendar.set(13, n8);
            gregorianCalendar.set(14, n9);
            return gregorianCalendar.getTime();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Failed to parse date " + string, indexOutOfBoundsException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to parse date " + string, numberFormatException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Failed to parse date " + string, illegalArgumentException);
        }
    }

    private static void checkOffset(String string, int n2, char c2) {
        char c3 = string.charAt(n2);
        if (c3 != c2) {
            throw new IndexOutOfBoundsException("Expected '" + c2 + "' character but found '" + c3 + "'");
        }
    }

    private static int parseInt(String string, int n2, int n3) {
        int n4;
        if (n2 < 0 || n3 > string.length() || n2 > n3) {
            throw new NumberFormatException(string);
        }
        int n5 = n2;
        int n6 = 0;
        if (n5 < n3) {
            if ((n4 = Character.digit(string.charAt(n5++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string);
            }
            n6 = -n4;
        }
        while (n5 < n3) {
            if ((n4 = Character.digit(string.charAt(n5++), 10)) < 0) {
                throw new NumberFormatException("Invalid number: " + string);
            }
            n6 *= 10;
            n6 -= n4;
        }
        return -n6;
    }

    private static void padInt(StringBuilder stringBuilder, int n2, int n3) {
        String string = Integer.toString(n2);
        for (int i2 = n3 - string.length(); i2 > 0; --i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
    }
}

