/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.util.PrimitiveArrayBuilder$Node;

public abstract class PrimitiveArrayBuilder {
    static final int INITIAL_CHUNK_SIZE = 12;
    static final int SMALL_CHUNK_SIZE = 16384;
    static final int MAX_CHUNK_SIZE = 262144;
    Object _freeBuffer;
    PrimitiveArrayBuilder$Node _bufferHead;
    PrimitiveArrayBuilder$Node _bufferTail;
    int _bufferedEntryCount;

    protected PrimitiveArrayBuilder() {
    }

    public Object resetAndStart() {
        this._reset();
        return this._freeBuffer == null ? this._constructArray(12) : this._freeBuffer;
    }

    public final Object appendCompletedChunk(Object object, int n2) {
        PrimitiveArrayBuilder$Node primitiveArrayBuilder$Node = new PrimitiveArrayBuilder$Node(object, n2);
        if (this._bufferHead == null) {
            this._bufferHead = this._bufferTail = primitiveArrayBuilder$Node;
        } else {
            this._bufferTail.linkNext(primitiveArrayBuilder$Node);
            this._bufferTail = primitiveArrayBuilder$Node;
        }
        this._bufferedEntryCount += n2;
        int n3 = n2;
        n3 = n3 < 16384 ? (n3 += n3) : (n3 += n3 >> 2);
        return this._constructArray(n3);
    }

    public Object completeAndClearBuffer(Object object, int n2) {
        int n3 = n2 + this._bufferedEntryCount;
        Object object2 = this._constructArray(n3);
        int n4 = 0;
        for (PrimitiveArrayBuilder$Node primitiveArrayBuilder$Node = this._bufferHead; primitiveArrayBuilder$Node != null; primitiveArrayBuilder$Node = primitiveArrayBuilder$Node.next()) {
            n4 = primitiveArrayBuilder$Node.copyData(object2, n4);
        }
        System.arraycopy(object, 0, object2, n4, n2);
        if ((n4 += n2) != n3) {
            throw new IllegalStateException("Should have gotten " + n3 + " entries, got " + n4);
        }
        return object2;
    }

    protected abstract Object _constructArray(int var1);

    protected void _reset() {
        if (this._bufferTail != null) {
            this._freeBuffer = this._bufferTail.getData();
        }
        this._bufferTail = null;
        this._bufferHead = null;
        this._bufferedEntryCount = 0;
    }
}

