/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jaxb;

import com.fasterxml.jackson.annotation.JsonAutoDetect$Visibility;
import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.annotation.ObjectIdGenerators$PropertyGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.jaxb.ModuleVersion;
import com.fasterxml.jackson.module.jaxb.deser.XmlAdapterJsonDeserializer;
import com.fasterxml.jackson.module.jaxb.ser.XmlAdapterJsonSerializer;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;

public class JaxbAnnotationIntrospector
extends AnnotationIntrospector
implements Versioned {
    protected static final String MARKER_FOR_DEFAULT = "##default";
    protected final String _jaxbPackageName;
    protected final JsonSerializer _dataHandlerSerializer;
    protected final JsonDeserializer _dataHandlerDeserializer;
    protected final TypeFactory _typeFactory;

    public JaxbAnnotationIntrospector() {
        this(TypeFactory.defaultInstance());
    }

    public JaxbAnnotationIntrospector(MapperConfig mapperConfig) {
        this(mapperConfig.getTypeFactory());
    }

    public JaxbAnnotationIntrospector(TypeFactory typeFactory) {
        this._typeFactory = typeFactory == null ? TypeFactory.defaultInstance() : typeFactory;
        this._jaxbPackageName = XmlElement.class.getPackage().getName();
        JsonSerializer jsonSerializer = null;
        JsonDeserializer jsonDeserializer = null;
        try {
            jsonSerializer = (JsonSerializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonSerializer").newInstance();
            jsonDeserializer = (JsonDeserializer)Class.forName("org.codehaus.jackson.xc.DataHandlerJsonDeserializer").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._dataHandlerSerializer = jsonSerializer;
        this._dataHandlerDeserializer = jsonDeserializer;
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public boolean isHandled(Annotation annotation) {
        String string;
        Class<? extends Annotation> clazz = annotation.annotationType();
        Package package_ = clazz.getPackage();
        String string2 = string = package_ != null ? package_.getName() : clazz.getName();
        return string.startsWith(this._jaxbPackageName);
    }

    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        XmlID xmlID;
        if (!(annotated instanceof AnnotatedClass)) {
            return null;
        }
        AnnotatedClass annotatedClass = (AnnotatedClass)annotated;
        String string = null;
        block4: for (AnnotatedMember annotatedMember : annotatedClass.memberMethods()) {
            xmlID = (XmlID)((AnnotatedWithParams)annotatedMember).getAnnotation(XmlID.class);
            if (xmlID == null) continue;
            switch (((AnnotatedMethod)annotatedMember).getParameterCount()) {
                case 0: {
                    string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMember, ((AnnotatedMethod)annotatedMember).getRawType(), BeanUtil.okNameForGetter((AnnotatedMethod)annotatedMember));
                    break block4;
                }
                case 1: {
                    string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMember, ((AnnotatedMethod)annotatedMember).getRawType(), BeanUtil.okNameForSetter((AnnotatedMethod)annotatedMember));
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (string == null) {
            for (AnnotatedMember annotatedMember : annotatedClass.fields()) {
                xmlID = (XmlID)((AnnotatedField)annotatedMember).getAnnotation(XmlID.class);
                if (xmlID == null) continue;
                string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMember, ((AnnotatedField)annotatedMember).getRawType(), ((AnnotatedField)annotatedMember).getName());
                break;
            }
        }
        if (string != null) {
            Class<Object> clazz = Object.class;
            return new ObjectIdInfo(string, clazz, ObjectIdGenerators$PropertyGenerator.class);
        }
        return null;
    }

    public String findRootName(AnnotatedClass annotatedClass) {
        XmlRootElement xmlRootElement = this.findRootElementAnnotation(annotatedClass);
        if (xmlRootElement != null) {
            String string = xmlRootElement.name();
            return MARKER_FOR_DEFAULT.equals(string) ? "" : string;
        }
        return null;
    }

    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        return null;
    }

    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        return null;
    }

    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return annotatedMember.getAnnotation(XmlTransient.class) != null;
    }

    public VisibilityChecker findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker visibilityChecker) {
        XmlAccessType xmlAccessType = this.findAccessType(annotatedClass);
        if (xmlAccessType == null) {
            return visibilityChecker;
        }
        switch (xmlAccessType) {
            case FIELD: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.ANY).withSetterVisibility(JsonAutoDetect$Visibility.NONE).withGetterVisibility(JsonAutoDetect$Visibility.NONE).withIsGetterVisibility(JsonAutoDetect$Visibility.NONE);
            }
            case NONE: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.NONE).withSetterVisibility(JsonAutoDetect$Visibility.NONE).withGetterVisibility(JsonAutoDetect$Visibility.NONE).withIsGetterVisibility(JsonAutoDetect$Visibility.NONE);
            }
            case PROPERTY: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.NONE).withSetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY);
            }
            case PUBLIC_MEMBER: {
                return visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect$Visibility.PUBLIC_ONLY);
            }
        }
        return visibilityChecker;
    }

    protected XmlAccessType findAccessType(Annotated annotated) {
        XmlAccessorType xmlAccessorType = (XmlAccessorType)this.findAnnotation(XmlAccessorType.class, annotated, true, true, true);
        return xmlAccessorType == null ? null : xmlAccessorType.value();
    }

    public TypeResolverBuilder findTypeResolver(MapperConfig mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return null;
    }

    public TypeResolverBuilder findPropertyTypeResolver(MapperConfig mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.isContainerType()) {
            return null;
        }
        return this._typeResolverFromXmlElements(annotatedMember);
    }

    public TypeResolverBuilder findPropertyContentTypeResolver(MapperConfig mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (!javaType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + javaType + ")");
        }
        return this._typeResolverFromXmlElements(annotatedMember);
    }

    protected TypeResolverBuilder _typeResolverFromXmlElements(AnnotatedMember annotatedMember) {
        XmlElements xmlElements = (XmlElements)this.findAnnotation(XmlElements.class, annotatedMember, false, false, false);
        XmlElementRefs xmlElementRefs = (XmlElementRefs)this.findAnnotation(XmlElementRefs.class, annotatedMember, false, false, false);
        if (xmlElements == null && xmlElementRefs == null) {
            return null;
        }
        TypeResolverBuilder typeResolverBuilder = new StdTypeResolverBuilder();
        typeResolverBuilder = typeResolverBuilder.init(JsonTypeInfo$Id.NAME, null);
        typeResolverBuilder = typeResolverBuilder.inclusion(JsonTypeInfo$As.WRAPPER_OBJECT);
        return typeResolverBuilder;
    }

    public List findSubtypes(Annotated annotated) {
        XmlElements xmlElements = (XmlElements)this.findAnnotation(XmlElements.class, annotated, false, false, false);
        if (xmlElements != null) {
            ArrayList<NamedType> arrayList = new ArrayList<NamedType>();
            for (XmlElement xmlElement : xmlElements.value()) {
                String string = xmlElement.name();
                if (MARKER_FOR_DEFAULT.equals(string)) {
                    string = null;
                }
                arrayList.add(new NamedType(xmlElement.type(), string));
            }
            return arrayList;
        }
        XmlElementRefs xmlElementRefs = (XmlElementRefs)this.findAnnotation(XmlElementRefs.class, annotated, false, false, false);
        if (xmlElementRefs != null) {
            ArrayList<NamedType> arrayList = new ArrayList<NamedType>();
            for (XmlElementRef xmlElementRef : xmlElementRefs.value()) {
                XmlRootElement xmlRootElement;
                Class clazz = xmlElementRef.type();
                if (JAXBElement.class.isAssignableFrom(clazz)) continue;
                String string = xmlElementRef.name();
                if ((string == null || MARKER_FOR_DEFAULT.equals(string)) && (xmlRootElement = clazz.getAnnotation(XmlRootElement.class)) != null) {
                    string = xmlRootElement.name();
                }
                if (string == null || MARKER_FOR_DEFAULT.equals(string)) {
                    string = Introspector.decapitalize(clazz.getSimpleName());
                }
                arrayList.add(new NamedType(clazz, string));
            }
            return arrayList;
        }
        return null;
    }

    public String findTypeName(AnnotatedClass annotatedClass) {
        String string;
        XmlType xmlType = (XmlType)this.findAnnotation(XmlType.class, annotatedClass, false, false, false);
        if (xmlType != null && !MARKER_FOR_DEFAULT.equals(string = xmlType.name())) {
            return string;
        }
        return null;
    }

    public JsonSerializer findSerializer(Annotated annotated) {
        Class clazz = annotated.getRawType();
        XmlAdapter xmlAdapter = this.findAdapter(annotated, true, clazz);
        if (xmlAdapter != null) {
            if (this.isContainerType(clazz)) {
                if (this.adapterTypeMatches(xmlAdapter, clazz)) {
                    return new XmlAdapterJsonSerializer(xmlAdapter);
                }
            } else {
                return new XmlAdapterJsonSerializer(xmlAdapter);
            }
        }
        if (clazz != null && this._dataHandlerSerializer != null && this.isDataHandler(clazz)) {
            return this._dataHandlerSerializer;
        }
        return null;
    }

    private boolean isDataHandler(Class clazz) {
        return clazz != null && Object.class != clazz && ("javax.activation.DataHandler".equals(clazz.getName()) || this.isDataHandler(clazz.getSuperclass()));
    }

    public Object findContentSerializer(Annotated annotated) {
        XmlAdapter xmlAdapter = this._findContentAdapter(annotated);
        return xmlAdapter == null ? null : new XmlAdapterJsonSerializer(xmlAdapter);
    }

    public Class findSerializationType(Annotated annotated) {
        XmlElement xmlElement = (XmlElement)this.findAnnotation(XmlElement.class, annotated, false, false, false);
        if (xmlElement == null || xmlElement.type() == XmlElement.DEFAULT.class) {
            return null;
        }
        Class clazz = annotated.getRawType();
        if (this.isContainerType(clazz)) {
            return null;
        }
        Class clazz2 = xmlElement.type();
        if (annotated.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return null;
        }
        return clazz2;
    }

    public JsonInclude$Include findSerializationInclusion(Annotated annotated, JsonInclude$Include jsonInclude$Include) {
        XmlElementWrapper xmlElementWrapper = (XmlElementWrapper)annotated.getAnnotation(XmlElementWrapper.class);
        if (xmlElementWrapper != null) {
            return xmlElementWrapper.nillable() ? JsonInclude$Include.ALWAYS : JsonInclude$Include.NON_NULL;
        }
        XmlElement xmlElement = (XmlElement)annotated.getAnnotation(XmlElement.class);
        if (xmlElement != null) {
            return xmlElement.nillable() ? JsonInclude$Include.ALWAYS : JsonInclude$Include.NON_NULL;
        }
        return jsonInclude$Include;
    }

    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        XmlType xmlType = (XmlType)this.findAnnotation(XmlType.class, annotatedClass, true, true, true);
        if (xmlType == null) {
            return null;
        }
        String[] stringArray = xmlType.propOrder();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    public Boolean findSerializationSortAlphabetically(AnnotatedClass annotatedClass) {
        XmlAccessorOrder xmlAccessorOrder = (XmlAccessorOrder)this.findAnnotation(XmlAccessorOrder.class, annotatedClass, true, true, true);
        return xmlAccessorOrder == null ? null : Boolean.valueOf(xmlAccessorOrder.value() == XmlAccessOrder.ALPHABETICAL);
    }

    public String findSerializationName(AnnotatedMethod annotatedMethod) {
        if (!this.isVisible(annotatedMethod)) {
            return null;
        }
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, annotatedMethod.getRawType(), BeanUtil.okNameForGetter(annotatedMethod));
        if (string == null) {
            // empty if block
        }
        return string;
    }

    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    public String findEnumValue(Enum enum_) {
        Class clazz = enum_.getDeclaringClass();
        String string = enum_.name();
        try {
            XmlEnumValue xmlEnumValue = clazz.getDeclaredField(string).getAnnotation(XmlEnumValue.class);
            return xmlEnumValue != null ? xmlEnumValue.value() : string;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException("Could not locate Enum entry '" + string + "' (Enum class " + clazz.getName() + ")", noSuchFieldException);
        }
    }

    public String findSerializationName(AnnotatedField annotatedField) {
        if (!this.isVisible(annotatedField)) {
            return null;
        }
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
        return string == null ? annotatedField.getName() : string;
    }

    public Object findDeserializer(Annotated annotated) {
        Class clazz = annotated.getRawType();
        XmlAdapter xmlAdapter = this.findAdapter(annotated, true, clazz);
        if (xmlAdapter != null) {
            if (this.isContainerType(clazz)) {
                if (this.adapterTypeMatches(xmlAdapter, clazz)) {
                    return new XmlAdapterJsonDeserializer(xmlAdapter);
                }
            } else {
                return new XmlAdapterJsonDeserializer(xmlAdapter);
            }
        }
        if (clazz != null && this._dataHandlerDeserializer != null && this.isDataHandler(clazz)) {
            return this._dataHandlerDeserializer;
        }
        return null;
    }

    public Object findKeyDeserializer(Annotated annotated) {
        return null;
    }

    public Object findContentDeserializer(Annotated annotated) {
        XmlAdapter xmlAdapter = this._findContentAdapter(annotated);
        return xmlAdapter == null ? null : new XmlAdapterJsonDeserializer(xmlAdapter);
    }

    public Class findDeserializationType(Annotated annotated, JavaType javaType) {
        if (!javaType.isContainerType()) {
            return this._doFindDeserializationType(annotated, javaType);
        }
        return null;
    }

    public Class findDeserializationContentType(Annotated annotated, JavaType javaType) {
        return this._doFindDeserializationType(annotated, javaType);
    }

    protected Class _doFindDeserializationType(Annotated annotated, JavaType javaType) {
        Class clazz;
        if (annotated.hasAnnotation(XmlJavaTypeAdapter.class)) {
            return null;
        }
        XmlElement xmlElement = (XmlElement)this.findAnnotation(XmlElement.class, annotated, false, false, false);
        if (xmlElement != null && (clazz = xmlElement.type()) != XmlElement.DEFAULT.class) {
            return clazz;
        }
        return null;
    }

    public String findDeserializationName(AnnotatedMethod annotatedMethod) {
        if (!this.isVisible(annotatedMethod)) {
            return null;
        }
        Class clazz = annotatedMethod.getRawParameterType(0);
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedMethod, clazz, BeanUtil.okNameForSetter(annotatedMethod));
        return string;
    }

    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return false;
    }

    public boolean hasCreatorAnnotation(Annotated annotated) {
        return false;
    }

    public String findDeserializationName(AnnotatedField annotatedField) {
        if (!this.isVisible(annotatedField)) {
            return null;
        }
        String string = JaxbAnnotationIntrospector.findJaxbPropertyName(annotatedField, annotatedField.getRawType(), null);
        return string == null ? annotatedField.getName() : string;
    }

    public String findDeserializationName(AnnotatedParameter annotatedParameter) {
        return null;
    }

    private boolean isVisible(AnnotatedField annotatedField) {
        for (XmlAccessType xmlAccessType : annotatedField.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled((Annotation)xmlAccessType)) continue;
            return true;
        }
        XmlAccessType xmlAccessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType xmlAccessorType = (XmlAccessorType)this.findAnnotation(XmlAccessorType.class, annotatedField, true, true, true);
        if (xmlAccessorType != null) {
            xmlAccessType = xmlAccessorType.value();
        }
        if (xmlAccessType == XmlAccessType.FIELD) {
            return true;
        }
        if (xmlAccessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(annotatedField.getAnnotated().getModifiers());
        }
        return false;
    }

    private boolean isVisible(AnnotatedMethod annotatedMethod) {
        for (XmlAccessType xmlAccessType : annotatedMethod.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isHandled((Annotation)xmlAccessType)) continue;
            return true;
        }
        XmlAccessType xmlAccessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType xmlAccessorType = (XmlAccessorType)this.findAnnotation(XmlAccessorType.class, annotatedMethod, true, true, true);
        if (xmlAccessorType != null) {
            xmlAccessType = xmlAccessorType.value();
        }
        if (xmlAccessType == XmlAccessType.PROPERTY || xmlAccessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(annotatedMethod.getModifiers());
        }
        return false;
    }

    private Annotation findAnnotation(Class clazz, Annotated annotated, boolean bl, boolean bl2, boolean bl3) {
        AnnotatedElement annotatedElement;
        Annotation annotation = annotated.getAnnotation(clazz);
        if (annotation != null) {
            return annotation;
        }
        Class clazz2 = null;
        if (annotated instanceof AnnotatedParameter) {
            clazz2 = ((AnnotatedParameter)annotated).getDeclaringClass();
        } else {
            annotatedElement = annotated.getAnnotated();
            if (annotatedElement instanceof Member) {
                clazz2 = ((Member)((Object)annotatedElement)).getDeclaringClass();
                if (bl2 && (annotation = clazz2.getAnnotation(clazz)) != null) {
                    return annotation;
                }
            } else if (annotatedElement instanceof Class) {
                clazz2 = (Class)annotatedElement;
            } else {
                throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
            }
        }
        if (clazz2 != null) {
            if (bl3) {
                for (annotatedElement = clazz2.getSuperclass(); annotatedElement != null && annotatedElement != Object.class; annotatedElement = ((Class)annotatedElement).getSuperclass()) {
                    annotation = ((Class)annotatedElement).getAnnotation(clazz);
                    if (annotation == null) continue;
                    return annotation;
                }
            }
            if (bl && (annotatedElement = clazz2.getPackage()) != null) {
                return clazz2.getPackage().getAnnotation(clazz);
            }
        }
        return null;
    }

    private static String findJaxbPropertyName(Annotated annotated, Class clazz, String string) {
        String string2;
        XmlAttribute xmlAttribute = (XmlAttribute)annotated.getAnnotation(XmlAttribute.class);
        if (xmlAttribute != null) {
            String string3 = xmlAttribute.name();
            if (!MARKER_FOR_DEFAULT.equals(string3)) {
                return string3;
            }
            return string;
        }
        XmlElement xmlElement = (XmlElement)annotated.getAnnotation(XmlElement.class);
        if (xmlElement != null) {
            String string4 = xmlElement.name();
            if (!MARKER_FOR_DEFAULT.equals(string4)) {
                return string4;
            }
            return string;
        }
        XmlElementWrapper xmlElementWrapper = (XmlElementWrapper)annotated.getAnnotation(XmlElementWrapper.class);
        if (xmlElementWrapper != null) {
            String string5 = xmlElementWrapper.name();
            if (!MARKER_FOR_DEFAULT.equals(string5)) {
                return string5;
            }
            return string;
        }
        XmlElementRef xmlElementRef = (XmlElementRef)annotated.getAnnotation(XmlElementRef.class);
        if (xmlElementRef != null) {
            XmlRootElement xmlRootElement;
            string2 = xmlElementRef.name();
            if (!MARKER_FOR_DEFAULT.equals(string2)) {
                return string2;
            }
            if (clazz != null && (xmlRootElement = clazz.getAnnotation(XmlRootElement.class)) != null) {
                string2 = xmlRootElement.name();
                if (!MARKER_FOR_DEFAULT.equals(string2)) {
                    return string2;
                }
                return Introspector.decapitalize(clazz.getSimpleName());
            }
        }
        if ((string2 = (XmlValue)annotated.getAnnotation(XmlValue.class)) != null) {
            return "value";
        }
        return null;
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass annotatedClass) {
        return (XmlRootElement)this.findAnnotation(XmlRootElement.class, annotatedClass, true, false, true);
    }

    private XmlAdapter findAdapter(Annotated annotated, boolean bl, Class clazz) {
        XmlJavaTypeAdapter[] xmlJavaTypeAdapterArray;
        XmlJavaTypeAdapter xmlJavaTypeAdapter;
        XmlJavaTypeAdapter xmlJavaTypeAdapter2;
        if (annotated instanceof AnnotatedClass) {
            return this.findAdapterForClass((AnnotatedClass)annotated, bl);
        }
        Member member = (Member)((Object)annotated.getAnnotated());
        if (member != null && (xmlJavaTypeAdapter2 = member.getDeclaringClass()) != null && (xmlJavaTypeAdapter = xmlJavaTypeAdapter2.getAnnotation(XmlJavaTypeAdapter.class)) != null && (xmlJavaTypeAdapterArray = this.checkAdapter(xmlJavaTypeAdapter, clazz)) != null) {
            return xmlJavaTypeAdapterArray;
        }
        xmlJavaTypeAdapter2 = (XmlJavaTypeAdapter)this.findAnnotation(XmlJavaTypeAdapter.class, annotated, true, false, false);
        if (xmlJavaTypeAdapter2 != null && (xmlJavaTypeAdapter = this.checkAdapter(xmlJavaTypeAdapter2, clazz)) != null) {
            return xmlJavaTypeAdapter;
        }
        xmlJavaTypeAdapter = (XmlJavaTypeAdapters)this.findAnnotation(XmlJavaTypeAdapters.class, annotated, true, false, false);
        if (xmlJavaTypeAdapter != null) {
            for (XmlJavaTypeAdapter xmlJavaTypeAdapter3 : xmlJavaTypeAdapter.value()) {
                XmlAdapter xmlAdapter = this.checkAdapter(xmlJavaTypeAdapter3, clazz);
                if (xmlAdapter == null) continue;
                return xmlAdapter;
            }
        }
        return null;
    }

    private final XmlAdapter checkAdapter(XmlJavaTypeAdapter xmlJavaTypeAdapter, Class clazz) {
        Class clazz2 = xmlJavaTypeAdapter.type();
        if (clazz2 == XmlJavaTypeAdapter.DEFAULT.class || clazz2.isAssignableFrom(clazz)) {
            Class clazz3 = xmlJavaTypeAdapter.value();
            return (XmlAdapter)ClassUtil.createInstance(clazz3, false);
        }
        return null;
    }

    private XmlAdapter findAdapterForClass(AnnotatedClass annotatedClass, boolean bl) {
        XmlJavaTypeAdapter xmlJavaTypeAdapter = annotatedClass.getAnnotated().getAnnotation(XmlJavaTypeAdapter.class);
        if (xmlJavaTypeAdapter != null) {
            Class clazz = xmlJavaTypeAdapter.value();
            return (XmlAdapter)ClassUtil.createInstance(clazz, false);
        }
        return null;
    }

    private final TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    private boolean isContainerType(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private boolean adapterTypeMatches(XmlAdapter xmlAdapter, Class clazz) {
        return this.findAdapterBoundType(xmlAdapter).isAssignableFrom(clazz);
    }

    private Class findAdapterBoundType(XmlAdapter xmlAdapter) {
        JavaType javaType;
        TypeFactory typeFactory = this.getTypeFactory();
        JavaType[] javaTypeArray = typeFactory.findTypeParameters(javaType = typeFactory.constructType(xmlAdapter.getClass()), XmlAdapter.class);
        if (javaTypeArray == null || javaTypeArray.length < 2) {
            return Object.class;
        }
        return javaTypeArray[1].getRawClass();
    }

    protected XmlAdapter _findContentAdapter(Annotated annotated) {
        Class clazz = annotated.getRawType();
        if (this.isContainerType(clazz) && annotated instanceof AnnotatedMember) {
            AnnotatedMember annotatedMember = (AnnotatedMember)annotated;
            JavaType javaType = this.getTypeFactory().constructType(annotatedMember.getGenericType(), annotatedMember.getDeclaringClass());
            Class clazz2 = javaType.getContentType().getRawClass();
            XmlAdapter xmlAdapter = this.findAdapter(annotatedMember, true, clazz);
            if (xmlAdapter != null && this.adapterTypeMatches(xmlAdapter, clazz2)) {
                return xmlAdapter;
            }
        }
        return null;
    }

    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        XmlElement xmlElement = (XmlElement)annotatedMember.getAnnotation(XmlElement.class);
        return xmlElement == null ? null : Boolean.valueOf(xmlElement.required());
    }
}

