/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.mob.ai;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.level.Level;
import com.mojang.minecraft.mob.Mob;
import com.mojang.minecraft.mob.ai.AI;
import java.util.List;
import java.util.Random;

public class BasicAI
extends AI {
    public static final long serialVersionUID = 0L;
    public Random random = new Random();
    public float xxa;
    public float yya;
    protected float yRotA;
    public Level level;
    public Mob mob;
    public boolean jumping = false;
    protected int attackDelay = 0;
    public float runSpeed = 0.7f;
    protected int noActionTime = 0;
    public Entity attackTarget = null;

    public void tick(Level level, Mob mob) {
        Entity entity;
        ++this.noActionTime;
        if (this.noActionTime > 600 && this.random.nextInt(800) == 0 && (entity = level.getPlayer()) != null) {
            float f2;
            float f3 = entity.x - mob.x;
            float f4 = entity.y - mob.y;
            float f5 = entity.z - mob.z;
            f3 = f3 * f3 + f4 * f4 + f5 * f5;
            if (f2 < 1024.0f) {
                this.noActionTime = 0;
            } else {
                mob.remove();
            }
        }
        this.level = level;
        this.mob = mob;
        if (this.attackDelay > 0) {
            --this.attackDelay;
        }
        if (mob.health <= 0) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.yya = 0.0f;
            this.yRotA = 0.0f;
        } else {
            this.update();
        }
        int n2 = mob.isInWater();
        boolean bl = mob.isInLava();
        if (this.jumping) {
            if (n2 != 0) {
                mob.yd += 0.04f;
            } else if (bl) {
                mob.yd += 0.04f;
            } else if (mob.onGround) {
                this.jumpFromGround();
            }
        }
        this.xxa *= 0.98f;
        this.yya *= 0.98f;
        this.yRotA *= 0.9f;
        mob.travel(this.xxa, this.yya);
        List list = level.findEntities(mob, mob.bb.grow(0.2f, 0.0f, 0.2f));
        if (list != null && list.size() > 0) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                Entity entity2 = (Entity)list.get(n2);
                if (!entity2.isPushable()) continue;
                entity2.push(mob);
            }
        }
    }

    protected void jumpFromGround() {
        this.mob.yd = 0.42f;
    }

    protected void update() {
        if (this.random.nextFloat() < 0.07f) {
            this.xxa = (this.random.nextFloat() - 0.5f) * this.runSpeed;
            this.yya = this.random.nextFloat() * this.runSpeed;
        }
        boolean bl = this.jumping = this.random.nextFloat() < 0.01f;
        if (this.random.nextFloat() < 0.04f) {
            this.yRotA = (this.random.nextFloat() - 0.5f) * 60.0f;
        }
        this.mob.yRot += this.yRotA;
        this.mob.xRot = this.defaultLookAngle;
        if (this.attackTarget != null) {
            this.yya = this.runSpeed;
            this.jumping = this.random.nextFloat() < 0.04f;
        }
        boolean bl2 = this.mob.isInWater();
        boolean bl3 = this.mob.isInLava();
        if (bl2 || bl3) {
            this.jumping = this.random.nextFloat() < 0.8f;
        }
    }

    public void beforeRemove() {
    }

    public void hurt(Entity entity, int n2) {
        super.hurt(entity, n2);
        this.noActionTime = 0;
    }
}

