/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.mob.ai;

import com.mojang.minecraft.Entity;
import com.mojang.minecraft.d.b;
import com.mojang.minecraft.item.Arrow;
import com.mojang.minecraft.mob.ai.BasicAI;

public class BasicAttackAI
extends BasicAI {
    public static final long serialVersionUID = 0L;
    public int damage = 6;

    protected void update() {
        super.update();
        if (this.mob.health > 0) {
            this.doAttack();
        }
    }

    protected void doAttack() {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        Entity entity = this.level.getPlayer();
        float f7 = 16.0f;
        if (this.attackTarget != null && this.attackTarget.removed) {
            this.attackTarget = null;
        }
        if (entity != null && this.attackTarget == null) {
            float f8;
            f6 = entity.x - this.mob.x;
            f5 = entity.y - this.mob.y;
            f4 = entity.z - this.mob.z;
            f3 = f6 * f6 + f5 * f5 + f4 * f4;
            if (f8 < f7 * f7) {
                this.attackTarget = entity;
            }
        }
        if (this.attackTarget == null) {
            return;
        }
        f6 = this.attackTarget.x - this.mob.x;
        f5 = this.attackTarget.y - this.mob.y;
        f4 = this.attackTarget.z - this.mob.z;
        f3 = f6 * f6 + f5 * f5 + f4 * f4;
        if (f2 > f7 * f7 * 2.0f * 2.0f && this.random.nextInt(100) == 0) {
            this.attackTarget = null;
        }
        if (this.attackTarget != null) {
            float f9;
            f3 = (float)Math.sqrt(f3);
            this.mob.yRot = (float)(Math.atan2(f4, f6) * 180.0 / Math.PI) - 90.0f;
            this.mob.xRot = -((float)(Math.atan2(f5, f3) * 180.0 / Math.PI));
            f3 = (float)Math.sqrt(f6 * f6 + f5 * f5 + f4 * f4);
            if (f9 < 2.0f && this.attackDelay == 0) {
                this.attack(this.attackTarget);
            }
        }
    }

    public boolean attack(Entity entity) {
        if (this.level.clip(new b(this.mob.x, this.mob.y, this.mob.z), new b(entity.x, entity.y, entity.z)) != null) {
            return false;
        }
        this.mob.attackTime = 5;
        this.attackDelay = this.random.nextInt(20) + 10;
        int n2 = (int)((this.random.nextFloat() + this.random.nextFloat()) / 2.0f * (float)this.damage + 1.0f);
        entity.hurt(this.mob, n2);
        this.noActionTime = 0;
        return true;
    }

    public void hurt(Entity entity, int n2) {
        super.hurt(entity, n2);
        if (entity instanceof Arrow) {
            entity = ((Arrow)entity).getOwner();
        }
        if (entity != null && !entity.getClass().equals(this.mob.getClass())) {
            this.attackTarget = entity;
        }
    }
}

