/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.phys;

import com.mojang.minecraft.a.c;
import com.mojang.minecraft.g;
import java.io.Serializable;

public class AABB
implements Serializable {
    public static final long serialVersionUID = 0L;
    private float epsilon = 0.0f;
    public float x0;
    public float y0;
    public float z0;
    public float x1;
    public float y1;
    public float z1;

    public AABB(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.x0 = f2;
        this.y0 = f3;
        this.z0 = f4;
        this.x1 = f5;
        this.y1 = f6;
        this.z1 = f7;
    }

    public AABB expand(float f2, float f3, float f4) {
        float f5 = this.x0;
        float f6 = this.y0;
        float f7 = this.z0;
        float f8 = this.x1;
        float f9 = this.y1;
        float f10 = this.z1;
        if (f2 < 0.0f) {
            f5 += f2;
        }
        if (f2 > 0.0f) {
            f8 += f2;
        }
        if (f3 < 0.0f) {
            f6 += f3;
        }
        if (f3 > 0.0f) {
            f9 += f3;
        }
        if (f4 < 0.0f) {
            f7 += f4;
        }
        if (f4 > 0.0f) {
            f10 += f4;
        }
        return new AABB(f5, f6, f7, f8, f9, f10);
    }

    public AABB grow(float f2, float f3, float f4) {
        float f5 = this.x0 - f2;
        float f6 = this.y0 - f3;
        float f7 = this.z0 - f4;
        f2 = this.x1 + f2;
        f3 = this.y1 + f3;
        float f8 = this.z1 + f4;
        return new AABB(f5, f6, f7, f2, f3, f8);
    }

    public AABB cloneMove(float f2, float f3, float f4) {
        return new AABB(this.x0 + f4, this.y0 + f3, this.z0 + f4, this.x1 + f2, this.y1 + f3, this.z1 + f4);
    }

    public float clipXCollide(AABB aABB, float f2) {
        float f3;
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return f2;
        }
        if (aABB.z1 <= this.z0 || aABB.z0 >= this.z1) {
            return f2;
        }
        if (f2 > 0.0f && aABB.x1 <= this.x0) {
            float f4;
            f3 = this.x0 - aABB.x1 - this.epsilon;
            if (f4 < f2) {
                f2 = f3;
            }
        }
        if (f2 < 0.0f && aABB.x0 >= this.x1) {
            float f5;
            f3 = this.x1 - aABB.x0 + this.epsilon;
            if (f5 > f2) {
                f2 = f3;
            }
        }
        return f2;
    }

    public float clipYCollide(AABB aABB, float f2) {
        float f3;
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return f2;
        }
        if (aABB.z1 <= this.z0 || aABB.z0 >= this.z1) {
            return f2;
        }
        if (f2 > 0.0f && aABB.y1 <= this.y0) {
            float f4;
            f3 = this.y0 - aABB.y1 - this.epsilon;
            if (f4 < f2) {
                f2 = f3;
            }
        }
        if (f2 < 0.0f && aABB.y0 >= this.y1) {
            float f5;
            f3 = this.y1 - aABB.y0 + this.epsilon;
            if (f5 > f2) {
                f2 = f3;
            }
        }
        return f2;
    }

    public float clipZCollide(AABB aABB, float f2) {
        float f3;
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return f2;
        }
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return f2;
        }
        if (f2 > 0.0f && aABB.z1 <= this.z0) {
            float f4;
            f3 = this.z0 - aABB.z1 - this.epsilon;
            if (f4 < f2) {
                f2 = f3;
            }
        }
        if (f2 < 0.0f && aABB.z0 >= this.z1) {
            float f5;
            f3 = this.z1 - aABB.z0 + this.epsilon;
            if (f5 > f2) {
                f2 = f3;
            }
        }
        return f2;
    }

    public boolean intersects(AABB aABB) {
        if (aABB.x1 <= this.x0 || aABB.x0 >= this.x1) {
            return false;
        }
        if (aABB.y1 <= this.y0 || aABB.y0 >= this.y1) {
            return false;
        }
        return !(aABB.z1 <= this.z0) && !(aABB.z0 >= this.z1);
    }

    public boolean intersectsInner(AABB aABB) {
        if (aABB.x1 < this.x0 || aABB.x0 > this.x1) {
            return false;
        }
        if (aABB.y1 < this.y0 || aABB.y0 > this.y1) {
            return false;
        }
        return !(aABB.z1 < this.z0) && !(aABB.z0 > this.z1);
    }

    public void move(float f2, float f3, float f4) {
        this.x0 += f2;
        this.y0 += f3;
        this.z0 += f4;
        this.x1 += f2;
        this.y1 += f3;
        this.z1 += f4;
    }

    public boolean intersects(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (f5 <= this.x0 || f2 >= this.x1) {
            return false;
        }
        if (f6 <= this.y0 || f3 >= this.y1) {
            return false;
        }
        return !(f7 <= this.z0) && !(f4 >= this.z1);
    }

    public boolean contains(c c2) {
        if (c2.a <= this.x0 || c2.a >= this.x1) {
            return false;
        }
        if (c2.b <= this.y0 || c2.b >= this.y1) {
            return false;
        }
        return !(c2.c <= this.z0) && !(c2.c >= this.z1);
    }

    public float getSize() {
        float f2 = this.x1 - this.x0;
        float f3 = this.y1 - this.y0;
        float f4 = this.z1 - this.z0;
        return (f2 + f3 + f4) / 3.0f;
    }

    public AABB shrink(float f2, float f3, float f4) {
        float f5 = this.x0;
        float f6 = this.y0;
        float f7 = this.z0;
        float f8 = this.x1;
        float f9 = this.y1;
        float f10 = this.z1;
        if (f2 < 0.0f) {
            f5 -= f2;
        }
        if (f2 > 0.0f) {
            f8 -= f2;
        }
        if (f3 < 0.0f) {
            f6 -= f3;
        }
        if (f3 > 0.0f) {
            f9 -= f3;
        }
        if (f4 < 0.0f) {
            f7 -= f4;
        }
        if (f4 > 0.0f) {
            f10 -= f4;
        }
        return new AABB(f5, f6, f7, f8, f9, f10);
    }

    public AABB copy() {
        return new AABB(this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
    }

    public g clip(c c2, c c3) {
        c c4 = c2.a(c3, ((AABB)object).x0);
        c c5 = c2.a(c3, ((AABB)object).x1);
        c c6 = c2.b(c3, ((AABB)object).y0);
        c c7 = c2.b(c3, ((AABB)object).y1);
        c c8 = c2.c(c3, ((AABB)object).z0);
        c3 = c2.c(c3, ((AABB)object).z1);
        if (!((AABB)object).a(c4)) {
            c4 = null;
        }
        if (!((AABB)object).a(c5)) {
            c5 = null;
        }
        if (!((AABB)object).b(c6)) {
            c6 = null;
        }
        if (!((AABB)object).b(c7)) {
            c7 = null;
        }
        if (!((AABB)object).c(c8)) {
            c8 = null;
        }
        if (!((AABB)object).c(c3)) {
            c3 = null;
        }
        Object object = null;
        if (c4 != null) {
            object = c4;
        }
        if (c5 != null && (object == null || c2.c(c5) < c2.c((c)object))) {
            object = c5;
        }
        if (c6 != null && (object == null || c2.c(c6) < c2.c((c)object))) {
            object = c6;
        }
        if (c7 != null && (object == null || c2.c(c7) < c2.c((c)object))) {
            object = c7;
        }
        if (c8 != null && (object == null || c2.c(c8) < c2.c((c)object))) {
            object = c8;
        }
        if (c3 != null && (object == null || c2.c(c3) < c2.c((c)object))) {
            object = c3;
        }
        if (object == null) {
            return null;
        }
        int n2 = -1;
        if (object == c4) {
            n2 = 4;
        }
        if (object == c5) {
            n2 = 5;
        }
        if (object == c6) {
            n2 = 0;
        }
        if (object == c7) {
            n2 = 1;
        }
        if (object == c8) {
            n2 = 2;
        }
        if (object == c3) {
            n2 = 3;
        }
        return new g(0, 0, 0, n2, (c)object);
    }

    private boolean a(c c2) {
        if (c2 == null) {
            return false;
        }
        return c2.b >= this.y0 && c2.b <= this.y1 && c2.c >= this.z0 && c2.c <= this.z1;
    }

    private boolean b(c c2) {
        if (c2 == null) {
            return false;
        }
        return c2.a >= this.x0 && c2.a <= this.x1 && c2.c >= this.z0 && c2.c <= this.z1;
    }

    private boolean c(c c2) {
        if (c2 == null) {
            return false;
        }
        return c2.a >= this.x0 && c2.a <= this.x1 && c2.b >= this.y0 && c2.b <= this.y1;
    }
}

