/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.ModsRepository;
import org.betacraft.launcher.OS;
import org.betacraft.launcher.SelectAddons;
import org.betacraft.launcher.SimpleWebAddressFrame;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.Window;

public class InstanceSettings
extends JFrame
implements LanguageElement {
    public JCheckBox proxyCheck;
    public JCheckBox keepOpenCheck;
    public JCheckBox RPCCheck;
    public JCheckBox showConsole;
    public JCheckBox forceUpdate = null;
    public JLabel parametersText;
    public JLabel gameDirText;
    public JLabel javaPathText;
    public JTextField parameters;
    public JLabel dimensions1Text;
    public JLabel dimensions2Text;
    public JTextField dimensions1;
    public JTextField dimensions2;
    public JButton OKButton;
    public JTextField dirPath;
    public JTextField javaPath;
    public JButton dirChooser;
    public JButton javaChooser;
    public JTextField instanceName;
    public JLabel instanceIcon;
    public JButton chooseIcon;
    public JLabel removelabel;
    public JLabel instanceNameText;
    public JButton addons;
    public JButton modrepo;
    static Image img = null;
    static Image image = null;

    public InstanceSettings() {
        System.out.println("Options window opened.");
        this.setIconImage(Window.img);
        this.setTitle(Lang.OPTIONS_TITLE);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        OptionsPanel panel = new OptionsPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.fill = 1;
        constr.gridwidth = 4;
        constr.weightx = 1.0;
        constr.insets = new Insets(10, 10, 0, 10);
        this.proxyCheck = new JCheckBox(Lang.OPTIONS_PROXY);
        this.proxyCheck.setForeground(Color.LIGHT_GRAY);
        this.proxyCheck.setOpaque(false);
        this.proxyCheck.setSelected(Launcher.currentInstance.proxy);
        panel.add((Component)this.proxyCheck, constr);
        constr.insets = new Insets(2, 10, 0, 10);
        ++constr.gridy;
        this.keepOpenCheck = new JCheckBox(Lang.OPTIONS_KEEP_OPEN);
        this.keepOpenCheck.setForeground(Color.LIGHT_GRAY);
        this.keepOpenCheck.setOpaque(false);
        this.keepOpenCheck.setSelected(Launcher.currentInstance.keepopen);
        panel.add((Component)this.keepOpenCheck, constr);
        ++constr.gridy;
        this.RPCCheck = new JCheckBox(Lang.OPTIONS_RPC);
        this.RPCCheck.setForeground(Color.LIGHT_GRAY);
        this.RPCCheck.setOpaque(false);
        this.RPCCheck.setSelected(Launcher.currentInstance.RPC);
        panel.add((Component)this.RPCCheck, constr);
        ++constr.gridy;
        this.parametersText = new JLabel(Lang.OPTIONS_LAUNCH_ARGS);
        this.parametersText.setForeground(Color.LIGHT_GRAY);
        panel.add((Component)this.parametersText, constr);
        ++constr.gridy;
        constr.insets = new Insets(2, 20, 0, 10);
        this.parameters = new JTextField(Launcher.currentInstance.launchArgs, 30);
        panel.add((Component)this.parameters, constr);
        ++constr.gridy;
        constr.insets = new Insets(2, 10, 0, 10);
        this.gameDirText = new JLabel(Lang.INSTANCE_DIRECTORY);
        this.gameDirText.setForeground(Color.LIGHT_GRAY);
        panel.add((Component)this.gameDirText, constr);
        ++constr.gridy;
        constr.fill = 2;
        constr.gridwidth = 3;
        constr.insets = new Insets(2, 20, 0, 10);
        this.dirPath = new JTextField(Launcher.currentInstance.gameDir, 4);
        panel.add((Component)this.dirPath, constr);
        constr.gridx += 3;
        constr.weightx = 0.0;
        constr.gridwidth = 1;
        constr.insets = new Insets(2, 10, 0, 10);
        this.dirChooser = new JButton(Lang.BROWSE);
        this.dirChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser dirChooser = new JFileChooser();
                dirChooser.setCurrentDirectory(new File(BC.get()));
                dirChooser.setDialogTitle(Lang.INSTANCE_GAME_DIRECTORY_TITLE);
                dirChooser.setFileSelectionMode(1);
                dirChooser.setAcceptAllFileFilterUsed(false);
                if (dirChooser.showOpenDialog(Window.instanceSettings) == 0) {
                    System.out.println("getCurrentDirectory(): " + dirChooser.getCurrentDirectory());
                    System.out.println("getSelectedFile() : " + dirChooser.getSelectedFile());
                    File gameDir = null;
                    if (!dirChooser.getSelectedFile().equals(dirChooser.getCurrentDirectory())) {
                        gameDir = !dirChooser.getSelectedFile().isDirectory() ? dirChooser.getCurrentDirectory() : dirChooser.getSelectedFile();
                    }
                    InstanceSettings.this.dirPath.setText(gameDir.getAbsolutePath());
                }
            }
        });
        panel.add((Component)this.dirChooser, constr);
        constr.gridx = 0;
        ++constr.gridy;
        this.javaPathText = new JLabel(Lang.JAVA_EXECUTABLE);
        this.javaPathText.setForeground(Color.LIGHT_GRAY);
        panel.add((Component)this.javaPathText, constr);
        ++constr.gridy;
        constr.gridx = 0;
        constr.gridwidth = 3;
        constr.weightx = 1.0;
        constr.insets = new Insets(2, 20, 0, 10);
        this.javaPath = new JTextField(Launcher.currentInstance.javaPath, 4);
        panel.add((Component)this.javaPath, constr);
        constr.gridx += 3;
        constr.weightx = 0.0;
        constr.gridwidth = 1;
        constr.insets = new Insets(2, 10, 0, 10);
        this.javaChooser = new JButton(Lang.BROWSE);
        this.javaChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser dirChooser = new JFileChooser();
                dirChooser.setCurrentDirectory(new File(BC.get()));
                dirChooser.setDialogTitle(Lang.JAVA_EXECUTABLE);
                dirChooser.setFileSelectionMode(0);
                if (dirChooser.showOpenDialog(Window.instanceSettings) == 0) {
                    File gameDir = dirChooser.getSelectedFile();
                    if (gameDir.getAbsolutePath().endsWith(".plugin") && OS.isMac()) {
                        gameDir = new File(gameDir, "Contents/Home/bin/java");
                    }
                    InstanceSettings.this.javaPath.setText(gameDir.getAbsolutePath());
                }
            }
        });
        panel.add((Component)this.javaChooser, constr);
        constr.fill = 2;
        constr.gridwidth = 1;
        constr.gridx = 0;
        constr.weightx = 0.0;
        constr.insets = new Insets(10, 10, 10, 10);
        ++constr.gridy;
        OptionsPanel resPanel = new OptionsPanel();
        resPanel.setLayout(new BoxLayout(resPanel, 0));
        this.dimensions1Text = new JLabel(Lang.OPTIONS_WIDTH);
        this.dimensions1Text.setForeground(Color.LIGHT_GRAY);
        resPanel.add(this.dimensions1Text);
        resPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.dimensions1 = new JTextField(Integer.toString(Launcher.currentInstance.width), 4);
        resPanel.add(this.dimensions1);
        resPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        this.dimensions2Text = new JLabel(Lang.OPTIONS_HEIGHT);
        this.dimensions2Text.setForeground(Color.LIGHT_GRAY);
        resPanel.add(this.dimensions2Text);
        resPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.dimensions2 = new JTextField(Integer.toString(Launcher.currentInstance.height), 4);
        resPanel.add(this.dimensions2);
        panel.add((Component)resPanel, constr);
        OptionsPanel instanceSettings = new OptionsPanel();
        instanceSettings.setLayout(new GridBagLayout());
        JButton remove = new JButton("x");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(InstanceSettings.this, Lang.INSTANCE_REMOVE_QUESTION, Lang.INSTANCE_REMOVE_TITLE, 0);
                if (result == 0) {
                    Launcher.removeInstance(Launcher.currentInstance.name);
                    InstanceSettings.this.setVisible(false);
                }
            }
        });
        this.removelabel = new JLabel(Lang.INSTANCE_REMOVE_TITLE);
        this.instanceNameText = new JLabel(Lang.INSTANCE_NAME);
        this.instanceIcon = new JLabel(new ImageIcon(Launcher.currentInstance.getIcon()));
        this.chooseIcon = new JButton(Lang.INSTANCE_CHANGE_ICON_NAME);
        this.chooseIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser dirChooser = new JFileChooser();
                dirChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                dirChooser.setDialogTitle(Lang.INSTANCE_CHANGE_ICON_TITLE);
                dirChooser.setFileSelectionMode(2);
                dirChooser.setAcceptAllFileFilterUsed(false);
                if (dirChooser.showOpenDialog(Window.mainWindow) == 0) {
                    File selected = dirChooser.getSelectedFile();
                    try {
                        Launcher.currentInstance.setIcon(selected);
                        InstanceSettings.this.instanceIcon.setIcon(new ImageIcon(Launcher.currentInstance.getIcon()));
                    }
                    catch (Exception ex) {
                        Launcher.currentInstance.setIcon(null);
                        JOptionPane.showMessageDialog(Window.mainWindow, String.format(Lang.INSTANCE_CHANGE_ICON_FAILED, ex.getMessage()), Lang.INSTANCE_CHANGE_ICON_FAILED_TITLE, 0);
                    }
                }
            }
        });
        this.addons = new JButton(Lang.INSTANCE_SELECT_ADDONS);
        this.addons.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Window.addonsList == null) {
                    new SelectAddons();
                } else {
                    Window.addonsList.setVisible(true);
                }
            }
        });
        this.modrepo = new JButton(Lang.INSTANCE_MODS_REPOSITORY);
        this.modrepo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Window.modsRepo == null) {
                    new ModsRepository();
                } else {
                    Window.modsRepo.setVisible(true);
                }
            }
        });
        this.instanceName = new JTextField(Launcher.currentInstance.name, 15);
        this.instanceNameText.setForeground(Color.LIGHT_GRAY);
        this.instanceNameText.setOpaque(false);
        this.removelabel.setForeground(Color.LIGHT_GRAY);
        this.removelabel.setOpaque(false);
        this.instanceName.setOpaque(true);
        GridBagConstraints constr1 = new GridBagConstraints();
        constr1.fill = 2;
        constr1.insets = new Insets(2, 2, 10, 10);
        constr1.gridy = 0;
        constr1.gridx = 0;
        instanceSettings.add((Component)remove, constr1);
        constr1.gridx = 1;
        instanceSettings.add((Component)this.removelabel, constr1);
        constr1.fill = 12;
        constr1.gridx = 0;
        constr1.gridy = 1;
        instanceSettings.add((Component)this.instanceNameText, constr1);
        constr1.gridx = 1;
        instanceSettings.add((Component)this.instanceName, constr1);
        constr1.insets = new Insets(10, 2, 2, 2);
        constr1.gridx = 0;
        constr1.gridy = 2;
        instanceSettings.add((Component)this.instanceIcon, constr1);
        constr1.gridx = 1;
        constr1.gridy = 2;
        constr1.gridwidth = 3;
        constr1.ipadx = 50;
        instanceSettings.add((Component)this.chooseIcon, constr1);
        constr1.gridx = 0;
        constr1.gridy = 3;
        constr1.weightx = 1.0;
        constr1.ipadx = 0;
        constr1.insets = new Insets(25, 2, 2, 2);
        constr1.fill = 2;
        this.showConsole = new JCheckBox(Lang.CONSOLE_OUTPUT);
        this.showConsole.setForeground(Color.LIGHT_GRAY);
        this.showConsole.setOpaque(false);
        this.showConsole.setSelected(Launcher.currentInstance.console);
        instanceSettings.add((Component)this.showConsole, constr1);
        ++constr1.gridy;
        constr1.insets = new Insets(2, 2, 2, 2);
        this.forceUpdate = new JCheckBox(Lang.FORCE_UPDATE);
        this.forceUpdate.setForeground(Color.LIGHT_GRAY);
        this.forceUpdate.setOpaque(false);
        this.forceUpdate.setSelected(Launcher.forceUpdate);
        instanceSettings.add((Component)this.forceUpdate, constr1);
        ++constr1.gridy;
        instanceSettings.add((Component)this.addons, constr1);
        constr1.ipady = 0;
        ++constr1.gridy;
        instanceSettings.add((Component)this.modrepo, constr1);
        OptionsPanel okPanel = new OptionsPanel();
        okPanel.setLayout(new GridBagLayout());
        constr1.fill = 2;
        constr1.gridx = 0;
        constr1.gridy = constr.gridy + 1;
        constr1.weighty = 1.0;
        constr1.insets = new Insets(2, 2, 2, 2);
        constr1.gridwidth = -1;
        constr1.gridheight = 1;
        constr1.weightx = 1.0;
        this.OKButton = new JButton(Lang.OPTIONS_OK);
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InstanceSettings.this.saveOptions()) {
                    InstanceSettings.this.dispose();
                    Window.instanceSettings = null;
                }
            }
        });
        okPanel.add((Component)this.OKButton, constr1);
        okPanel.setBackground(Color.WHITE);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)instanceSettings, "Before");
        this.getContentPane().add((Component)okPanel, "Last");
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
        DocumentListener doc = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.change();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.change();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.change();
            }

            public void change() {
                int i;
                if (InstanceSettings.this.dimensions1.getText().length() > 9) {
                    Window.setTextInField(InstanceSettings.this.dimensions1, "");
                }
                if (InstanceSettings.this.dimensions2.getText().length() > 9) {
                    Window.setTextInField(InstanceSettings.this.dimensions2, "");
                }
                for (i = 0; i < InstanceSettings.this.dimensions1.getText().length(); ++i) {
                    if ("0123456789".indexOf(InstanceSettings.this.dimensions1.getText().charAt(i)) >= 0) continue;
                    Window.setTextInField(InstanceSettings.this.dimensions1, "");
                }
                for (i = 0; i < InstanceSettings.this.dimensions2.getText().length(); ++i) {
                    if ("0123456789".indexOf(InstanceSettings.this.dimensions2.getText().charAt(i)) >= 0) continue;
                    Window.setTextInField(InstanceSettings.this.dimensions2, "");
                }
            }
        };
        this.dimensions1.getDocument().addDocumentListener(doc);
        this.dimensions2.getDocument().addDocumentListener(doc);
        this.setMinimumSize(this.getPreferredSize().getSize());
        this.OKButton.requestFocus();
    }

    @Override
    public void update() {
        this.setTitle(Lang.OPTIONS_TITLE);
        this.proxyCheck.setText(Lang.OPTIONS_PROXY);
        this.keepOpenCheck.setText(Lang.OPTIONS_KEEP_OPEN);
        this.RPCCheck.setText(Lang.OPTIONS_RPC);
        this.parametersText.setText(Lang.OPTIONS_LAUNCH_ARGS);
        this.dirChooser.setText(Lang.BROWSE);
        this.dimensions1Text.setText(Lang.OPTIONS_WIDTH);
        this.dimensions2Text.setText(Lang.OPTIONS_HEIGHT);
        this.removelabel.setText(Lang.INSTANCE_REMOVE_TITLE);
        this.instanceNameText.setText(Lang.INSTANCE_NAME);
        this.chooseIcon.setText(Lang.INSTANCE_CHANGE_ICON_NAME);
        this.addons.setText(Lang.INSTANCE_SELECT_ADDONS);
        this.modrepo.setText(Lang.INSTANCE_MODS_REPOSITORY);
        this.forceUpdate.setText(Lang.FORCE_UPDATE);
        this.OKButton.setText(Lang.OPTIONS_OK);
        this.setMinimumSize(this.getPreferredSize().getSize());
        this.pack();
    }

    public static String checkJava(String jpath) {
        int i = Util.getMajorJavaVersion(jpath);
        if (i == -1) {
            int res = JOptionPane.showConfirmDialog(Window.instanceSettings, Lang.JAVA_INVALID, "", 0);
            if (res == 0) {
                String recommended = Util.findRecommendedJava();
                if (recommended == null) {
                    if (JOptionPane.showConfirmDialog(Window.instanceSettings, Lang.JAVA_RECOMMENDED_NOT_FOUND, "", 0) == 0) {
                        new SimpleWebAddressFrame("https://www.java.com/download/manual.jsp");
                    }
                    return null;
                }
                return recommended;
            }
            return null;
        }
        if (i > 8) {
            int res = JOptionPane.showConfirmDialog(Window.instanceSettings, Lang.JAVA_TOO_RECENT, "", 0);
            if (res == 0) {
                String recommended = Util.findRecommendedJava();
                if (recommended == null) {
                    if (JOptionPane.showConfirmDialog(Window.instanceSettings, Lang.JAVA_RECOMMENDED_NOT_FOUND, "", 0) == 0) {
                        new SimpleWebAddressFrame("https://www.java.com/download/manual.jsp");
                    }
                    return null;
                }
                return recommended;
            }
            return jpath;
        }
        return jpath;
    }

    public boolean saveOptions() {
        String jpath = this.javaPath.getText();
        if (!Launcher.disableWarnings) {
            if ((jpath = InstanceSettings.checkJava(jpath)) == null) {
                return false;
            }
            this.javaPath.setText(jpath);
        }
        Launcher.forceUpdate = this.forceUpdate.isSelected();
        if (!jpath.equals(Launcher.currentInstance.javaPath)) {
            Launcher.currentInstance.isJavaPathNew = true;
        }
        Launcher.currentInstance.javaPath = jpath;
        try {
            Launcher.currentInstance.width = Integer.parseInt(this.dimensions1.getText());
        }
        catch (Exception ex) {
            Launcher.currentInstance.width = 854;
        }
        try {
            Launcher.currentInstance.height = Integer.parseInt(this.dimensions2.getText());
        }
        catch (Exception ex) {
            Launcher.currentInstance.height = 480;
        }
        Launcher.currentInstance.gameDir = this.dirPath.getText();
        Launcher.currentInstance.keepopen = this.keepOpenCheck.isSelected();
        Launcher.currentInstance.proxy = this.proxyCheck.isSelected();
        Launcher.currentInstance.RPC = this.RPCCheck.isSelected();
        Launcher.currentInstance.console = this.showConsole.isSelected();
        Launcher.currentInstance.launchArgs = this.parameters.getText();
        if (!this.instanceName.getText().equals(Launcher.currentInstance.name) && !this.instanceName.getText().equals("")) {
            Launcher.setInstance(Launcher.currentInstance.renameInstance(this.instanceName.getText()));
        }
        Launcher.currentInstance.saveInstance();
        BC.SETTINGS.setProperty("lastInstance", Launcher.currentInstance.name);
        BC.SETTINGS.flushToDisk();
        return true;
    }

    protected static class OptionsPanel
    extends JPanel {
        public OptionsPanel() {
            try {
                image = ImageIO.read(Launcher.class.getResource("/icons/stone.png")).getScaledInstance(32, 32, 16);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            int w = this.getWidth() / 2;
            int h = this.getHeight() / 2;
            if (w <= 0 || h <= 0) {
                return;
            }
            img = this.createImage(w, h);
            Graphics graphics2 = img.getGraphics();
            for (int i = 0; i <= w / 32; ++i) {
                for (int j = 0; j <= h / 32; ++j) {
                    graphics2.drawImage(image, i * 32, j * 32, null);
                }
            }
            graphics2.dispose();
            g.drawImage(img, 0, 0, w * 2, h * 2, null);
        }
    }
}

