/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.patch.PatchException;
import uk.betacraft.legacyfix.patch.impl.BetaForgePatch;
import uk.betacraft.legacyfix.patch.impl.BitDepthPatch;
import uk.betacraft.legacyfix.patch.impl.ClassicPatch;
import uk.betacraft.legacyfix.patch.impl.DeAwtPatch;
import uk.betacraft.legacyfix.patch.impl.DisableControllersPatch;
import uk.betacraft.legacyfix.patch.impl.GameDirPatch;
import uk.betacraft.legacyfix.patch.impl.IndevSoundPatch;
import uk.betacraft.legacyfix.patch.impl.IntelPatch;
import uk.betacraft.legacyfix.patch.impl.Java6PreclassicPatch;
import uk.betacraft.legacyfix.patch.impl.Java6ReferencesPatch;
import uk.betacraft.legacyfix.patch.impl.LWJGLFramePatch;
import uk.betacraft.legacyfix.patch.impl.ModloaderPatch;
import uk.betacraft.legacyfix.patch.impl.MousePatch;
import uk.betacraft.legacyfix.patch.impl.SeecretSaturdayPatch;
import uk.betacraft.legacyfix.patch.impl.TexturePackFolderPatch;
import uk.betacraft.legacyfix.patch.impl.VSyncPatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyFixAgent {
    private static final Map<String, Object> SETTINGS = new HashMap<String, Object>();
    private static final List<Patch> PATCHES = new ArrayList<Patch>();
    private static final JSONObject RELEASE_INFO = new JSONObject(new JSONTokener(new BufferedReader(new InputStreamReader(LegacyFixAgent.class.getResourceAsStream("/releaseInfo.json")))));
    public static final String VERSION = RELEASE_INFO.optString("version", "unknown");
    private static Boolean debug;

    public static void premain(String agentArgs, Instrumentation inst) {
        LFLogger.info("Loading build " + VERSION);
        for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
            String propertyKey = String.valueOf(property.getKey());
            if (!propertyKey.startsWith("lf.") || SETTINGS.containsKey(propertyKey)) continue;
            SETTINGS.put(propertyKey, property.getValue());
        }
        PATCHES.addAll(Arrays.asList(new DisableControllersPatch(), new TexturePackFolderPatch(), new Java6PreclassicPatch(), new Java6ReferencesPatch(), new SeecretSaturdayPatch(), new LWJGLFramePatch(), new IndevSoundPatch(), new BetaForgePatch(), new ModloaderPatch(), new BitDepthPatch(), new ClassicPatch(), new GameDirPatch(), new IntelPatch(), new DeAwtPatch(), new MousePatch(), new VSyncPatch()));
        ArrayList<String> patchStates = new ArrayList<String>();
        for (Patch patch : PATCHES) {
            if (!patch.shouldApply()) continue;
            try {
                patch.apply(inst);
                patchStates.add(patch.getId() + " - Applied");
            }
            catch (PatchException e) {
                patchStates.add(patch.getId() + " - Error: " + e.getMessage());
            }
            catch (Exception e) {
                patchStates.add(patch.getId() + " - Exception, see stacktrace");
                LFLogger.error(patch, (Throwable)e);
            }
        }
        if (!patchStates.isEmpty()) {
            LFLogger.logList("Patches:", patchStates);
        } else {
            LFLogger.log("No patches applied", new String[0]);
        }
    }

    public static Map<String, Object> getSettings() {
        return SETTINGS;
    }

    public static String getSetting(String key, String alt) {
        return LegacyFixAgent.getSettings().containsKey(key) ? (String)LegacyFixAgent.getSettings().get(key) : alt;
    }

    public static boolean isDebug() {
        if (debug == null) {
            debug = LegacyFixAgent.getSettings().containsKey("lf.debug");
        }
        return debug;
    }
}

