/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.patch.impl.launch.LauncherPatch;
import uk.betacraft.legacyfix.patch.impl.launch.LauncherType;
import uk.betacraft.legacyfix.patch.impl.launch.launchers.PrismPatch;
import uk.betacraft.legacyfix.protocol.LegacyURLStreamHandlerFactory;
import uk.betacraft.legacyfix.protocol.impl.LevelHandlerBase;
import uk.betacraft.legacyfix.util.LevelProxyAuthenticator;
import uk.betacraft.legacyfix.util.MinecraftAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyFixLauncher {
    private static final String[] MAIN_CLASS_CANDIDATES = new String[]{"net.minecraft.client.main.Main", "net.minecraft.client.MinecraftApplet", "com.mojang.minecraft.MinecraftApplet"};
    public static List<String> arguments = new LinkedList<String>();
    private static LevelProxyAuthenticator levelProxyAuthenticator = null;
    private static String sessionId = "-";

    public static void main(String[] args) {
        LinkedList<String> parsedArgs = new LinkedList<String>();
        if (args.length > 1 && !args[0].startsWith("--")) {
            parsedArgs.add("--username");
            parsedArgs.add(args[0]);
            if (!args[1].startsWith("--")) {
                parsedArgs.add("--sessionid");
                parsedArgs.add(args[1]);
                sessionId = args[1];
            }
            parsedArgs.addAll(Arrays.asList(args).subList(2, args.length));
        } else {
            parsedArgs.addAll(Arrays.asList(args));
            if (parsedArgs.contains("--sessionid")) {
                sessionId = (String)parsedArgs.get(parsedArgs.indexOf("--sessionid") + 1);
            }
        }
        arguments = parsedArgs;
        if (!LegacyFixLauncher.hasKey("demo")) {
            LegacyFixLauncher.addKey("haspaid");
        }
        if (!LegacyFixLauncher.hasKey("gameDir") && LegacyFixLauncher.hasKey("workDir")) {
            LegacyFixLauncher.setValue("gameDir", LegacyFixLauncher.getValue("workDir", "."));
        }
        if (LauncherPatch.getLauncherType() == LauncherType.PRISM) {
            PrismPatch.downloadAssets();
        }
        URL.setURLStreamHandlerFactory(new LegacyURLStreamHandlerFactory());
        if (LevelHandlerBase.ONLINE_LEVEL_SERVER != null) {
            levelProxyAuthenticator = new LevelProxyAuthenticator();
            levelProxyAuthenticator.start();
        }
        LegacyFixLauncher.launch();
    }

    private static boolean launchEntry(String className) {
        try {
            Class<?> entryClass = ClassLoader.getSystemClassLoader().loadClass(className);
            Class<?> superClass = entryClass.getSuperclass();
            Object instance = entryClass.newInstance();
            if (superClass != null && "java.applet.Applet".equals(superClass.getName())) {
                entryClass.getDeclaredMethod("init", new Class[0]).invoke(instance, new Object[0]);
            } else {
                entryClass.getMethod("main", String[].class).invoke(null, new Object[]{LegacyFixLauncher.getAcceptableArguments()});
            }
            return true;
        }
        catch (ClassNotFoundException entryClass) {
        }
        catch (Throwable t) {
            LFLogger.error("Failed launch main class! Tried \"" + className + "\"");
            LFLogger.error("launchMain", t);
        }
        return false;
    }

    private static void launch() {
        String minecraftAppletClassName = LegacyFixLauncher.getValue("appletClass", null);
        String mainClassName = LegacyFixLauncher.getValue("mainClass", null);
        if (minecraftAppletClassName != null && !LegacyFixLauncher.launchEntry(minecraftAppletClassName)) {
            LFLogger.error("Failed to find explicitly specified applet class: \"" + minecraftAppletClassName + "\"");
            return;
        }
        if (mainClassName != null && !LegacyFixLauncher.launchEntry(mainClassName)) {
            LFLogger.error("Failed to find explicitly specified main class: \"" + mainClassName + "\"");
            return;
        }
        for (String candidate : MAIN_CLASS_CANDIDATES) {
            boolean success = LegacyFixLauncher.launchEntry(candidate);
            LFLogger.debug("Main candidate: " + candidate + ": " + success);
            if (!success) continue;
            return;
        }
        LFLogger.error("Failed to find the starting Minecraft class!");
    }

    private static String[] getAcceptableArguments() {
        LinkedList<String> args = new LinkedList<String>();
        if (LegacyFixLauncher.hasKey("limit13w16a")) {
            args.addAll(LegacyFixLauncher.limit(false));
        } else if (LegacyFixLauncher.hasKey("limit13w23a")) {
            args.addAll(LegacyFixLauncher.limit(true));
        } else {
            args.addAll(arguments);
        }
        return args.toArray(new String[0]);
    }

    private static List<String> limit(boolean is13w23a) {
        LinkedList<String> args = new LinkedList<String>();
        if (LegacyFixLauncher.hasKey("demo")) {
            args.add("--demo");
        }
        if (LegacyFixLauncher.hasKey("fullscreen")) {
            args.add("--fullscreen");
        }
        if (LegacyFixLauncher.hasKey("gameDir")) {
            args.add("--workDir");
            args.add(LegacyFixLauncher.getGameDir());
        }
        if (LegacyFixLauncher.hasKey("server")) {
            args.add("--server");
            args.add(LegacyFixLauncher.getValue("server", "localhost"));
        }
        if (LegacyFixLauncher.hasKey("port")) {
            args.add("--port");
            args.add(LegacyFixLauncher.getValue("port", "25565"));
        }
        if (LegacyFixLauncher.hasKey("username")) {
            args.add("--username");
            args.add(LegacyFixLauncher.getValue("username", "Player"));
        }
        if (LegacyFixLauncher.hasKey("session")) {
            args.add("--session");
            args.add(LegacyFixLauncher.getValue("session", "-"));
        }
        if (is13w23a && LegacyFixLauncher.hasKey("version")) {
            args.add("--version");
            args.add(LegacyFixLauncher.getValue("version", "unknown"));
        }
        LFLogger.debug("Using args: " + args);
        return args;
    }

    public static boolean hasValue(String key) {
        if (!LegacyFixLauncher.hasKey(key)) {
            LFLogger.debug("Key " + key + " not found");
            return false;
        }
        int nextIndex = arguments.indexOf("--" + key) + 1;
        if (arguments.size() <= nextIndex) {
            return false;
        }
        return !arguments.get(nextIndex).startsWith("--");
    }

    public static String getValue(String key, String alt) {
        if (!LegacyFixLauncher.hasKey(key)) {
            LFLogger.debug("Key " + key + " not found");
            return alt;
        }
        if (!LegacyFixLauncher.hasValue(key)) {
            return "true";
        }
        if ("sessionid".equals(key) && levelProxyAuthenticator != null) {
            while (levelProxyAuthenticator.isAlive()) {
            }
        }
        return arguments.get(arguments.indexOf("--" + key) + 1);
    }

    public static void setValue(String key, String val) {
        if (!LegacyFixLauncher.hasKey(key)) {
            arguments.add("--" + key);
            if (val != null) {
                arguments.add(val);
            }
        } else {
            arguments.set(arguments.indexOf("--" + key) + 1, val);
        }
    }

    public static void addKey(String key) {
        arguments.add("--" + key);
    }

    public static boolean hasKey(String key) {
        return arguments.contains("--" + key);
    }

    public static String getUUID() {
        String uuid = LegacyFixLauncher.getValue("uuid", "no-uuid");
        if (uuid.equals("no-uuid")) {
            return MinecraftAPI.getUUID(LegacyFixLauncher.getValue("username", ""));
        }
        return uuid;
    }

    public static String getSessionId() {
        return sessionId;
    }

    public static String getScreenshotsDir() {
        return LegacyFixLauncher.getValue("screenshotsDir", new File(LegacyFixLauncher.getGameDir(), "screenshots").getPath());
    }

    public static String getGameDir() {
        String gameDir = LegacyFixLauncher.getValue("gameDir", null);
        if (gameDir == null) {
            try {
                return new File(".").getCanonicalPath();
            }
            catch (Throwable t) {
                LFLogger.error("LegacyFixLauncher", t);
                return ".";
            }
        }
        return gameDir;
    }

    public static String getAssetsDir() {
        return LegacyFixLauncher.getValue("assetsDir", "assets");
    }

    public static String getAssetIndexPath() {
        String assetIndex = LegacyFixLauncher.getValue("assetIndex", null);
        if (assetIndex == null) {
            return null;
        }
        return new File(LegacyFixLauncher.getAssetsDir(), "indexes/" + assetIndex + ".json").getAbsolutePath();
    }

    public static int getWidth() {
        return Integer.parseInt(LegacyFixLauncher.getValue("width", "854"));
    }

    public static int getHeight() {
        return Integer.parseInt(LegacyFixLauncher.getValue("height", "480"));
    }

    public static boolean getFullscreen() {
        return LegacyFixLauncher.hasKey("fullscreen");
    }

    public static String getFrameName() {
        return LegacyFixLauncher.getValue("frameName", "Minecraft");
    }
}

