/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.protocol.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.LegacyFixLauncher;
import uk.betacraft.legacyfix.protocol.impl.HandlerBase;
import uk.betacraft.legacyfix.util.web.RequestUtil;
import uk.betacraft.legacyfix.util.web.WebData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinServerHandler
extends HandlerBase {
    private static final Pattern JOIN_SERVER_PATTERN = Pattern.compile("(http:\\/\\/((www|session)\\.minecraft\\.net)\\/(game)\\/(joinserver\\.jsp\\?user\\=)(.+)?(\\&sessionId\\=)(.+)?(\\&serverId\\=)(.+)?)");

    public JoinServerHandler(URL u, Pattern patternUsed) {
        super(u, patternUsed);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Matcher matcher = JOIN_SERVER_PATTERN.matcher(this.getURLString());
        if (!matcher.find()) {
            LFLogger.error("JoinServerHandler", "No match for join server URL :(");
            return new ByteArrayInputStream("LF - No match for join server URL".getBytes());
        }
        String sessionId = URLDecoder.decode(matcher.group(8), "UTF-8");
        String serverId = matcher.group(10);
        WebData response = RequestUtil.performJoinServer(LegacyFixLauncher.getUUID(), sessionId, serverId);
        String write = response.getResponseCode() == 204 ? "ok" : "Invalid session (Try restarting your game)";
        return new ByteArrayInputStream(write.getBytes());
    }

    public static List<Pattern> regexPatterns() {
        return Arrays.asList(JOIN_SERVER_PATTERN);
    }
}

