/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch;

import java.io.File;
import java.lang.reflect.Modifier;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.LegacyFixLauncher;

public class PatchHelper {
    public static final CtClass stringClass = ClassPool.getDefault().getOrNull("java.lang.String");
    public static final CtClass floatClass = ClassPool.getDefault().getOrNull("float");
    public static final CtClass intClass = ClassPool.getDefault().getOrNull("int");
    private static CtClass minecraftAppletClass = null;
    private static CtClass mouseHelperClass = null;
    private static CtClass minecraftClass = null;
    private static CtField appletModeField = null;
    private static CtField minecraftField = null;

    public static CtClass findMinecraftAppletClass(ClassPool pool) {
        String path;
        String[] typicalPaths;
        if (minecraftAppletClass != null) {
            return minecraftAppletClass;
        }
        String[] stringArray = typicalPaths = new String[]{"net.minecraft.client.MinecraftApplet", "com.mojang.minecraft.MinecraftApplet"};
        int n = stringArray.length;
        for (int i = 0; i < n && (minecraftAppletClass = pool.getOrNull(path = stringArray[i])) == null; ++i) {
        }
        return minecraftAppletClass;
    }

    public static CtClass findMinecraftClass(ClassPool pool) throws NotFoundException {
        if (minecraftClass != null) {
            return minecraftClass;
        }
        if (minecraftAppletClass == null) {
            PatchHelper.findMinecraftAppletClass(pool);
        }
        if ((minecraftClass = pool.getOrNull("net.minecraft.client.Minecraft")) == null && minecraftAppletClass != null) {
            for (CtField field : minecraftAppletClass.getDeclaredFields()) {
                String className = field.getType().getName();
                if (className.equals("java.awt.Canvas") || className.equals("java.lang.Thread") || className.equals("long")) continue;
                minecraftClass = field.getType();
                LFLogger.debug("Found Minecraft class: " + minecraftClass.getName());
                break;
            }
        }
        return minecraftClass;
    }

    public static CtField findMinecraftField(ClassPool pool) throws NotFoundException {
        if (minecraftField != null) {
            return minecraftField;
        }
        if (minecraftAppletClass == null) {
            PatchHelper.findMinecraftAppletClass(pool);
        }
        for (CtField field : minecraftAppletClass.getDeclaredFields()) {
            String className = field.getType().getName();
            if (className.equals("java.awt.Canvas") || className.equals("java.lang.Thread") || className.equals("long")) continue;
            minecraftField = field;
            LFLogger.debug("Found Minecraft field: " + field.getName());
            return field;
        }
        return minecraftField;
    }

    public static CtField findAppletModeField(ClassPool pool) throws NotFoundException {
        if (appletModeField != null) {
            return appletModeField;
        }
        if (minecraftClass == null) {
            PatchHelper.findMinecraftClass(pool);
        }
        for (CtField field : minecraftClass.getDeclaredFields()) {
            String className = field.getType().getName();
            if (!className.equals("boolean") || !Modifier.isPublic(field.getModifiers())) continue;
            appletModeField = field;
            LFLogger.debug("Found appletMode field: " + appletModeField.getName());
            break;
        }
        return appletModeField;
    }

    public static CtClass findMouseHelperClass(ClassPool pool) throws NotFoundException {
        CtField[] minecraftFields;
        if (mouseHelperClass != null) {
            return mouseHelperClass;
        }
        if (minecraftClass == null) {
            PatchHelper.findMinecraftClass(pool);
        }
        if (minecraftClass == null) {
            return null;
        }
        block0: for (CtField field : minecraftFields = minecraftClass.getDeclaredFields()) {
            CtConstructor[] constructors;
            for (CtConstructor constr : constructors = field.getType().getConstructors()) {
                CtClass[] constrParams = constr.getParameterTypes();
                if (constrParams.length < 1 || !constrParams[0].getName().equals("java.awt.Component") || field.getType().getName().equals(minecraftClass.getName())) continue;
                mouseHelperClass = field.getType();
                LFLogger.debug("Found match for MouseHelper class: " + mouseHelperClass.getName());
                continue block0;
            }
        }
        return mouseHelperClass;
    }

    public static File getIndevMapRenderFromExpectedPath(File file) {
        String fileName = file.getName();
        File expectedFile = new File(new File(System.getProperty("user.home", ".")), fileName).getAbsoluteFile();
        if (!(fileName.startsWith("mc_map_") && fileName.endsWith(".png") && expectedFile.getPath().equals(file.getAbsoluteFile().getPath()))) {
            return null;
        }
        return new File(LegacyFixLauncher.getScreenshotsDir(), fileName).getAbsoluteFile();
    }

    public static boolean isString(ConstPool constPool, int ldcPos) {
        return constPool.getTag(ldcPos) == 8;
    }

    public static boolean isUtf8(ConstPool constPool, int ldcPos) {
        return constPool.getTag(ldcPos) == 1;
    }
}

