/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch.impl;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.patch.PatchException;
import uk.betacraft.legacyfix.patch.PatchHelper;

public class ClassicProgressRendererPatch
extends Patch {
    public ClassicProgressRendererPatch() {
        super("classic-performance", "Improves performance in c0.0.13a - c0.29_02", true);
    }

    public void apply(Instrumentation inst) throws Exception {
        String minecraftRunningRef;
        CtMethod method = this.findProgressRendererPercentageMethod();
        if (method == null) {
            throw new PatchException("No progressPercentage method found");
        }
        CtClass progressRendererClass = method.getDeclaringClass();
        if (progressRendererClass.isFrozen()) {
            progressRendererClass.defrost();
        }
        if (!PatchHelper.findMinecraftClass(pool).getName().equals(progressRendererClass.getName())) {
            for (CtField lastTimeCandidateField : progressRendererClass.getDeclaredFields()) {
                if (!lastTimeCandidateField.getType().getName().equals("long")) continue;
                throw new PatchException("Detected c0.30, patch won't be applied");
            }
        }
        if ((minecraftRunningRef = this.getMinecraftRunningField(progressRendererClass)) == null) {
            throw new PatchException("Reference to Minecraft.running could not be made");
        }
        CtClass helperClass = pool.makeClass("legacyfix.helper.ProgressRendererHelper");
        CtField lastTimeField = CtField.make("public static long lastTime = System.currentTimeMillis();", helperClass);
        helperClass.addField(lastTimeField);
        helperClass.toClass(progressRendererClass.getClass().getClassLoader(), progressRendererClass.getClass().getProtectionDomain());
        Class.forName(helperClass.getName());
        method.insertBefore("long time;if (" + minecraftRunningRef + ") {    if (!((time = System.currentTimeMillis()) - legacyfix.helper.ProgressRendererHelper.lastTime < 0L || time - legacyfix.helper.ProgressRendererHelper.lastTime >= 20L)) {        return;    } else {        legacyfix.helper.ProgressRendererHelper.lastTime = time;    }}");
        inst.redefineClasses(new ClassDefinition(Class.forName(progressRendererClass.getName()), progressRendererClass.toBytecode()));
    }

    private String getMinecraftRunningField(CtClass progressRendererClass) {
        try {
            CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
            String result = "$0";
            if (!progressRendererClass.equals(minecraftClass)) {
                CtField progressRendererMinecraftField = null;
                for (CtField candidateField : progressRendererClass.getDeclaredFields()) {
                    if (!candidateField.getType().getName().equals(minecraftClass.getName())) continue;
                    progressRendererMinecraftField = candidateField;
                    break;
                }
                if (progressRendererMinecraftField == null) {
                    throw new PatchException("No ProgressRenderer.minecraft field found");
                }
                result = result + "." + progressRendererMinecraftField.getName();
            }
            CtField minecraftRunningField = null;
            int count = 0;
            for (CtField candidateField : minecraftClass.getDeclaredFields()) {
                if (!Modifier.isVolatile(candidateField.getModifiers()) || !candidateField.getType().getName().equals("boolean") || ++count != 2) continue;
                minecraftRunningField = candidateField;
                break;
            }
            if (minecraftRunningField == null) {
                throw new PatchException("No Minecraft.running field found");
            }
            return result + "." + minecraftRunningField.getName();
        }
        catch (Exception e) {
            LFLogger.error("classic-performance", (Throwable)e);
            return null;
        }
    }

    private CtMethod findProgressRendererPercentageMethod() {
        try {
            CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
            if (minecraftClass.isFrozen()) {
                minecraftClass.defrost();
            }
            for (CtField ctField : minecraftClass.getDeclaredFields()) {
                CtClass candidateClass = ctField.getType();
                for (CtConstructor candidateConstructor : candidateClass.getDeclaredConstructors()) {
                    CtClass[] paramTypes = candidateConstructor.getParameterTypes();
                    if (paramTypes.length != 1 || !paramTypes[0].getName().equals(minecraftClass.getName())) continue;
                    for (CtMethod candidateMethod : candidateClass.getDeclaredMethods()) {
                        paramTypes = candidateMethod.getParameterTypes();
                        if (paramTypes.length != 1 || !paramTypes[0].getName().equals("int") || !ClassicProgressRendererPatch.isProgressRendererPercentageMethod(candidateMethod)) continue;
                        LFLogger.debug("classic-performance", "Found ProgressRenderer.progressPercentage method:", candidateMethod.getDeclaringClass().getName(), candidateMethod.getName());
                        return candidateMethod;
                    }
                }
            }
            for (CtMember ctMember : minecraftClass.getDeclaredMethods()) {
                CtClass[] paramTypes = ((CtBehavior)ctMember).getParameterTypes();
                if (paramTypes.length != 1 || !paramTypes[0].getName().equals("int") || !ClassicProgressRendererPatch.isProgressRendererPercentageMethod((CtMethod)ctMember)) continue;
                LFLogger.debug("classic-performance", "Found Minecraft.progressPercentage method:", ctMember.getDeclaringClass().getName(), ((CtMethod)ctMember).getName());
                return ctMember;
            }
            return null;
        }
        catch (Throwable t) {
            LFLogger.error("classic-performance", t);
            return null;
        }
    }

    private static boolean isProgressRendererPercentageMethod(CtMethod method) {
        try {
            CodeAttribute codeAttribute = method.getMethodInfo().getCodeAttribute();
            CodeIterator codeIterator = codeAttribute.iterator();
            ConstPool cp = method.getMethodInfo().getConstPool();
            while (codeIterator.hasNext()) {
                String dirtPngCandidate;
                int pos = codeIterator.next();
                int opcode = codeIterator.byteAt(pos);
                if (opcode == 18) {
                    if (!PatchHelper.isString(cp, codeIterator.byteAt(pos + 1))) continue;
                    dirtPngCandidate = cp.getStringInfo(codeIterator.byteAt(pos + 1));
                } else {
                    if (opcode != 19 || !PatchHelper.isUtf8(cp, codeIterator.u16bitAt(pos + 1))) continue;
                    dirtPngCandidate = cp.getStringInfo(codeIterator.u16bitAt(pos + 1));
                }
                if (!"/dirt.png".equals(dirtPngCandidate)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean shouldApply() {
        return super.shouldApply() && pool.getOrNull("com.mojang.minecraft.MinecraftApplet") != null;
    }
}

