/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch.impl;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.patch.PatchException;
import uk.betacraft.legacyfix.patch.PatchHelper;

public class DeAwtPatch
extends Patch {
    private Exception thrown;

    public DeAwtPatch() {
        super("deawt", "Forces the game to use LWJGL's Display instead of AWT's Frame", true);
    }

    public void apply(Instrumentation inst) throws Exception {
        CtClass minecraftAppletClass = PatchHelper.findMinecraftAppletClass(pool);
        if (minecraftAppletClass == null) {
            throw new PatchException("No applet class could be found");
        }
        if (minecraftAppletClass.isFrozen()) {
            minecraftAppletClass.defrost();
        }
        CtField minecraftField = PatchHelper.findMinecraftField(pool);
        CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
        if (minecraftField == null || minecraftClass == null) {
            throw new PatchException("No main Minecraft field could be found");
        }
        CtField appletModeField = PatchHelper.findAppletModeField(pool);
        CtMethod initMethod = minecraftAppletClass.getDeclaredMethod("init");
        initMethod.insertAfter("$0." + minecraftField.getName() + "." + appletModeField.getName() + " = false;Thread mcThread = new Thread($0." + minecraftField.getName() + ", \"Minecraft main thread\");mcThread.start();");
        initMethod.instrument(new ExprEditor(){

            public void edit(MethodCall mc) throws CannotCompileException {
                try {
                    if ("java.awt.Container".equals(mc.getMethod().getDeclaringClass().getName())) {
                        if ("setLayout".equals(mc.getMethodName())) {
                            LFLogger.debug("deAWT", "Found call to setLayout(), erasing");
                            mc.replace("{}");
                        } else if ("add".equals(mc.getMethodName())) {
                            LFLogger.debug("deAWT", "Found call to add(), erasing");
                            mc.replace("{}");
                        } else if ("validate".equals(mc.getMethodName())) {
                            LFLogger.debug("deAWT", "Found call to validate(), erasing");
                            mc.replace("{}");
                        }
                    } else if ("java.awt.Component".equals(mc.getMethod().getDeclaringClass().getName())) {
                        if ("setFocusable".equals(mc.getMethodName())) {
                            LFLogger.debug("deAWT", "Found call to setFocusable(), erasing");
                            mc.replace("{}");
                        } else if ("setFocusTraversalKeysEnabled".equals(mc.getMethodName())) {
                            LFLogger.debug("deAWT", "Found call to setFocusTraversalKeysEnabled(), erasing");
                            mc.replace("{}");
                        }
                    }
                }
                catch (NotFoundException e) {
                    DeAwtPatch.this.thrown = e;
                }
            }
        });
        if (this.thrown != null) {
            throw this.thrown;
        }
        inst.redefineClasses(new ClassDefinition(Class.forName(minecraftAppletClass.getName()), minecraftAppletClass.toBytecode()));
        CtClass javaAppletClass = pool.get("java.applet.Applet");
        CtMethod getParameterMethod = javaAppletClass.getDeclaredMethod("getParameter");
        getParameterMethod.setBody("{    Class launcherClass = ClassLoader.getSystemClassLoader().loadClass(\"uk.betacraft.legacyfix.LegacyFixLauncher\");    java.lang.reflect.Method method = launcherClass.getMethod(\"getValue\", new Class[] {String.class, String.class});    return method.invoke(null, new Object[] {$1, null});}");
        CtMethod getDocumentBaseMethod = javaAppletClass.getDeclaredMethod("getDocumentBase");
        getDocumentBaseMethod.insertBefore("return new java.net.URL(\"http://www.minecraft.net/\");");
        inst.redefineClasses(new ClassDefinition(Class.forName(javaAppletClass.getName()), javaAppletClass.toBytecode()));
        if (minecraftClass.isFrozen()) {
            minecraftClass.defrost();
        }
        minecraftClass.instrument(new ExprEditor(){

            public void edit(MethodCall mc) throws CannotCompileException {
                try {
                    if ("java.awt.Canvas".equals(mc.getClassName()) && PatchHelper.intClass.getName().equals(mc.getMethod().getReturnType().getName())) {
                        mc.replace("$_ = org.lwjgl.opengl.Display." + mc.getMethodName() + "();");
                    }
                }
                catch (NotFoundException e) {
                    DeAwtPatch.this.thrown = e;
                }
            }
        });
        if (this.thrown != null) {
            throw this.thrown;
        }
        CtConstructor minecraftConstructor = minecraftClass.getConstructors()[0];
        CtClass[] paramTypes = minecraftConstructor.getParameterTypes();
        int intCount = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            String className = paramTypes[i].getName();
            if (className.equals("int") && intCount == 0) {
                ++intCount;
                minecraftConstructor.insertBefore("Class legacyfix = ClassLoader.getSystemClassLoader().loadClass(\"uk.betacraft.legacyfix.LegacyFixLauncher\");$" + (i + 1) + " = ((Integer) legacyfix.getMethod(\"getWidth\", null).invoke(null, null)).intValue();$" + (i + 2) + " = ((Integer) legacyfix.getMethod(\"getHeight\", null).invoke(null, null)).intValue();");
                continue;
            }
            if (className.equals("boolean")) {
                minecraftConstructor.insertBefore("Class legacyfix = ClassLoader.getSystemClassLoader().loadClass(\"uk.betacraft.legacyfix.LegacyFixLauncher\");$" + (i + 1) + " = ((Boolean) legacyfix.getMethod(\"getFullscreen\", null).invoke(null, null)).booleanValue();");
                continue;
            }
            if (!className.equals("java.awt.Canvas") && !className.equals(minecraftAppletClass.getName())) continue;
            minecraftConstructor.insertBefore("$" + (i + 1) + " = null;");
        }
        for (CtMethod aMinecraftMethod : minecraftClass.getDeclaredMethods()) {
            ConstPool runConstPool = aMinecraftMethod.getMethodInfo().getConstPool();
            CodeAttribute codeAttribute = aMinecraftMethod.getMethodInfo().getCodeAttribute();
            if (codeAttribute == null) continue;
            CodeIterator codeIterator = codeAttribute.iterator();
            while (codeIterator.hasNext()) {
                int pos = codeIterator.next();
                this.eraseCanvasReferences(codeIterator, runConstPool, pos);
                this.eraseAppletReferences(codeIterator, runConstPool, pos, minecraftAppletClass);
                this.injectShutdownMethod(aMinecraftMethod, codeIterator, runConstPool, pos, minecraftClass);
            }
        }
        inst.redefineClasses(new ClassDefinition(Class.forName(minecraftClass.getName()), minecraftClass.toBytecode()));
    }

    private void eraseCanvasReferences(CodeIterator codeIterator, ConstPool constPool, int pos) {
        if (codeIterator.byteAt(pos) != 42 || codeIterator.byteAt(pos + 1) != 180 || codeIterator.byteAt(pos + 4) != 198 || codeIterator.byteAt(pos + 7) != 42) {
            return;
        }
        int futurePos = pos + 8;
        if (codeIterator.byteAt(futurePos) != 42 && codeIterator.byteAt(futurePos + 3) != 154) {
            return;
        }
        String refType = constPool.getFieldrefType(codeIterator.u16bitAt(pos + 2));
        if (!"Ljava/awt/Canvas;".equals(refType)) {
            return;
        }
        for (int i = 0; i < 7; ++i) {
            codeIterator.writeByte(0, pos + i);
        }
        LFLogger.debug("deawt", "Erased Canvas references");
    }

    private void injectShutdownMethod(CtMethod shutdownMethod, CodeIterator codeIterator, ConstPool constPool, int pos, CtClass minecraftClass) throws NotFoundException, CannotCompileException, BadBytecode {
        if (codeIterator.byteAt(pos) != 184) {
            return;
        }
        String refName = constPool.getMethodrefName(codeIterator.u16bitAt(pos + 1));
        String refClassName = constPool.getMethodrefClassName(codeIterator.u16bitAt(pos + 1));
        if (!"destroy".equals(refName)) {
            return;
        }
        if (!"org.lwjgl.input.Keyboard".equals(refClassName)) {
            return;
        }
        CtMethod runMethod = minecraftClass.getDeclaredMethod("run");
        if (this.doesShutdownFinally(runMethod, shutdownMethod.getName())) {
            return;
        }
        this.addCatchToSetWorld(shutdownMethod, codeIterator, constPool);
        runMethod.insertAfter("$0." + shutdownMethod.getName() + "();", true);
        LFLogger.debug("deawt", "Injected shutdown method call into run() as finally");
    }

    private boolean doesShutdownFinally(CtMethod runMethod, String shutdownMethodName) throws BadBytecode {
        ConstPool constPool = runMethod.getMethodInfo().getConstPool();
        CodeAttribute codeAttribute = runMethod.getMethodInfo().getCodeAttribute();
        CodeIterator codeIterator = codeAttribute.iterator();
        while (codeIterator.hasNext()) {
            int pos = codeIterator.next();
            if (codeIterator.byteAt(pos) != 42 || codeIterator.byteAt(pos + 1) != 182) continue;
            String methodName = constPool.getMethodrefName(codeIterator.u16bitAt(pos + 2));
            String methodSign = constPool.getMethodrefType(codeIterator.u16bitAt(pos + 2));
            if (!methodName.equals(shutdownMethodName) || !"()V".equals(methodSign)) continue;
            return true;
        }
        return false;
    }

    private void addCatchToSetWorld(CtMethod shutdownMethod, CodeIterator codeIterator, ConstPool constPool) throws BadBytecode, CannotCompileException {
        for (int pos = 0; pos < codeIterator.getCodeLength(); ++pos) {
            if (codeIterator.byteAt(pos) != 42 || codeIterator.byteAt(pos + 1) != 1 || codeIterator.byteAt(pos + 2) != 182 || codeIterator.byteAt(pos + 5) == 167 && codeIterator.byteAt(pos + 8) == 76) continue;
            String methodName = constPool.getMethodrefName(codeIterator.u16bitAt(pos + 3));
            for (int i = 0; i < 5; ++i) {
                codeIterator.writeByte(0, pos + i);
            }
            shutdownMethod.insertAt(shutdownMethod.getMethodInfo().getLineNumber(pos), "try {    $0." + methodName + "(null);} catch (Throwable t) {}");
            LFLogger.debug("deawt", "Wrapped setWorld call in a try-catch block in shutdown method");
        }
    }

    private void eraseAppletReferences(CodeIterator codeIterator, ConstPool constPool, int pos, CtClass minecraftAppletClass) {
        this.eraseAppletReferencesClassic0_24(codeIterator, constPool, pos, minecraftAppletClass);
        this.eraseAppletReferencesClassic0_25(codeIterator, constPool, pos, minecraftAppletClass);
        this.eraseAppletReferencesClassic0_30(codeIterator, constPool, pos, minecraftAppletClass);
        this.eraseAppletReferencesIndev(codeIterator, constPool, pos);
    }

    private void eraseAppletReferencesClassic0_24(CodeIterator codeIterator, ConstPool constPool, int pos, CtClass minecraftAppletClass) {
        if (pos != 0) {
            return;
        }
        if (this.eraseAppletReferencesClassic0_24And0_25Shared("getDocumentBase", codeIterator, constPool, pos, minecraftAppletClass)) {
            LFLogger.debug("deawt", "Erased Classic 0.24/0.25 applet references");
        }
    }

    private void eraseAppletReferencesClassic0_25(CodeIterator codeIterator, ConstPool constPool, int pos, CtClass minecraftAppletClass) {
        if (pos != 23) {
            return;
        }
        if (this.eraseAppletReferencesClassic0_24And0_25Shared("getCodeBase", codeIterator, constPool, pos, minecraftAppletClass)) {
            LFLogger.debug("deawt", "Erased Classic 0.25 applet references");
        }
    }

    private boolean eraseAppletReferencesClassic0_24And0_25Shared(String appletMethodCall, CodeIterator codeIterator, ConstPool constPool, int pos, CtClass minecraftAppletClass) {
        if (codeIterator.byteAt(pos) != 42 || codeIterator.byteAt(pos + 1) != 180 || codeIterator.byteAt(pos + 4) != 182 || codeIterator.byteAt(pos + 7) != 182 || codeIterator.byteAt(pos + 10) != 182 || codeIterator.byteAt(pos + 13) != 18 || codeIterator.byteAt(pos + 15) != 182 || codeIterator.byteAt(pos + 18) != 154 || codeIterator.byteAt(pos + 21) != 1 || codeIterator.byteAt(pos + 22) != 76) {
            return false;
        }
        String refType = constPool.getFieldrefType(codeIterator.u16bitAt(pos + 2));
        if (!("L" + minecraftAppletClass.getName().replace('.', '/') + ";").equals(refType)) {
            return false;
        }
        String refName = constPool.getMethodrefName(codeIterator.u16bitAt(pos + 5));
        if (!appletMethodCall.equals(refName)) {
            return false;
        }
        int ldcPos = codeIterator.byteAt(pos + 14);
        if (!PatchHelper.isString(constPool, ldcPos)) {
            return false;
        }
        String host = constPool.getStringInfo(ldcPos);
        if (!"minecraft.net".equals(host)) {
            return false;
        }
        for (int i = 0; i < 23; ++i) {
            codeIterator.writeByte(0, pos + i);
        }
        return true;
    }

    private void eraseAppletReferencesClassic0_30(CodeIterator codeIterator, ConstPool constPool, int pos, CtClass minecraftAppletClass) {
        if (pos != 0) {
            return;
        }
        if (codeIterator.byteAt(pos) != 42 || codeIterator.byteAt(pos + 1) != 180 || codeIterator.byteAt(pos + 4) != 198 || codeIterator.byteAt(pos + 7) != 42 || codeIterator.byteAt(pos + 8) != 180 || codeIterator.byteAt(pos + 11) != 182) {
            return;
        }
        String refType = constPool.getFieldrefType(codeIterator.u16bitAt(pos + 2));
        if (!("L" + minecraftAppletClass.getName().replace('.', '/') + ";").equals(refType)) {
            return;
        }
        String refName = constPool.getMethodrefName(codeIterator.u16bitAt(pos + 12));
        if (!"getDocumentBase".equals(refName)) {
            return;
        }
        for (int i = 0; i < 81; ++i) {
            codeIterator.writeByte(0, pos + i);
        }
        LFLogger.debug("deawt", "Erased Classic 0.30 applet references");
    }

    private void eraseAppletReferencesIndev(CodeIterator codeIterator, ConstPool constPool, int pos) {
        int i;
        if (codeIterator.getCodeLength() <= pos + 29) {
            return;
        }
        if (codeIterator.byteAt(pos) != 187 || codeIterator.byteAt(pos + 29) != 18 && codeIterator.byteAt(pos + 29) != 19) {
            return;
        }
        String value = codeIterator.byteAt(pos + 29) == 18 && PatchHelper.isString(constPool, codeIterator.byteAt(pos + 30)) ? constPool.getStringInfo(codeIterator.byteAt(pos + 30)) : (codeIterator.byteAt(pos + 29) == 19 && PatchHelper.isUtf8(constPool, codeIterator.u16bitAt(pos + 30)) ? constPool.getStringInfo(codeIterator.u16bitAt(pos + 30)) : null);
        if (!"?n=".equals(value)) {
            return;
        }
        int eraseTo = -1;
        for (i = 0; i < codeIterator.getCodeLength() - pos; ++i) {
            if (codeIterator.byteAt(pos + i) != 153) continue;
            eraseTo = i + 3;
        }
        for (i = 0; i < eraseTo; ++i) {
            codeIterator.writeByte(0, pos + i);
        }
        if (eraseTo != -1) {
            LFLogger.debug("deawt", "Erased Indev applet references");
        }
    }
}

