/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch.impl;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import javassist.CtClass;
import javassist.bytecode.ClassFile;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.util.JvmUtils;

public class Java6PreclassicPatch
extends Patch {
    public Java6PreclassicPatch() {
        super("java6-preclassic", "Makes Preclassic playable with Java 5", true);
    }

    public void apply(Instrumentation inst) throws Exception {
        String[] preclassicClasses = new String[]{"RubyDung", "Textures", "Timer", "HitResult", "Entity", "Player", "character.Cube", "character.Polygon", "character.Vec3", "character.Vertex", "character.Zombie", "character.ZombieModel", "level.Chunk", "level.DirtyChunkSorter", "level.Frustum", "level.Level", "level.LevelListener", "level.LevelRenderer", "level.PerlinNoiseFilter", "level.Tesselator", "particle.Particle", "particle.ParticleEngine", "phys.AABB", "level.Tile", "level.tile.Tile", "level.tile.Bush", "level.tile.DirtTile", "level.tile.GrassTile"};
        String[] packages = new String[]{"com.mojang.minecraft", "com.mojang.rubydung"};
        ArrayList<ClassDefinition> defList = new ArrayList<ClassDefinition>();
        for (String aPackage : packages) {
            for (String className : preclassicClasses) {
                CtClass pcClass = pool.getOrNull(aPackage + "." + className);
                if (pcClass == null) continue;
                ClassFile cf = pcClass.getClassFile();
                cf.setMajorVersion(49);
                cf.setVersionToJava5();
                defList.add(new ClassDefinition(pcClass.toClass(), pcClass.toBytecode()));
            }
        }
        if (!defList.isEmpty()) {
            inst.redefineClasses(defList.toArray(new ClassDefinition[0]));
        }
    }

    public boolean shouldApply() {
        return super.shouldApply() && JvmUtils.getJvmVersion() < 6 && (pool.getOrNull("com.mojang.minecraft.RubyDung") != null || pool.getOrNull("com.mojang.rubydung.RubyDung") != null);
    }
}

