/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.protocol.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.protocol.impl.LevelHandlerBase;
import uk.betacraft.legacyfix.protocol.impl.LevelListHandler;
import uk.betacraft.legacyfix.protocol.impl.LevelLoadHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelSaveHandler
extends LevelHandlerBase {
    private static final Pattern LEVEL_SAVE_PATTERN = Pattern.compile("(http:\\/\\/(www\\.)?minecraft\\.net(:(.+)?)?\\/level\\/save\\.html)");

    public LevelSaveHandler(URL u, Pattern patternUsed) {
        super(u, patternUsed);
    }

    private void handleOffline() throws IOException {
        try {
            File levels = new File(LevelListHandler.LEVELS_DIR_PATH);
            byte[] data = this.outputStream.toByteArray();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            String username = in.readUTF();
            String sessionId = in.readUTF();
            String levelName = in.readUTF();
            byte levelId = in.readByte();
            int length = in.readInt();
            byte[] levelData = new byte[length];
            in.read(levelData);
            in.close();
            File level = new File(levels, "level" + levelId + ".dat");
            File levelNames = new File(levels, "levels.txt");
            int maxLevels = 5;
            String[] lvlNames = new String[maxLevels];
            for (int i = 0; i < maxLevels; ++i) {
                lvlNames[i] = "-";
            }
            if (levelNames.exists()) {
                FileInputStream levelNamesStream = new FileInputStream(levelNames);
                lvlNames = new String(LevelLoadHandler.readStream(levelNamesStream)).split(";");
                levelNamesStream.close();
            }
            lvlNames[levelId] = levelName;
            if (levelName.equals("---")) {
                level.delete();
                lvlNames[levelId] = "-";
            } else {
                if (!levels.exists()) {
                    levels.mkdirs();
                }
                FileOutputStream fileOutput = new FileOutputStream(level);
                ((OutputStream)fileOutput).write(levelData);
                ((OutputStream)fileOutput).close();
            }
            FileOutputStream outputNames = new FileOutputStream(levelNames);
            String lvls = "";
            for (int i = 0; i < maxLevels; ++i) {
                lvls = lvls + lvlNames[i] + ";";
            }
            outputNames.write(lvls.getBytes());
            outputNames.close();
        }
        catch (Exception e) {
            LFLogger.error("LevelSaveHandler", (Throwable)e);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException data) {
                // empty catch block
            }
            String err = "error\n" + e.getMessage();
            this.inputStream = new ByteArrayInputStream(err.getBytes());
        }
        this.inputStream = new ByteArrayInputStream("ok".getBytes());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.handleOffline();
        return this.inputStream;
    }

    public static List<Pattern> regexPatterns() {
        return Arrays.asList(LEVEL_SAVE_PATTERN);
    }
}

