/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.protocol.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.protocol.impl.HandlerBase;
import uk.betacraft.legacyfix.util.AssetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIndexHandler
extends HandlerBase {
    private static final Pattern XML_INDEX_PATTERN = Pattern.compile("(http:\\/\\/(s3\\.amazonaws\\.com)\\/(MinecraftResources)\\/)");
    private static final Pattern TXT_INDEX_PATTERN = Pattern.compile("(http:\\/\\/((www\\.)?minecraft\\.net)\\/(resources)\\/)");
    private boolean isXmlRequest = false;

    public ResourceIndexHandler(URL u, Pattern patternUsed) {
        super(u, patternUsed);
        if (XML_INDEX_PATTERN.equals(patternUsed)) {
            this.isXmlRequest = true;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String index = this.isXmlRequest ? AssetUtils.generateXmlIndex() : AssetUtils.generateTxtIndex();
        LFLogger.debug("Serving " + (this.isXmlRequest ? "XML" : "TXT") + " resources index");
        this.inputStream = new ByteArrayInputStream(index.getBytes("UTF-8"));
        return this.inputStream;
    }

    public static List<Pattern> regexPatterns() {
        return Arrays.asList(XML_INDEX_PATTERN, TXT_INDEX_PATTERN);
    }
}

