/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.LegacyFixLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetUtils {
    private static File ASSETS_DIR = null;
    private static File RESOURCES_DIR = null;
    public static List<AssetObject> assets = new LinkedList<AssetObject>();

    private static File getAssetsDir() {
        if (ASSETS_DIR == null) {
            ASSETS_DIR = new File(LegacyFixLauncher.getAssetsDir());
        }
        return ASSETS_DIR;
    }

    private static File getResourcesDir() {
        if (RESOURCES_DIR == null) {
            RESOURCES_DIR = new File(LegacyFixLauncher.getGameDir(), "resources/");
        }
        return RESOURCES_DIR;
    }

    public static JSONObject getAssetIndex() throws FileNotFoundException {
        String assetIndexPath = LegacyFixLauncher.getAssetIndexPath();
        if (assetIndexPath == null) {
            return new JSONObject();
        }
        return new JSONObject(new JSONTokener(new InputStreamReader(new FileInputStream(assetIndexPath)))).getJSONObject("objects");
    }

    public static String generateTxtIndex() {
        try {
            StringBuilder txtIndex = new StringBuilder();
            JSONObject assetIndex = AssetUtils.getAssetIndex();
            AssetUtils.initAssets(assetIndex);
            for (AssetObject assetObject : assets) {
                txtIndex.append(assetObject.key).append(",").append(assetObject.size).append(",0").append("\n");
            }
            return txtIndex.toString();
        }
        catch (Throwable t) {
            LFLogger.error("generateTxtIndex", t);
            return "";
        }
    }

    public static String generateXmlIndex() {
        try {
            Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = xmlDocument.createElement("ListBucketResult");
            xmlDocument.appendChild(rootElement);
            JSONObject assetIndex = AssetUtils.getAssetIndex();
            AssetUtils.initAssets(assetIndex);
            for (AssetObject assetObject : assets) {
                rootElement.appendChild(AssetUtils.makeContentsNode(xmlDocument, assetObject.key, assetObject.size));
            }
            StringWriter stringWriter = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(xmlDocument), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Throwable t) {
            LFLogger.error("generateXmlIndex", t);
            return "";
        }
    }

    public static Element makeContentsNode(Document xmlDocument, String key, long size) {
        Element contentsNode = xmlDocument.createElement("Contents");
        Element keyNode = xmlDocument.createElement("Key");
        keyNode.setTextContent(key);
        contentsNode.appendChild(keyNode);
        Element sizeNode = xmlDocument.createElement("Size");
        sizeNode.setTextContent(Long.toString(size));
        contentsNode.appendChild(sizeNode);
        return contentsNode;
    }

    public static List<File> recursePaths(File startingDir, List<File> list) {
        File[] files = startingDir.listFiles();
        if (files == null) {
            return list;
        }
        for (File localAsset : files) {
            try {
                list.add(localAsset.getCanonicalFile());
            }
            catch (IOException e) {
                LFLogger.error("recursePaths", (Throwable)e);
            }
            if (!localAsset.isDirectory()) continue;
            AssetUtils.recursePaths(localAsset, list);
        }
        return list;
    }

    public static void initAssets(JSONObject assetIndex) {
        assets.clear();
        try {
            LinkedList<File> localAssetsToSkip = new LinkedList<File>();
            for (String key : assetIndex.keySet()) {
                String path;
                long size;
                JSONObject assetObject = assetIndex.getJSONObject(key);
                String hash = assetObject.getString("hash");
                File localAsset = new File(AssetUtils.getResourcesDir(), key).getCanonicalFile();
                localAssetsToSkip.add(localAsset);
                if (localAsset.exists() && localAsset.isFile()) {
                    size = localAsset.length();
                    path = localAsset.getPath();
                } else {
                    size = assetObject.getLong("size");
                    path = new File(AssetUtils.getAssetsDir(), "objects/" + hash.substring(0, 2) + "/" + hash).getPath();
                }
                assets.add(new AssetObject(key, size, path));
            }
            List<File> localAssets = AssetUtils.recursePaths(AssetUtils.getResourcesDir(), new LinkedList<File>());
            localAssets.removeAll(localAssetsToSkip);
            for (File additionalAsset : localAssets) {
                String key;
                if (additionalAsset.isDirectory() || (key = additionalAsset.getCanonicalPath().substring(AssetUtils.getResourcesDir().getCanonicalPath().length() + 1).replace("\\", "/")).startsWith("._") || key.endsWith(".DS_Store") || key.endsWith("Thumbs.db") || key.endsWith("desktop.ini")) continue;
                assets.add(new AssetObject(key, additionalAsset.length(), additionalAsset.getPath()));
            }
            System.setProperty("assets-loaded", "true");
        }
        catch (Throwable t) {
            LFLogger.error("getAssets", t);
        }
    }

    public static String getAssetPathFromExpectedPath(String path) {
        AssetObject asset = AssetUtils.getAssetFromExpectedPath(path);
        if (asset != null) {
            return asset.path;
        }
        return null;
    }

    public static long getAssetSizeFromExpectedPath(String path) {
        AssetObject asset = AssetUtils.getAssetFromExpectedPath(path);
        if (asset != null) {
            return asset.size;
        }
        return -1L;
    }

    public static boolean isExpectedAssetsDir(String path) {
        return AssetUtils.getExpectedAssetsDir().getPath().equals(path);
    }

    public static File getExpectedAssetsDir() {
        if (LegacyFixLauncher.hasKey("usesWorkDir")) {
            return new File(LegacyFixLauncher.getGameDir(), "assets");
        }
        return AssetUtils.getAssetsDir();
    }

    public static File[] getAssetsAsFileArray() {
        if (assets.isEmpty()) {
            try {
                AssetUtils.initAssets(AssetUtils.getAssetIndex());
            }
            catch (FileNotFoundException e) {
                LFLogger.error("getAssetsAsFileArray", (Throwable)e);
            }
        }
        LinkedList<File> listFiles = new LinkedList<File>();
        for (AssetObject asset : assets) {
            listFiles.add(new File(AssetUtils.getExpectedAssetsDir(), asset.key));
        }
        return listFiles.toArray(new File[0]);
    }

    public static AssetObject getAssetFromExpectedPath(String path) {
        if (assets.isEmpty()) {
            try {
                AssetUtils.initAssets(AssetUtils.getAssetIndex());
            }
            catch (FileNotFoundException e) {
                LFLogger.error("getAssetFromExpectedPath", (Throwable)e);
            }
        }
        String winEscaped = path.replace("\\", "/");
        for (AssetObject asset : assets) {
            if (!winEscaped.endsWith(asset.key)) continue;
            return asset;
        }
        return null;
    }

    public static class AssetObject {
        public final String key;
        public final long size;
        public final String path;

        public AssetObject(String key, long size, String path) {
            this.key = key;
            this.size = size;
            this.path = path;
            LFLogger.debug("AssetUtils", key + ", " + size + ", " + path);
        }
    }
}

