/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public class WaterAnimation {
    Minecraft game;
    int tileNumber;
    int tileWidth;
    int tileHeight;
    int frame;
    int numFrames;
    byte[] src;
    byte[] outBuf;
    byte[] temp;
    int minScrollDelay = -1;
    int maxScrollDelay = -1;
    int timer = -1;
    boolean isScrolling;
    boolean isCustom;
    private static Random rand = new Random();

    public WaterAnimation(Minecraft game, String name, int tileNumber, byte[] outBuf) {
        this(game, name, tileNumber, outBuf, -1, -1);
    }

    public WaterAnimation(Minecraft game, String name, int tileNumber, byte[] outBuf, int minScrollDelay, int maxScrollDelay) {
        BufferedImage tiles;
        this.game = game;
        this.tileNumber = tileNumber;
        this.outBuf = outBuf;
        this.minScrollDelay = minScrollDelay;
        this.maxScrollDelay = maxScrollDelay;
        this.isScrolling = minScrollDelay >= 0;
        try {
            tiles = ImageIO.read(Minecraft.class.getResource("/terrain.png"));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        this.tileWidth = tiles.getWidth() / 16;
        this.tileHeight = tiles.getHeight() / 16;
        BufferedImage custom = null;
        try {
            URL customUrl = Minecraft.class.getResource("/custom_" + name + ".png");
            if (customUrl != null) {
                custom = ImageIO.read(customUrl);
            }
        }
        catch (IOException ex2) {
            custom = null;
        }
        if (custom != null) {
            this.numFrames = custom.getHeight() / custom.getWidth();
            if (custom.getWidth() != this.tileWidth) {
                BufferedImage newImage = new BufferedImage(this.tileWidth, this.tileHeight * this.numFrames, 2);
                Graphics2D graphics2D = newImage.createGraphics();
                graphics2D.drawImage(custom, 0, 0, this.tileWidth, this.tileHeight * this.numFrames, null);
                custom = newImage;
            }
            int[] imageBuf = new int[custom.getWidth() * custom.getHeight()];
            custom.getRGB(0, 0, custom.getWidth(), custom.getHeight(), imageBuf, 0, this.tileWidth);
            this.src = new byte[imageBuf.length * 4];
            this.ARGBtoRGBA(imageBuf, this.src);
            this.isCustom = true;
        } else {
            int tileX = tileNumber % 16 * this.tileWidth;
            int tileY = tileNumber / 16 * this.tileHeight;
            int[] imageBuf = new int[this.tileWidth * this.tileHeight];
            tiles.getRGB(tileX, tileY, this.tileWidth, this.tileHeight, imageBuf, 0, this.tileWidth);
            this.ARGBtoRGBA(imageBuf, outBuf);
            if (this.isScrolling) {
                this.temp = new byte[this.tileWidth * 4];
            }
        }
    }

    private void ARGBtoRGBA(int[] src, byte[] dest) {
        for (int i2 = 0; i2 < src.length; ++i2) {
            int v2 = src[i2];
            dest[i2 * 4 + 3] = (byte)(v2 >> 24 & 0xFF);
            dest[i2 * 4 + 0] = (byte)(v2 >> 16 & 0xFF);
            dest[i2 * 4 + 1] = (byte)(v2 >> 8 & 0xFF);
            dest[i2 * 4 + 2] = (byte)(v2 >> 0 & 0xFF);
        }
    }

    public void a() {
        if (this.src != null) {
            if (++this.frame >= this.numFrames) {
                this.frame = 0;
            }
            System.arraycopy(this.src, this.frame * (this.tileHeight * this.tileWidth * 4), this.outBuf, 0, this.tileHeight * this.tileWidth * 4);
        } else if (this.isScrolling && (this.maxScrollDelay <= 0 || --this.timer <= 0)) {
            if (this.maxScrollDelay > 0) {
                this.timer = rand.nextInt(this.maxScrollDelay - this.minScrollDelay + 1) + this.minScrollDelay;
            }
            System.arraycopy(this.outBuf, (this.tileHeight - 1) * this.tileWidth * 4, this.temp, 0, this.tileWidth * 4);
            System.arraycopy(this.outBuf, 0, this.outBuf, this.tileWidth * 4, this.tileWidth * (this.tileHeight - 1) * 4);
            System.arraycopy(this.temp, 0, this.outBuf, 0, this.tileWidth * 4);
        }
    }
}

