/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.MCPatcherUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class Config {
    private File xmlFile = null;
    Document xml;
    static final String TAG_ROOT = "mcpatcherProfile";
    static final String TAG_CONFIG1 = "config";
    static final String TAG_DEBUG = "debug";
    static final String TAG_JAVA_HEAP_SIZE = "javaHeapSize";
    static final String TAG_LAST_VERSION = "lastVersion";
    static final String TAG_BETA_WARNING_SHOWN = "betaWarningShown";
    static final String TAG_MODS = "mods";
    static final String TAG_MOD = "mod";
    static final String TAG_NAME = "name";
    static final String TAG_TYPE = "type";
    static final String TAG_PATH = "path";
    static final String TAG_FILES = "files";
    static final String TAG_FILE = "file";
    static final String TAG_FROM = "from";
    static final String TAG_TO = "to";
    static final String TAG_CLASS = "class";
    static final String TAG_ENABLED = "enabled";
    static final String ATTR_VERSION = "version";
    static final String VAL_BUILTIN = "builtIn";
    static final String VAL_EXTERNAL_ZIP = "externalZip";
    static final String VAL_EXTERNAL_JAR = "externalJar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Config(File minecraftDir) throws ParserConfigurationException {
        File propFile;
        this.xmlFile = new File(minecraftDir, "mcpatcher.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        boolean save = false;
        if (this.xmlFile.exists()) {
            try {
                this.xml = builder.parse(this.xmlFile);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (this.xml == null) {
            this.xml = builder.newDocument();
            this.buildNewProperties();
            save = true;
        }
        if ((propFile = new File(minecraftDir, "mcpatcher.properties")).exists()) {
            FileInputStream is2 = null;
            try {
                is2 = new FileInputStream(propFile);
                this.convertPropertiesToXML(is2);
                save = true;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            finally {
                if (is2 != null) {
                    try {
                        is2.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                propFile.delete();
            }
        }
        if (save) {
            this.saveProperties();
        }
    }

    private void convertPropertiesToXML(InputStream input) throws IOException {
        Properties properties = new Properties();
        properties.load(input);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String tag = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (tag.equals(TAG_DEBUG) || tag.equals(TAG_LAST_VERSION) || tag.equals(TAG_BETA_WARNING_SHOWN) || tag.equals(TAG_JAVA_HEAP_SIZE)) {
                MCPatcherUtils.set(tag, value);
                continue;
            }
            if (!tag.startsWith("HDTexture.") || (tag = tag.substring(10)).equals(TAG_ENABLED)) continue;
            MCPatcherUtils.set("HD Textures", tag, value);
        }
    }

    Element getElement(Element parent, String tag) {
        Element element;
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getElementsByTagName(tag);
        if (list.getLength() == 0) {
            element = this.xml.createElement(tag);
            parent.appendChild(element);
        } else {
            element = (Element)list.item(0);
        }
        return element;
    }

    String getText(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 3: {
                return ((Text)node).getData();
            }
            case 2: {
                return ((Attr)node).getValue();
            }
            case 1: {
                NodeList list = node.getChildNodes();
                for (int i2 = 0; i2 < list.getLength(); ++i2) {
                    Node node1 = list.item(i2);
                    if (node1.getNodeType() != 3) continue;
                    return ((Text)node1).getData();
                }
                break;
            }
        }
        return null;
    }

    void setText(Element parent, String tag, String value) {
        if (parent == null) {
            return;
        }
        Element element = this.getElement(parent, tag);
        while (element.hasChildNodes()) {
            element.removeChild(element.getFirstChild());
        }
        Text text = this.xml.createTextNode(value);
        element.appendChild(text);
    }

    void remove(Node node) {
        if (node != null) {
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    String getText(Element parent, String tag) {
        return this.getText(this.getElement(parent, tag));
    }

    Element getRoot() {
        if (this.xml == null) {
            return null;
        }
        Element root = this.xml.getDocumentElement();
        if (root == null) {
            root = this.xml.createElement(TAG_ROOT);
            this.xml.appendChild(root);
        }
        return root;
    }

    Element getConfig() {
        return this.getElement(this.getRoot(), TAG_CONFIG1);
    }

    Element getConfig(String tag) {
        return this.getElement(this.getConfig(), tag);
    }

    String getConfigValue(String tag) {
        return this.getText(this.getConfig(tag));
    }

    void setConfigValue(String tag, String value) {
        Element element = this.getConfig(tag);
        if (element != null) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            element.appendChild(this.xml.createTextNode(value));
        }
    }

    Element getMods() {
        return this.getElement(this.getRoot(), TAG_MODS);
    }

    boolean hasMod(String mod) {
        Element parent = this.getMods();
        if (parent != null) {
            NodeList list = parent.getElementsByTagName(TAG_MOD);
            for (int i2 = 0; i2 < list.getLength(); ++i2) {
                Element element = (Element)list.item(i2);
                NodeList list1 = element.getElementsByTagName(TAG_NAME);
                if (list1.getLength() <= 0 || !mod.equals(this.getText(element = (Element)list1.item(0)))) continue;
                return true;
            }
        }
        return false;
    }

    Element getMod(String mod) {
        Element parent = this.getMods();
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getElementsByTagName(TAG_MOD);
        for (int i2 = 0; i2 < list.getLength(); ++i2) {
            Element element;
            Node node = list.item(i2);
            if (!(node instanceof Element) || !mod.equals(this.getText(element = (Element)node, TAG_NAME))) continue;
            return element;
        }
        Element element = this.xml.createElement(TAG_MOD);
        parent.appendChild(element);
        Element element1 = this.xml.createElement(TAG_NAME);
        Text text = this.xml.createTextNode(mod);
        element1.appendChild(text);
        element.appendChild(element1);
        element1 = this.xml.createElement(TAG_ENABLED);
        element.appendChild(element1);
        element1 = this.xml.createElement(TAG_TYPE);
        element.appendChild(element1);
        return element;
    }

    void setModEnabled(String mod, boolean enabled) {
        this.setText(this.getMod(mod), TAG_ENABLED, Boolean.toString(enabled));
    }

    Element getModConfig(String mod) {
        return this.getElement(this.getMod(mod), TAG_CONFIG1);
    }

    Element getModConfig(String mod, String tag) {
        return this.getElement(this.getModConfig(mod), tag);
    }

    String getModConfigValue(String mod, String tag) {
        return this.getText(this.getModConfig(mod, tag));
    }

    void setModConfigValue(String mod, String tag, String value) {
        Element element = this.getModConfig(mod, tag);
        if (element != null) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getFirstChild());
            }
            element.appendChild(this.xml.createTextNode(value));
        }
    }

    private void buildNewProperties() {
        if (this.xml != null) {
            this.getRoot();
            this.getConfig();
            this.getMods();
            this.setText(this.getMod("HD Textures"), TAG_ENABLED, "true");
            this.setText(this.getMod("HD Font"), TAG_ENABLED, "true");
            this.setText(this.getMod("Better Grass"), TAG_ENABLED, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean saveProperties() {
        boolean saved = false;
        if (this.xml != null && this.xmlFile != null) {
            FileOutputStream os2 = null;
            try {
                os2 = new FileOutputStream(this.xmlFile);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer trans = factory.newTransformer();
                trans.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(this.xml);
                trans.transform(source, new StreamResult(new OutputStreamWriter((OutputStream)os2, "UTF-8")));
                saved = true;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                if (os2 != null) {
                    try {
                        os2.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        return saved;
    }
}

