/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.TextureUtils;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;

public class CustomAnimation
extends ah {
    private int frame;
    private int numFrames;
    private byte[] src;
    private byte[] temp;
    private int minScrollDelay = -1;
    private int maxScrollDelay = -1;
    private int timer = -1;
    private boolean isScrolling;
    private static Random rand = new Random();

    public CustomAnimation(int tileNumber, int tileImage, int tileSize, String name, int minScrollDelay, int maxScrollDelay) {
        super(tileNumber);
        this.b = tileNumber;
        this.f = tileImage;
        this.e = tileSize;
        this.minScrollDelay = minScrollDelay;
        this.maxScrollDelay = maxScrollDelay;
        this.isScrolling = minScrollDelay >= 0;
        BufferedImage custom = null;
        String customSrc = "custom_" + name + ".png";
        try {
            custom = TextureUtils.getResourceAsBufferedImage("/" + customSrc);
        }
        catch (IOException ex2) {
            // empty catch block
        }
        MCPatcherUtils.log("new CustomAnimation %s, src=%s, buffer size=0x%x, tile=%d", name, custom == null ? "terrain.png" : customSrc, this.a.length, this.b);
        if (custom == null) {
            BufferedImage tiles;
            try {
                tiles = TextureUtils.getResourceAsBufferedImage("/terrain.png");
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return;
            }
            int tileX = tileNumber % 16 * TileSize.int_size;
            int tileY = tileNumber / 16 * TileSize.int_size;
            int[] imageBuf = new int[TileSize.int_numPixels];
            tiles.getRGB(tileX, tileY, TileSize.int_size, TileSize.int_size, imageBuf, 0, TileSize.int_size);
            CustomAnimation.ARGBtoRGBA(imageBuf, this.a);
            if (this.isScrolling) {
                this.temp = new byte[TileSize.int_size * 4];
            }
        } else {
            this.numFrames = custom.getHeight() / custom.getWidth();
            int[] imageBuf = new int[custom.getWidth() * custom.getHeight()];
            custom.getRGB(0, 0, custom.getWidth(), custom.getHeight(), imageBuf, 0, TileSize.int_size);
            this.src = new byte[imageBuf.length * 4];
            CustomAnimation.ARGBtoRGBA(imageBuf, this.src);
        }
    }

    private static void ARGBtoRGBA(int[] src, byte[] dest) {
        for (int i2 = 0; i2 < src.length; ++i2) {
            int v2 = src[i2];
            dest[i2 * 4 + 3] = (byte)(v2 >> 24 & 0xFF);
            dest[i2 * 4 + 0] = (byte)(v2 >> 16 & 0xFF);
            dest[i2 * 4 + 1] = (byte)(v2 >> 8 & 0xFF);
            dest[i2 * 4 + 2] = (byte)(v2 >> 0 & 0xFF);
        }
    }

    public void a() {
        if (this.src != null) {
            if (++this.frame >= this.numFrames) {
                this.frame = 0;
            }
            System.arraycopy(this.src, this.frame * (TileSize.int_size * TileSize.int_size * 4), this.a, 0, TileSize.int_size * TileSize.int_size * 4);
        } else if (this.isScrolling && (this.maxScrollDelay <= 0 || --this.timer <= 0)) {
            if (this.maxScrollDelay > 0) {
                this.timer = rand.nextInt(this.maxScrollDelay - this.minScrollDelay + 1) + this.minScrollDelay;
            }
            System.arraycopy(this.a, (TileSize.int_size - 1) * TileSize.int_size * 4, this.temp, 0, TileSize.int_size * 4);
            System.arraycopy(this.a, 0, this.a, TileSize.int_size * 4, TileSize.int_size * (TileSize.int_size - 1) * 4);
            System.arraycopy(this.temp, 0, this.a, 0, TileSize.int_size * 4);
        }
    }
}

