/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.Config;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class MCPatcherUtils {
    private static File minecraftDir = null;
    private static boolean debug = false;
    private static boolean isGame;
    static Config config;
    public static final String HD_TEXTURES = "HD Textures";
    public static final String HD_FONT = "HD Font";
    public static final String BETTER_GRASS = "Better Grass";
    public static final String ONE_EIGHT = "1.8 Bug Fixes";
    public static final String GLSL_SHADERS = "GLSL Shaders";

    private MCPatcherUtils() {
    }

    static File getDefaultGameDir() {
        String os2 = System.getProperty("os.name").toLowerCase();
        String baseDir = null;
        String subDir = ".minecraft";
        if (os2.contains("win")) {
            baseDir = System.getenv("APPDATA");
        } else if (os2.contains("mac")) {
            subDir = "Library/Application Support/minecraft";
        }
        if (baseDir == null) {
            baseDir = System.getProperty("user.home");
        }
        return new File(baseDir, subDir);
    }

    static boolean setGameDir(File dir) {
        minecraftDir = dir != null && dir.isDirectory() && new File(dir, "bin/lwjgl.jar").exists() && new File(dir, "resources").isDirectory() ? dir.getAbsoluteFile() : null;
        return MCPatcherUtils.loadProperties();
    }

    private static boolean loadProperties() {
        config = null;
        if (minecraftDir != null && minecraftDir.exists()) {
            try {
                config = new Config(minecraftDir);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            debug = MCPatcherUtils.getBoolean("debug", false);
            return true;
        }
        return false;
    }

    public static File getMinecraftPath(String ... subdirs) {
        File f2 = minecraftDir;
        for (String s2 : subdirs) {
            f2 = new File(f2, s2);
        }
        return f2;
    }

    public static void log(String format, Object ... params) {
        if (debug) {
            System.out.printf(format + "\n", params);
        }
    }

    public static boolean isGame() {
        return isGame;
    }

    public static void warn(String format, Object ... params) {
        System.out.printf("WARNING: " + format + "\n", params);
    }

    public static void error(String format, Object ... params) {
        System.out.printf("ERROR: " + format + "\n", params);
    }

    public static String getString(String mod, String tag, Object defaultValue) {
        if (config == null) {
            return defaultValue == null ? null : defaultValue.toString();
        }
        String value = config.getModConfigValue(mod, tag);
        if (value == null && defaultValue != null) {
            value = defaultValue.toString();
            config.setModConfigValue(mod, tag, value);
        }
        return value;
    }

    public static String getString(String tag, Object defaultValue) {
        if (config == null) {
            return defaultValue == null ? null : defaultValue.toString();
        }
        String value = config.getConfigValue(tag);
        if (value == null && defaultValue != null) {
            value = defaultValue.toString();
            config.setConfigValue(tag, value);
        }
        return value;
    }

    public static int getInt(String mod, String tag, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(MCPatcherUtils.getString(mod, tag, defaultValue));
        }
        catch (NumberFormatException e2) {
            value = defaultValue;
        }
        return value;
    }

    public static int getInt(String tag, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(MCPatcherUtils.getString(tag, defaultValue));
        }
        catch (NumberFormatException e2) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getBoolean(String mod, String tag, boolean defaultValue) {
        String value = MCPatcherUtils.getString(mod, tag, defaultValue).toLowerCase();
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        return defaultValue;
    }

    public static boolean getBoolean(String tag, boolean defaultValue) {
        String value = MCPatcherUtils.getString(tag, defaultValue).toLowerCase();
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        return defaultValue;
    }

    public static void set(String mod, String tag, Object value) {
        if (config != null) {
            config.setModConfigValue(mod, tag, value.toString());
        }
    }

    static void set(String tag, Object value) {
        if (config != null) {
            config.setConfigValue(tag, value.toString());
        }
    }

    public static void remove(String mod, String tag) {
        if (config != null) {
            config.remove(config.getModConfig(mod, tag));
        }
    }

    static void remove(String tag) {
        if (config != null) {
            config.remove(config.getConfig(tag));
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void close(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    static {
        config = null;
        isGame = true;
        try {
            if (Class.forName("com.pclewis.mcpatcher.MCPatcher") != null) {
                isGame = false;
            }
        }
        catch (ClassNotFoundException e2) {
        }
        catch (Throwable e3) {
            e3.printStackTrace();
        }
        if (isGame) {
            if (MCPatcherUtils.setGameDir(new File(".")) || MCPatcherUtils.setGameDir(MCPatcherUtils.getDefaultGameDir())) {
                System.out.println("MCPatcherUtils initialized. Directory " + minecraftDir.getPath());
            } else {
                System.out.println("MCPatcherUtils initialized. Current directory " + new File(".").getAbsolutePath());
            }
        }
    }
}

